@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.InternetGatewayAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to create a VPC Internet Gateway Attachment.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.InternetGateway;
 * import com.pulumi.aws.ec2.InternetGatewayAttachment;
 * import com.pulumi.aws.ec2.InternetGatewayAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var exampleInternetGateway = new InternetGateway("exampleInternetGateway");
 *         var exampleInternetGatewayAttachment = new InternetGatewayAttachment("exampleInternetGatewayAttachment", InternetGatewayAttachmentArgs.builder()
 *             .internetGatewayId(exampleInternetGateway.id())
 *             .vpcId(exampleVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Internet Gateway Attachments using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/internetGatewayAttachment:InternetGatewayAttachment example igw-c0a643a9:vpc-123456
 * ```
 * @property internetGatewayId The ID of the internet gateway.
 * @property vpcId The ID of the VPC.
 */
public data class InternetGatewayAttachmentArgs(
    public val internetGatewayId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.InternetGatewayAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ec2.InternetGatewayAttachmentArgs =
        com.pulumi.aws.ec2.InternetGatewayAttachmentArgs.builder()
            .internetGatewayId(internetGatewayId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InternetGatewayAttachmentArgs].
 */
@PulumiTagMarker
public class InternetGatewayAttachmentArgsBuilder internal constructor() {
    private var internetGatewayId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The ID of the internet gateway.
     */
    @JvmName("towmjkkakbmqlmqj")
    public suspend fun internetGatewayId(`value`: Output<String>) {
        this.internetGatewayId = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("yqjfcyrecwabysyb")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the internet gateway.
     */
    @JvmName("usuvjcxgttfweuij")
    public suspend fun internetGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetGatewayId = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("gktvqbpknknxnpfw")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): InternetGatewayAttachmentArgs = InternetGatewayAttachmentArgs(
        internetGatewayId = internetGatewayId,
        vpcId = vpcId,
    )
}
