@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [KeyPair].
 */
@PulumiTagMarker
public class KeyPairResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyPairArgs = KeyPairArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyPairArgsBuilder.() -> Unit) {
        val builder = KeyPairArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KeyPair {
        val builtJavaResource = com.pulumi.aws.ec2.KeyPair(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyPair(builtJavaResource)
    }
}

/**
 * Provides an [EC2 key pair](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) resource. A key pair is used to control login access to EC2 instances.
 * Currently this resource requires an existing user-supplied key pair. This key pair's public key will be registered with AWS to allow logging-in to EC2 instances.
 * When importing an existing key pair the public key material may be in any format supported by AWS. Supported formats (per the [AWS documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html#how-to-generate-your-own-key-and-import-it-to-aws)) are:
 * * OpenSSH public key format (the format in ~/.ssh/authorized_keys)
 * * Base64 encoded DER format
 * * SSH public key file format as specified in RFC4716
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.KeyPair;
 * import com.pulumi.aws.ec2.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployer = new KeyPair("deployer", KeyPairArgs.builder()
 *             .publicKey("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQD3F6tyPEFEzV0LX3X8BsXdMsQz1x2cEikKDEY0aIj41qgxMCP/iteneqXSIFZBp5vizPvaoIR3Um9xK7PGoW8giupGn+EPuxIA4cDM4vzOqOkiMPhz5XK0whEjkVzTo4+S0puvDZuwIsdiW9mxhJc7tgBNL0cYlWSYVkz4G/fslNfRPW5mYAM49f4fhtxPb5ok4Q2Lg9dPKVHO/Bgeu5woMc7RY0p1ej6D4CKFE6lymSDJpW0YHX/wqE9+cfEauh7xZcG0q9t2ta6F6fmX0agvpFyZo8aFbXeUBr7osSCJNgvavWbM/06niWrOvYX2xwWdhXmXSrbX8ZbabVohBK41 email@example.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Key Pairs using the `key_name`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/keyPair:KeyPair deployer deployer-key
 * ```
 *  ~> __NOTE:__ The AWS API does not include the public key in the response, so `pulumi up` will attempt to replace the key pair. There is currently no supported workaround for this limitation.
 */
public class KeyPair internal constructor(
    override val javaResource: com.pulumi.aws.ec2.KeyPair,
) : KotlinCustomResource(javaResource, KeyPairMapper) {
    /**
     * The key pair ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The MD5 public key fingerprint as specified in section 4 of RFC 4716.
     */
    public val fingerprint: Output<String>
        get() = javaResource.fingerprint().applyValue({ args0 -> args0 })

    /**
     * The name for the key pair. If neither `key_name` nor `key_name_prefix` is provided, the provider will create a unique key name.
     */
    public val keyName: Output<String>
        get() = javaResource.keyName().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `key_name`. If neither `key_name` nor `key_name_prefix` is provided, the provider will create a unique key name.
     */
    public val keyNamePrefix: Output<String>
        get() = javaResource.keyNamePrefix().applyValue({ args0 -> args0 })

    /**
     * The key pair ID.
     */
    public val keyPairId: Output<String>
        get() = javaResource.keyPairId().applyValue({ args0 -> args0 })

    /**
     * The type of key pair.
     */
    public val keyType: Output<String>
        get() = javaResource.keyType().applyValue({ args0 -> args0 })

    /**
     * The public key material.
     */
    public val publicKey: Output<String>
        get() = javaResource.publicKey().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object KeyPairMapper : ResourceMapper<KeyPair> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.KeyPair::class == javaResource::class

    override fun map(javaResource: Resource): KeyPair = KeyPair(
        javaResource as
            com.pulumi.aws.ec2.KeyPair,
    )
}

/**
 * @see [KeyPair].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyPair].
 */
public suspend fun keyPair(name: String, block: suspend KeyPairResourceBuilder.() -> Unit):
    KeyPair {
    val builder = KeyPairResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyPair].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyPair(name: String): KeyPair {
    val builder = KeyPairResourceBuilder()
    builder.name(name)
    return builder.build()
}
