@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.LocalGatewayRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Local Gateway Route. More information can be found in the [Outposts User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#routing).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LocalGatewayRoute;
 * import com.pulumi.aws.ec2.LocalGatewayRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocalGatewayRoute("example", LocalGatewayRouteArgs.builder()
 *             .destinationCidrBlock("172.16.0.0/16")
 *             .localGatewayRouteTableId(data.aws_ec2_local_gateway_route_table().example().id())
 *             .localGatewayVirtualInterfaceGroupId(data.aws_ec2_local_gateway_virtual_interface_group().example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_local_gateway_route` using the EC2 Local Gateway Route Table identifier and destination CIDR block separated by underscores (`_`). For example:
 * ```sh
 *  $ pulumi import aws:ec2/localGatewayRoute:LocalGatewayRoute example lgw-rtb-12345678_172.16.0.0/16
 * ```
 * @property destinationCidrBlock IPv4 CIDR range used for destination matches. Routing decisions are based on the most specific match.
 * @property localGatewayRouteTableId Identifier of EC2 Local Gateway Route Table.
 * @property localGatewayVirtualInterfaceGroupId Identifier of EC2 Local Gateway Virtual Interface Group.
 */
public data class LocalGatewayRouteArgs(
    public val destinationCidrBlock: Output<String>? = null,
    public val localGatewayRouteTableId: Output<String>? = null,
    public val localGatewayVirtualInterfaceGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.LocalGatewayRouteArgs> {
    override fun toJava(): com.pulumi.aws.ec2.LocalGatewayRouteArgs =
        com.pulumi.aws.ec2.LocalGatewayRouteArgs.builder()
            .destinationCidrBlock(destinationCidrBlock?.applyValue({ args0 -> args0 }))
            .localGatewayRouteTableId(localGatewayRouteTableId?.applyValue({ args0 -> args0 }))
            .localGatewayVirtualInterfaceGroupId(
                localGatewayVirtualInterfaceGroupId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [LocalGatewayRouteArgs].
 */
@PulumiTagMarker
public class LocalGatewayRouteArgsBuilder internal constructor() {
    private var destinationCidrBlock: Output<String>? = null

    private var localGatewayRouteTableId: Output<String>? = null

    private var localGatewayVirtualInterfaceGroupId: Output<String>? = null

    /**
     * @param value IPv4 CIDR range used for destination matches. Routing decisions are based on the most specific match.
     */
    @JvmName("ydnrlvogfsnqtjmq")
    public suspend fun destinationCidrBlock(`value`: Output<String>) {
        this.destinationCidrBlock = value
    }

    /**
     * @param value Identifier of EC2 Local Gateway Route Table.
     */
    @JvmName("ugixklydupooevel")
    public suspend fun localGatewayRouteTableId(`value`: Output<String>) {
        this.localGatewayRouteTableId = value
    }

    /**
     * @param value Identifier of EC2 Local Gateway Virtual Interface Group.
     */
    @JvmName("hfppmwhrnqwnjmme")
    public suspend fun localGatewayVirtualInterfaceGroupId(`value`: Output<String>) {
        this.localGatewayVirtualInterfaceGroupId = value
    }

    /**
     * @param value IPv4 CIDR range used for destination matches. Routing decisions are based on the most specific match.
     */
    @JvmName("rggrreveyacsdhar")
    public suspend fun destinationCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationCidrBlock = mapped
    }

    /**
     * @param value Identifier of EC2 Local Gateway Route Table.
     */
    @JvmName("kasqlvgcutrurvrp")
    public suspend fun localGatewayRouteTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localGatewayRouteTableId = mapped
    }

    /**
     * @param value Identifier of EC2 Local Gateway Virtual Interface Group.
     */
    @JvmName("jgnwqkdedbppnthh")
    public suspend fun localGatewayVirtualInterfaceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localGatewayVirtualInterfaceGroupId = mapped
    }

    internal fun build(): LocalGatewayRouteArgs = LocalGatewayRouteArgs(
        destinationCidrBlock = destinationCidrBlock,
        localGatewayRouteTableId = localGatewayRouteTableId,
        localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId,
    )
}
