@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [LocalGatewayRouteTableVpcAssociation].
 */
@PulumiTagMarker
public class LocalGatewayRouteTableVpcAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LocalGatewayRouteTableVpcAssociationArgs =
        LocalGatewayRouteTableVpcAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend LocalGatewayRouteTableVpcAssociationArgsBuilder.() -> Unit) {
        val builder = LocalGatewayRouteTableVpcAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LocalGatewayRouteTableVpcAssociation {
        val builtJavaResource =
            com.pulumi.aws.ec2.LocalGatewayRouteTableVpcAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LocalGatewayRouteTableVpcAssociation(builtJavaResource)
    }
}

/**
 * Manages an EC2 Local Gateway Route Table VPC Association. More information can be found in the [Outposts User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html#vpc-associations).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetLocalGatewayRouteTableArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.LocalGatewayRouteTableVpcAssociation;
 * import com.pulumi.aws.ec2.LocalGatewayRouteTableVpcAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var exampleLocalGatewayRouteTable = Ec2Functions.getLocalGatewayRouteTable(GetLocalGatewayRouteTableArgs.builder()
 *             .outpostArn("arn:aws:outposts:us-west-2:123456789012:outpost/op-1234567890abcdef")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var exampleLocalGatewayRouteTableVpcAssociation = new LocalGatewayRouteTableVpcAssociation("exampleLocalGatewayRouteTableVpcAssociation", LocalGatewayRouteTableVpcAssociationArgs.builder()
 *             .localGatewayRouteTableId(exampleLocalGatewayRouteTable.applyValue(getLocalGatewayRouteTableResult -> getLocalGatewayRouteTableResult.id()))
 *             .vpcId(exampleVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_local_gateway_route_table_vpc_association` using the Local Gateway Route Table VPC Association identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2/localGatewayRouteTableVpcAssociation:LocalGatewayRouteTableVpcAssociation example lgw-vpc-assoc-1234567890abcdef
 * ```
 *
 */
public class LocalGatewayRouteTableVpcAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.LocalGatewayRouteTableVpcAssociation,
) : KotlinCustomResource(javaResource, LocalGatewayRouteTableVpcAssociationMapper) {
    public val localGatewayId: Output<String>
        get() = javaResource.localGatewayId().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 Local Gateway Route Table.
     */
    public val localGatewayRouteTableId: Output<String>
        get() = javaResource.localGatewayRouteTableId().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Identifier of EC2 VPC.
     * The following arguments are optional:
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object LocalGatewayRouteTableVpcAssociationMapper :
    ResourceMapper<LocalGatewayRouteTableVpcAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.LocalGatewayRouteTableVpcAssociation::class == javaResource::class

    override fun map(javaResource: Resource): LocalGatewayRouteTableVpcAssociation =
        LocalGatewayRouteTableVpcAssociation(
            javaResource as
                com.pulumi.aws.ec2.LocalGatewayRouteTableVpcAssociation,
        )
}

/**
 * @see [LocalGatewayRouteTableVpcAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LocalGatewayRouteTableVpcAssociation].
 */
public suspend fun localGatewayRouteTableVpcAssociation(
    name: String,
    block: suspend LocalGatewayRouteTableVpcAssociationResourceBuilder.() -> Unit,
):
    LocalGatewayRouteTableVpcAssociation {
    val builder = LocalGatewayRouteTableVpcAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LocalGatewayRouteTableVpcAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun localGatewayRouteTableVpcAssociation(name: String):
    LocalGatewayRouteTableVpcAssociation {
    val builder = LocalGatewayRouteTableVpcAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
