@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.MainRouteTableAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource for managing the main routing table of a VPC.
 * > **NOTE:** **Do not** use both `aws.ec2.DefaultRouteTable` to manage a default route table **and** `aws.ec2.MainRouteTableAssociation` with the same VPC due to possible route conflicts. See aws.ec2.DefaultRouteTable documentation for more details.
 * For more information, see the Amazon VPC User Guide on [Route Tables][aws-route-tables]&#46; For information about managing normal route tables in Pulumi, see [`aws&#46;ec2&#46;RouteTable`][tf-route-tables].
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.MainRouteTableAssociation;
 * import com.pulumi.aws.ec2.MainRouteTableAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mainRouteTableAssociation = new MainRouteTableAssociation("mainRouteTableAssociation", MainRouteTableAssociationArgs.builder()
 *             .vpcId(aws_vpc.foo().id())
 *             .routeTableId(aws_route_table.bar().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Notes
 * On VPC creation, the AWS API always creates an initial Main Route Table. This
 * resource records the ID of that Route Table under `original_route_table_id`.
 * The "Delete" action for a `main_route_table_association` consists of resetting
 * this original table as the Main Route Table for the VPC. You'll see this
 * additional Route Table in the AWS console; it must remain intact in order for
 * the `main_route_table_association` delete to work properly.
 * @property routeTableId The ID of the Route Table to set as the new
 * main route table for the target VPC
 * @property vpcId The ID of the VPC whose main route table should be set
 */
public data class MainRouteTableAssociationArgs(
    public val routeTableId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.MainRouteTableAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.MainRouteTableAssociationArgs =
        com.pulumi.aws.ec2.MainRouteTableAssociationArgs.builder()
            .routeTableId(routeTableId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MainRouteTableAssociationArgs].
 */
@PulumiTagMarker
public class MainRouteTableAssociationArgsBuilder internal constructor() {
    private var routeTableId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The ID of the Route Table to set as the new
     * main route table for the target VPC
     */
    @JvmName("bmcedevhrdrhywxj")
    public suspend fun routeTableId(`value`: Output<String>) {
        this.routeTableId = value
    }

    /**
     * @param value The ID of the VPC whose main route table should be set
     */
    @JvmName("rcrhhsrcmjnordbr")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the Route Table to set as the new
     * main route table for the target VPC
     */
    @JvmName("idswwopyvaphelor")
    public suspend fun routeTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableId = mapped
    }

    /**
     * @param value The ID of the VPC whose main route table should be set
     */
    @JvmName("ehqqysxmlkyrdhex")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): MainRouteTableAssociationArgs = MainRouteTableAssociationArgs(
        routeTableId = routeTableId,
        vpcId = vpcId,
    )
}
