@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagedPrefixListEntry].
 */
@PulumiTagMarker
public class ManagedPrefixListEntryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedPrefixListEntryArgs = ManagedPrefixListEntryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedPrefixListEntryArgsBuilder.() -> Unit) {
        val builder = ManagedPrefixListEntryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedPrefixListEntry {
        val builtJavaResource = com.pulumi.aws.ec2.ManagedPrefixListEntry(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedPrefixListEntry(builtJavaResource)
    }
}

/**
 * Use the `aws_prefix_list_entry` resource to manage a managed prefix list entry.
 * > **NOTE:** Pulumi currently provides two resources for managing Managed Prefix Lists and Managed Prefix List Entries. The standalone resource, Managed Prefix List Entry, is used to manage a single entry. The Managed Prefix List resource is used to manage multiple entries defined in-line. It is important to note that you cannot use a Managed Prefix List with in-line rules in conjunction with any Managed Prefix List Entry resources. This will result in a conflict of entries and will cause the entries to be overwritten.
 * > **NOTE:** To improve execution times on larger updates, it is recommended to use the inline `entry` block as part of the Managed Prefix List resource when creating a prefix list with more than 100 entries. You can find more information about the resource here.
 * ## Example Usage
 * Basic usage.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.ManagedPrefixList;
 * import com.pulumi.aws.ec2.ManagedPrefixListArgs;
 * import com.pulumi.aws.ec2.ManagedPrefixListEntry;
 * import com.pulumi.aws.ec2.ManagedPrefixListEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ManagedPrefixList("example", ManagedPrefixListArgs.builder()
 *             .addressFamily("IPv4")
 *             .maxEntries(5)
 *             .tags(Map.of("Env", "live"))
 *             .build());
 *         var entry1 = new ManagedPrefixListEntry("entry1", ManagedPrefixListEntryArgs.builder()
 *             .cidr(aws_vpc.example().cidr_block())
 *             .description("Primary")
 *             .prefixListId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import prefix list entries using `prefix_list_id` and `cidr` separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ec2/managedPrefixListEntry:ManagedPrefixListEntry default pl-0570a1d2d725c16be,10.0.3.0/24
 * ```
 *
 */
public class ManagedPrefixListEntry internal constructor(
    override val javaResource: com.pulumi.aws.ec2.ManagedPrefixListEntry,
) : KotlinCustomResource(javaResource, ManagedPrefixListEntryMapper) {
    /**
     * CIDR block of this entry.
     */
    public val cidr: Output<String>
        get() = javaResource.cidr().applyValue({ args0 -> args0 })

    /**
     * Description of this entry. Please note that due to API limitations, updating only the description of an entry will require recreating the entry.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * CIDR block of this entry.
     */
    public val prefixListId: Output<String>
        get() = javaResource.prefixListId().applyValue({ args0 -> args0 })
}

public object ManagedPrefixListEntryMapper : ResourceMapper<ManagedPrefixListEntry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.ManagedPrefixListEntry::class == javaResource::class

    override fun map(javaResource: Resource): ManagedPrefixListEntry =
        ManagedPrefixListEntry(javaResource as com.pulumi.aws.ec2.ManagedPrefixListEntry)
}

/**
 * @see [ManagedPrefixListEntry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedPrefixListEntry].
 */
public suspend fun managedPrefixListEntry(
    name: String,
    block: suspend ManagedPrefixListEntryResourceBuilder.() -> Unit,
): ManagedPrefixListEntry {
    val builder = ManagedPrefixListEntryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedPrefixListEntry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedPrefixListEntry(name: String): ManagedPrefixListEntry {
    val builder = ManagedPrefixListEntryResourceBuilder()
    builder.name(name)
    return builder.build()
}
