@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.ManagedPrefixListEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Use the `aws_prefix_list_entry` resource to manage a managed prefix list entry.
 * > **NOTE:** Pulumi currently provides two resources for managing Managed Prefix Lists and Managed Prefix List Entries. The standalone resource, Managed Prefix List Entry, is used to manage a single entry. The Managed Prefix List resource is used to manage multiple entries defined in-line. It is important to note that you cannot use a Managed Prefix List with in-line rules in conjunction with any Managed Prefix List Entry resources. This will result in a conflict of entries and will cause the entries to be overwritten.
 * > **NOTE:** To improve execution times on larger updates, it is recommended to use the inline `entry` block as part of the Managed Prefix List resource when creating a prefix list with more than 100 entries. You can find more information about the resource here.
 * ## Example Usage
 * Basic usage.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.ManagedPrefixList;
 * import com.pulumi.aws.ec2.ManagedPrefixListArgs;
 * import com.pulumi.aws.ec2.ManagedPrefixListEntry;
 * import com.pulumi.aws.ec2.ManagedPrefixListEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ManagedPrefixList("example", ManagedPrefixListArgs.builder()
 *             .addressFamily("IPv4")
 *             .maxEntries(5)
 *             .tags(Map.of("Env", "live"))
 *             .build());
 *         var entry1 = new ManagedPrefixListEntry("entry1", ManagedPrefixListEntryArgs.builder()
 *             .cidr(aws_vpc.example().cidr_block())
 *             .description("Primary")
 *             .prefixListId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import prefix list entries using `prefix_list_id` and `cidr` separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ec2/managedPrefixListEntry:ManagedPrefixListEntry default pl-0570a1d2d725c16be,10.0.3.0/24
 * ```
 * @property cidr CIDR block of this entry.
 * @property description Description of this entry. Please note that due to API limitations, updating only the description of an entry will require recreating the entry.
 * @property prefixListId CIDR block of this entry.
 */
public data class ManagedPrefixListEntryArgs(
    public val cidr: Output<String>? = null,
    public val description: Output<String>? = null,
    public val prefixListId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.ManagedPrefixListEntryArgs> {
    override fun toJava(): com.pulumi.aws.ec2.ManagedPrefixListEntryArgs =
        com.pulumi.aws.ec2.ManagedPrefixListEntryArgs.builder()
            .cidr(cidr?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .prefixListId(prefixListId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedPrefixListEntryArgs].
 */
@PulumiTagMarker
public class ManagedPrefixListEntryArgsBuilder internal constructor() {
    private var cidr: Output<String>? = null

    private var description: Output<String>? = null

    private var prefixListId: Output<String>? = null

    /**
     * @param value CIDR block of this entry.
     */
    @JvmName("yopdndaiggprgywm")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value Description of this entry. Please note that due to API limitations, updating only the description of an entry will require recreating the entry.
     */
    @JvmName("pqnvfyqagcqrqebs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value CIDR block of this entry.
     */
    @JvmName("iejcmdyjwkiybweg")
    public suspend fun prefixListId(`value`: Output<String>) {
        this.prefixListId = value
    }

    /**
     * @param value CIDR block of this entry.
     */
    @JvmName("xhdflwuqcfrbgtww")
    public suspend fun cidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    /**
     * @param value Description of this entry. Please note that due to API limitations, updating only the description of an entry will require recreating the entry.
     */
    @JvmName("pvdxqpnfooauufnp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value CIDR block of this entry.
     */
    @JvmName("delgdjmxttrckrrj")
    public suspend fun prefixListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixListId = mapped
    }

    internal fun build(): ManagedPrefixListEntryArgs = ManagedPrefixListEntryArgs(
        cidr = cidr,
        description = description,
        prefixListId = prefixListId,
    )
}
