@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [NatGateway].
 */
@PulumiTagMarker
public class NatGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NatGatewayArgs = NatGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NatGatewayArgsBuilder.() -> Unit) {
        val builder = NatGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NatGateway {
        val builtJavaResource = com.pulumi.aws.ec2.NatGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NatGateway(builtJavaResource)
    }
}

/**
 * Provides a resource to create a VPC NAT Gateway.
 * ## Example Usage
 * ### Public NAT
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .allocationId(aws_eip.example().id())
 *             .subnetId(aws_subnet.example().id())
 *             .tags(Map.of("Name", "gw NAT"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_internet_gateway.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### Public NAT with Secondary Private IP Addresses
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .allocationId(aws_eip.example().id())
 *             .subnetId(aws_subnet.example().id())
 *             .secondaryAllocationIds(aws_eip.secondary().id())
 *             .secondaryPrivateIpAddresses("10.0.1.5")
 *             .build());
 *     }
 * }
 * ```
 * ### Private NAT
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .connectivityType("private")
 *             .subnetId(aws_subnet.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### Private NAT with Secondary Private IP Addresses
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .connectivityType("private")
 *             .subnetId(aws_subnet.example().id())
 *             .secondaryPrivateIpAddressCount(7)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import NAT Gateways using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/natGateway:NatGateway private_gw nat-05dba92075d71c408
 * ```
 *
 */
public class NatGateway internal constructor(
    override val javaResource: com.pulumi.aws.ec2.NatGateway,
) : KotlinCustomResource(javaResource, NatGatewayMapper) {
    /**
     * The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
     */
    public val allocationId: Output<String>?
        get() = javaResource.allocationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The association ID of the Elastic IP address that's associated with the NAT Gateway. Only available when `connectivity_type` is `public`.
     */
    public val associationId: Output<String>
        get() = javaResource.associationId().applyValue({ args0 -> args0 })

    /**
     * Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
     */
    public val connectivityType: Output<String>?
        get() = javaResource.connectivityType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the network interface associated with the NAT Gateway.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The private IPv4 address to assign to the NAT Gateway. If you don't provide an address, a private IPv4 address will be automatically assigned.
     */
    public val privateIp: Output<String>
        get() = javaResource.privateIp().applyValue({ args0 -> args0 })

    /**
     * The Elastic IP address associated with the NAT Gateway.
     */
    public val publicIp: Output<String>
        get() = javaResource.publicIp().applyValue({ args0 -> args0 })

    /**
     * A list of secondary allocation EIP IDs for this NAT Gateway.
     */
    public val secondaryAllocationIds: Output<List<String>>?
        get() = javaResource.secondaryAllocationIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
     */
    public val secondaryPrivateIpAddressCount: Output<Int>
        get() = javaResource.secondaryPrivateIpAddressCount().applyValue({ args0 -> args0 })

    /**
     * A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     */
    public val secondaryPrivateIpAddresses: Output<List<String>>
        get() = javaResource.secondaryPrivateIpAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * The Subnet ID of the subnet in which to place the NAT Gateway.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object NatGatewayMapper : ResourceMapper<NatGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.NatGateway::class == javaResource::class

    override fun map(javaResource: Resource): NatGateway = NatGateway(
        javaResource as
            com.pulumi.aws.ec2.NatGateway,
    )
}

/**
 * @see [NatGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NatGateway].
 */
public suspend fun natGateway(name: String, block: suspend NatGatewayResourceBuilder.() -> Unit):
    NatGateway {
    val builder = NatGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NatGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun natGateway(name: String): NatGateway {
    val builder = NatGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
