@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.NatGatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to create a VPC NAT Gateway.
 * ## Example Usage
 * ### Public NAT
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .allocationId(aws_eip.example().id())
 *             .subnetId(aws_subnet.example().id())
 *             .tags(Map.of("Name", "gw NAT"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_internet_gateway.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### Public NAT with Secondary Private IP Addresses
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .allocationId(aws_eip.example().id())
 *             .subnetId(aws_subnet.example().id())
 *             .secondaryAllocationIds(aws_eip.secondary().id())
 *             .secondaryPrivateIpAddresses("10.0.1.5")
 *             .build());
 *     }
 * }
 * ```
 * ### Private NAT
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .connectivityType("private")
 *             .subnetId(aws_subnet.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### Private NAT with Secondary Private IP Addresses
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway("example", NatGatewayArgs.builder()
 *             .connectivityType("private")
 *             .subnetId(aws_subnet.example().id())
 *             .secondaryPrivateIpAddressCount(7)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import NAT Gateways using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/natGateway:NatGateway private_gw nat-05dba92075d71c408
 * ```
 * @property allocationId The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
 * @property connectivityType Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
 * @property privateIp The private IPv4 address to assign to the NAT Gateway. If you don't provide an address, a private IPv4 address will be automatically assigned.
 * @property secondaryAllocationIds A list of secondary allocation EIP IDs for this NAT Gateway.
 * @property secondaryPrivateIpAddressCount [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
 * @property secondaryPrivateIpAddresses A list of secondary private IPv4 addresses to assign to the NAT Gateway.
 * @property subnetId The Subnet ID of the subnet in which to place the NAT Gateway.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class NatGatewayArgs(
    public val allocationId: Output<String>? = null,
    public val connectivityType: Output<String>? = null,
    public val privateIp: Output<String>? = null,
    public val secondaryAllocationIds: Output<List<String>>? = null,
    public val secondaryPrivateIpAddressCount: Output<Int>? = null,
    public val secondaryPrivateIpAddresses: Output<List<String>>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.NatGatewayArgs> {
    override fun toJava(): com.pulumi.aws.ec2.NatGatewayArgs =
        com.pulumi.aws.ec2.NatGatewayArgs.builder()
            .allocationId(allocationId?.applyValue({ args0 -> args0 }))
            .connectivityType(connectivityType?.applyValue({ args0 -> args0 }))
            .privateIp(privateIp?.applyValue({ args0 -> args0 }))
            .secondaryAllocationIds(
                secondaryAllocationIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount?.applyValue({ args0 -> args0 }))
            .secondaryPrivateIpAddresses(
                secondaryPrivateIpAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NatGatewayArgs].
 */
@PulumiTagMarker
public class NatGatewayArgsBuilder internal constructor() {
    private var allocationId: Output<String>? = null

    private var connectivityType: Output<String>? = null

    private var privateIp: Output<String>? = null

    private var secondaryAllocationIds: Output<List<String>>? = null

    private var secondaryPrivateIpAddressCount: Output<Int>? = null

    private var secondaryPrivateIpAddresses: Output<List<String>>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
     */
    @JvmName("nyugaqyjpjiaxtjg")
    public suspend fun allocationId(`value`: Output<String>) {
        this.allocationId = value
    }

    /**
     * @param value Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
     */
    @JvmName("vltmfpwxqoawrxkq")
    public suspend fun connectivityType(`value`: Output<String>) {
        this.connectivityType = value
    }

    /**
     * @param value The private IPv4 address to assign to the NAT Gateway. If you don't provide an address, a private IPv4 address will be automatically assigned.
     */
    @JvmName("buxreewxmalersih")
    public suspend fun privateIp(`value`: Output<String>) {
        this.privateIp = value
    }

    /**
     * @param value A list of secondary allocation EIP IDs for this NAT Gateway.
     */
    @JvmName("eniwxjmrdvkfkpeo")
    public suspend fun secondaryAllocationIds(`value`: Output<List<String>>) {
        this.secondaryAllocationIds = value
    }

    @JvmName("bioqfypqnnrjtnga")
    public suspend fun secondaryAllocationIds(vararg values: Output<String>) {
        this.secondaryAllocationIds = Output.all(values.asList())
    }

    /**
     * @param values A list of secondary allocation EIP IDs for this NAT Gateway.
     */
    @JvmName("rlisxaqyfivqmcle")
    public suspend fun secondaryAllocationIds(values: List<Output<String>>) {
        this.secondaryAllocationIds = Output.all(values)
    }

    /**
     * @param value [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
     */
    @JvmName("aqicuaypkqjrffqi")
    public suspend fun secondaryPrivateIpAddressCount(`value`: Output<Int>) {
        this.secondaryPrivateIpAddressCount = value
    }

    /**
     * @param value A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     */
    @JvmName("lpoeeqxbxjumibbm")
    public suspend fun secondaryPrivateIpAddresses(`value`: Output<List<String>>) {
        this.secondaryPrivateIpAddresses = value
    }

    @JvmName("rryonvpwvomojodo")
    public suspend fun secondaryPrivateIpAddresses(vararg values: Output<String>) {
        this.secondaryPrivateIpAddresses = Output.all(values.asList())
    }

    /**
     * @param values A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     */
    @JvmName("uwwxpfrricasmwwr")
    public suspend fun secondaryPrivateIpAddresses(values: List<Output<String>>) {
        this.secondaryPrivateIpAddresses = Output.all(values)
    }

    /**
     * @param value The Subnet ID of the subnet in which to place the NAT Gateway.
     */
    @JvmName("rykntrydjivcmumc")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("todxkecdqbdsoudo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
     */
    @JvmName("mvxyvxrthbiliwip")
    public suspend fun allocationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationId = mapped
    }

    /**
     * @param value Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
     */
    @JvmName("ajflecgblgwktlyt")
    public suspend fun connectivityType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectivityType = mapped
    }

    /**
     * @param value The private IPv4 address to assign to the NAT Gateway. If you don't provide an address, a private IPv4 address will be automatically assigned.
     */
    @JvmName("iupxsqrtimiptxho")
    public suspend fun privateIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIp = mapped
    }

    /**
     * @param value A list of secondary allocation EIP IDs for this NAT Gateway.
     */
    @JvmName("fopqtrhpbpgcigrp")
    public suspend fun secondaryAllocationIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryAllocationIds = mapped
    }

    /**
     * @param values A list of secondary allocation EIP IDs for this NAT Gateway.
     */
    @JvmName("hqevbgywsdqpqmhk")
    public suspend fun secondaryAllocationIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryAllocationIds = mapped
    }

    /**
     * @param value [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
     */
    @JvmName("ivievnvvwsmxmnag")
    public suspend fun secondaryPrivateIpAddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryPrivateIpAddressCount = mapped
    }

    /**
     * @param value A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     */
    @JvmName("wxyqwmejtkkxlqiy")
    public suspend fun secondaryPrivateIpAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryPrivateIpAddresses = mapped
    }

    /**
     * @param values A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     */
    @JvmName("kfjgnwrdxdveycik")
    public suspend fun secondaryPrivateIpAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryPrivateIpAddresses = mapped
    }

    /**
     * @param value The Subnet ID of the subnet in which to place the NAT Gateway.
     */
    @JvmName("foxipmewhdriehnm")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jwulqeqieufjwxdw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("arkfvhjidyigcixt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NatGatewayArgs = NatGatewayArgs(
        allocationId = allocationId,
        connectivityType = connectivityType,
        privateIp = privateIp,
        secondaryAllocationIds = secondaryAllocationIds,
        secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount,
        secondaryPrivateIpAddresses = secondaryPrivateIpAddresses,
        subnetId = subnetId,
        tags = tags,
    )
}
