@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NetworkAclAssociation].
 */
@PulumiTagMarker
public class NetworkAclAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkAclAssociationArgs = NetworkAclAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkAclAssociationArgsBuilder.() -> Unit) {
        val builder = NetworkAclAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkAclAssociation {
        val builtJavaResource = com.pulumi.aws.ec2.NetworkAclAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkAclAssociation(builtJavaResource)
    }
}

/**
 * Provides an network ACL association resource which allows you to associate your network ACL with any subnet(s).
 * > **NOTE on Network ACLs and Network ACL Associations:** the provider provides both a standalone network ACL association resource
 * and a network ACL resource with a `subnet_ids` attribute. Do not use the same subnet ID in both a network ACL
 * resource and a network ACL association resource. Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkAclAssociation;
 * import com.pulumi.aws.ec2.NetworkAclAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new NetworkAclAssociation("main", NetworkAclAssociationArgs.builder()
 *             .networkAclId(aws_network_acl.main().id())
 *             .subnetId(aws_subnet.main().id())
 *             .build());
 *     }
 * }
 * ```
 */
public class NetworkAclAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.NetworkAclAssociation,
) : KotlinCustomResource(javaResource, NetworkAclAssociationMapper) {
    /**
     * The ID of the network ACL.
     */
    public val networkAclId: Output<String>
        get() = javaResource.networkAclId().applyValue({ args0 -> args0 })

    /**
     * The ID of the associated Subnet.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })
}

public object NetworkAclAssociationMapper : ResourceMapper<NetworkAclAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.NetworkAclAssociation::class == javaResource::class

    override fun map(javaResource: Resource): NetworkAclAssociation =
        NetworkAclAssociation(javaResource as com.pulumi.aws.ec2.NetworkAclAssociation)
}

/**
 * @see [NetworkAclAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkAclAssociation].
 */
public suspend fun networkAclAssociation(
    name: String,
    block: suspend NetworkAclAssociationResourceBuilder.() -> Unit,
): NetworkAclAssociation {
    val builder = NetworkAclAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkAclAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkAclAssociation(name: String): NetworkAclAssociation {
    val builder = NetworkAclAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
