@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.NetworkAclAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an network ACL association resource which allows you to associate your network ACL with any subnet(s).
 * > **NOTE on Network ACLs and Network ACL Associations:** the provider provides both a standalone network ACL association resource
 * and a network ACL resource with a `subnet_ids` attribute. Do not use the same subnet ID in both a network ACL
 * resource and a network ACL association resource. Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkAclAssociation;
 * import com.pulumi.aws.ec2.NetworkAclAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new NetworkAclAssociation("main", NetworkAclAssociationArgs.builder()
 *             .networkAclId(aws_network_acl.main().id())
 *             .subnetId(aws_subnet.main().id())
 *             .build());
 *     }
 * }
 * ```
 * @property networkAclId The ID of the network ACL.
 * @property subnetId The ID of the associated Subnet.
 */
public data class NetworkAclAssociationArgs(
    public val networkAclId: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.NetworkAclAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.NetworkAclAssociationArgs =
        com.pulumi.aws.ec2.NetworkAclAssociationArgs.builder()
            .networkAclId(networkAclId?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkAclAssociationArgs].
 */
@PulumiTagMarker
public class NetworkAclAssociationArgsBuilder internal constructor() {
    private var networkAclId: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The ID of the network ACL.
     */
    @JvmName("twaoxcrvqfjablju")
    public suspend fun networkAclId(`value`: Output<String>) {
        this.networkAclId = value
    }

    /**
     * @param value The ID of the associated Subnet.
     */
    @JvmName("xjkvjiajfnriiwkr")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The ID of the network ACL.
     */
    @JvmName("wpvsufwbmmpxmota")
    public suspend fun networkAclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAclId = mapped
    }

    /**
     * @param value The ID of the associated Subnet.
     */
    @JvmName("exlyvhudwgcatmjm")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): NetworkAclAssociationArgs = NetworkAclAssociationArgs(
        networkAclId = networkAclId,
        subnetId = subnetId,
    )
}
