@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NetworkAclRule].
 */
@PulumiTagMarker
public class NetworkAclRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkAclRuleArgs = NetworkAclRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkAclRuleArgsBuilder.() -> Unit) {
        val builder = NetworkAclRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkAclRule {
        val builtJavaResource = com.pulumi.aws.ec2.NetworkAclRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkAclRule(builtJavaResource)
    }
}

/**
 * Creates an entry (a rule) in a network ACL with the specified rule number.
 * > **NOTE on Network ACLs and Network ACL Rules:** This provider currently
 * provides both a standalone Network ACL Rule resource and a Network ACL resource with rules
 * defined in-line. At this time you cannot use a Network ACL with in-line rules
 * in conjunction with any Network ACL Rule resources. Doing so will cause
 * a conflict of rule settings and will overwrite rules.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkAcl;
 * import com.pulumi.aws.ec2.NetworkAclArgs;
 * import com.pulumi.aws.ec2.NetworkAclRule;
 * import com.pulumi.aws.ec2.NetworkAclRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var barNetworkAcl = new NetworkAcl("barNetworkAcl", NetworkAclArgs.builder()
 *             .vpcId(aws_vpc.foo().id())
 *             .build());
 *         var barNetworkAclRule = new NetworkAclRule("barNetworkAclRule", NetworkAclRuleArgs.builder()
 *             .networkAclId(barNetworkAcl.id())
 *             .ruleNumber(200)
 *             .egress(false)
 *             .protocol("tcp")
 *             .ruleAction("allow")
 *             .cidrBlock(aws_vpc.foo().cidr_block())
 *             .fromPort(22)
 *             .toPort(22)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using the procotol's decimal value:
 * __Using `pulumi import` to import__ individual rules using `NETWORK_ACL_ID:RULE_NUMBER:PROTOCOL:EGRESS`, where `PROTOCOL` can be a decimal (such as "6") or string (such as "tcp") value. For example:
 * Using the procotol's string value:
 * ```sh
 *  $ pulumi import aws:ec2/networkAclRule:NetworkAclRule my_rule acl-7aaabd18:100:tcp:false
 * ```
 *  Using the procotol's decimal value:
 * ```sh
 *  $ pulumi import aws:ec2/networkAclRule:NetworkAclRule my_rule acl-7aaabd18:100:6:false
 * ```
 *
 */
public class NetworkAclRule internal constructor(
    override val javaResource: com.pulumi.aws.ec2.NetworkAclRule,
) : KotlinCustomResource(javaResource, NetworkAclRuleMapper) {
    /**
     * The network range to allow or deny, in CIDR notation (for example 172.16.0.0/24 ).
     */
    public val cidrBlock: Output<String>?
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet). Default `false`.
     */
    public val egress: Output<Boolean>?
        get() = javaResource.egress().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The from port to match.
     */
    public val fromPort: Output<Int>?
        get() = javaResource.fromPort().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ICMP protocol: The ICMP code. Required if specifying ICMP for the protocolE.g., -1
     * > **NOTE:** If the value of `protocol` is `-1` or `all`, the `from_port` and `to_port` values will be ignored and the rule will apply to all ports.
     * > **NOTE:** If the value of `icmp_type` is `-1` (which results in a wildcard ICMP type), the `icmp_code` must also be set to `-1` (wildcard ICMP code).
     * > Note: For more information on ICMP types and codes, see here: https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml
     */
    public val icmpCode: Output<Int>?
        get() = javaResource.icmpCode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ICMP protocol: The ICMP type. Required if specifying ICMP for the protocolE.g., -1
     */
    public val icmpType: Output<Int>?
        get() = javaResource.icmpType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The IPv6 CIDR block to allow or deny.
     */
    public val ipv6CidrBlock: Output<String>?
        get() = javaResource.ipv6CidrBlock().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the network ACL.
     */
    public val networkAclId: Output<String>
        get() = javaResource.networkAclId().applyValue({ args0 -> args0 })

    /**
     * The protocol. A value of -1 means all protocols.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * Indicates whether to allow or deny the traffic that matches the rule. Accepted values: `allow` | `deny`
     */
    public val ruleAction: Output<String>
        get() = javaResource.ruleAction().applyValue({ args0 -> args0 })

    /**
     * The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.
     */
    public val ruleNumber: Output<Int>
        get() = javaResource.ruleNumber().applyValue({ args0 -> args0 })

    /**
     * The to port to match.
     */
    public val toPort: Output<Int>?
        get() = javaResource.toPort().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object NetworkAclRuleMapper : ResourceMapper<NetworkAclRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.NetworkAclRule::class == javaResource::class

    override fun map(javaResource: Resource): NetworkAclRule = NetworkAclRule(
        javaResource as
            com.pulumi.aws.ec2.NetworkAclRule,
    )
}

/**
 * @see [NetworkAclRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkAclRule].
 */
public suspend fun networkAclRule(
    name: String,
    block: suspend NetworkAclRuleResourceBuilder.() -> Unit,
): NetworkAclRule {
    val builder = NetworkAclRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkAclRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkAclRule(name: String): NetworkAclRule {
    val builder = NetworkAclRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
