@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.NetworkInsightsAnalysisArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Network Insights Analysis resource. Part of the "Reachability Analyzer" service in the AWS VPC console.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkInsightsPath;
 * import com.pulumi.aws.ec2.NetworkInsightsPathArgs;
 * import com.pulumi.aws.ec2.NetworkInsightsAnalysis;
 * import com.pulumi.aws.ec2.NetworkInsightsAnalysisArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var path = new NetworkInsightsPath("path", NetworkInsightsPathArgs.builder()
 *             .source(aws_network_interface.source().id())
 *             .destination(aws_network_interface.destination().id())
 *             .protocol("tcp")
 *             .build());
 *         var analysis = new NetworkInsightsAnalysis("analysis", NetworkInsightsAnalysisArgs.builder()
 *             .networkInsightsPathId(path.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Network Insights Analyses using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/networkInsightsAnalysis:NetworkInsightsAnalysis test nia-0462085c957f11a55
 * ```
 * @property filterInArns A list of ARNs for resources the path must traverse.
 * @property networkInsightsPathId ID of the Network Insights Path to run an analysis on.
 * The following arguments are optional:
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property waitForCompletion If enabled, the resource will wait for the Network Insights Analysis status to change to `succeeded` or `failed`. Setting this to `false` will skip the process. Default: `true`.
 */
public data class NetworkInsightsAnalysisArgs(
    public val filterInArns: Output<List<String>>? = null,
    public val networkInsightsPathId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val waitForCompletion: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.NetworkInsightsAnalysisArgs> {
    override fun toJava(): com.pulumi.aws.ec2.NetworkInsightsAnalysisArgs =
        com.pulumi.aws.ec2.NetworkInsightsAnalysisArgs.builder()
            .filterInArns(filterInArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .networkInsightsPathId(networkInsightsPathId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .waitForCompletion(waitForCompletion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInsightsAnalysisArgs].
 */
@PulumiTagMarker
public class NetworkInsightsAnalysisArgsBuilder internal constructor() {
    private var filterInArns: Output<List<String>>? = null

    private var networkInsightsPathId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var waitForCompletion: Output<Boolean>? = null

    /**
     * @param value A list of ARNs for resources the path must traverse.
     */
    @JvmName("imwbuctxrfybsnlf")
    public suspend fun filterInArns(`value`: Output<List<String>>) {
        this.filterInArns = value
    }

    @JvmName("ppfbhobxydvukdix")
    public suspend fun filterInArns(vararg values: Output<String>) {
        this.filterInArns = Output.all(values.asList())
    }

    /**
     * @param values A list of ARNs for resources the path must traverse.
     */
    @JvmName("nbmfkuimiyllcaqh")
    public suspend fun filterInArns(values: List<Output<String>>) {
        this.filterInArns = Output.all(values)
    }

    /**
     * @param value ID of the Network Insights Path to run an analysis on.
     * The following arguments are optional:
     */
    @JvmName("pgxhxtiuotjbvwln")
    public suspend fun networkInsightsPathId(`value`: Output<String>) {
        this.networkInsightsPathId = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sqkqhwsgdeeuivju")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value If enabled, the resource will wait for the Network Insights Analysis status to change to `succeeded` or `failed`. Setting this to `false` will skip the process. Default: `true`.
     */
    @JvmName("avjtadtxbryjdxne")
    public suspend fun waitForCompletion(`value`: Output<Boolean>) {
        this.waitForCompletion = value
    }

    /**
     * @param value A list of ARNs for resources the path must traverse.
     */
    @JvmName("hndehntrhfvdbtqk")
    public suspend fun filterInArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterInArns = mapped
    }

    /**
     * @param values A list of ARNs for resources the path must traverse.
     */
    @JvmName("ntalwutjooardtgs")
    public suspend fun filterInArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterInArns = mapped
    }

    /**
     * @param value ID of the Network Insights Path to run an analysis on.
     * The following arguments are optional:
     */
    @JvmName("gvcoolgrborykace")
    public suspend fun networkInsightsPathId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInsightsPathId = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vssnhtyanjkfinvs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gqrgdxyssjdxdgqx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value If enabled, the resource will wait for the Network Insights Analysis status to change to `succeeded` or `failed`. Setting this to `false` will skip the process. Default: `true`.
     */
    @JvmName("gwbvsnueepbjjkrj")
    public suspend fun waitForCompletion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForCompletion = mapped
    }

    internal fun build(): NetworkInsightsAnalysisArgs = NetworkInsightsAnalysisArgs(
        filterInArns = filterInArns,
        networkInsightsPathId = networkInsightsPathId,
        tags = tags,
        waitForCompletion = waitForCompletion,
    )
}
