@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [NetworkInsightsPath].
 */
@PulumiTagMarker
public class NetworkInsightsPathResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkInsightsPathArgs = NetworkInsightsPathArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkInsightsPathArgsBuilder.() -> Unit) {
        val builder = NetworkInsightsPathArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkInsightsPath {
        val builtJavaResource = com.pulumi.aws.ec2.NetworkInsightsPath(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkInsightsPath(builtJavaResource)
    }
}

/**
 * Provides a Network Insights Path resource. Part of the "Reachability Analyzer" service in the AWS VPC console.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkInsightsPath;
 * import com.pulumi.aws.ec2.NetworkInsightsPathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new NetworkInsightsPath("test", NetworkInsightsPathArgs.builder()
 *             .source(aws_network_interface.source().id())
 *             .destination(aws_network_interface.destination().id())
 *             .protocol("tcp")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Network Insights Paths using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/networkInsightsPath:NetworkInsightsPath test nip-00edfba169923aefd
 * ```
 *
 */
public class NetworkInsightsPath internal constructor(
    override val javaResource: com.pulumi.aws.ec2.NetworkInsightsPath,
) : KotlinCustomResource(javaResource, NetworkInsightsPathMapper) {
    /**
     * ARN of the Network Insights Path.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ID or ARN of the resource which is the destination of the path. Can be an Instance, Internet Gateway, Network Interface, Transit Gateway, VPC Endpoint, VPC Peering Connection or VPN Gateway. If the resource is in another account, you must specify an ARN.
     */
    public val destination: Output<String>
        get() = javaResource.destination().applyValue({ args0 -> args0 })

    /**
     * ARN of the destination.
     */
    public val destinationArn: Output<String>
        get() = javaResource.destinationArn().applyValue({ args0 -> args0 })

    /**
     * IP address of the destination resource.
     */
    public val destinationIp: Output<String>?
        get() = javaResource.destinationIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Destination port to analyze access to.
     */
    public val destinationPort: Output<Int>?
        get() = javaResource.destinationPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Protocol to use for analysis. Valid options are `tcp` or `udp`.
     * The following arguments are optional:
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * ID or ARN of the resource which is the source of the path. Can be an Instance, Internet Gateway, Network Interface, Transit Gateway, VPC Endpoint, VPC Peering Connection or VPN Gateway. If the resource is in another account, you must specify an ARN.
     */
    public val source: Output<String>
        get() = javaResource.source().applyValue({ args0 -> args0 })

    /**
     * ARN of the source.
     */
    public val sourceArn: Output<String>
        get() = javaResource.sourceArn().applyValue({ args0 -> args0 })

    /**
     * IP address of the source resource.
     */
    public val sourceIp: Output<String>?
        get() = javaResource.sourceIp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object NetworkInsightsPathMapper : ResourceMapper<NetworkInsightsPath> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.NetworkInsightsPath::class == javaResource::class

    override fun map(javaResource: Resource): NetworkInsightsPath = NetworkInsightsPath(
        javaResource
            as com.pulumi.aws.ec2.NetworkInsightsPath,
    )
}

/**
 * @see [NetworkInsightsPath].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkInsightsPath].
 */
public suspend fun networkInsightsPath(
    name: String,
    block: suspend NetworkInsightsPathResourceBuilder.() -> Unit,
): NetworkInsightsPath {
    val builder = NetworkInsightsPathResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkInsightsPath].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkInsightsPath(name: String): NetworkInsightsPath {
    val builder = NetworkInsightsPathResourceBuilder()
    builder.name(name)
    return builder.build()
}
