@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.NetworkInterfaceAttachment
import com.pulumi.aws.ec2.kotlin.outputs.NetworkInterfaceAttachment.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [NetworkInterface].
 */
@PulumiTagMarker
public class NetworkInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkInterfaceArgs = NetworkInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkInterfaceArgsBuilder.() -> Unit) {
        val builder = NetworkInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkInterface {
        val builtJavaResource = com.pulumi.aws.ec2.NetworkInterface(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkInterface(builtJavaResource)
    }
}

/**
 * Provides an Elastic network interface (ENI) resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkInterface;
 * import com.pulumi.aws.ec2.NetworkInterfaceArgs;
 * import com.pulumi.aws.ec2.inputs.NetworkInterfaceAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new NetworkInterface("test", NetworkInterfaceArgs.builder()
 *             .subnetId(aws_subnet.public_a().id())
 *             .privateIps("10.0.0.50")
 *             .securityGroups(aws_security_group.web().id())
 *             .attachments(NetworkInterfaceAttachmentArgs.builder()
 *                 .instance(aws_instance.test().id())
 *                 .deviceIndex(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Network Interfaces using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/networkInterface:NetworkInterface test eni-e5aa89a3
 * ```
 *
 */
public class NetworkInterface internal constructor(
    override val javaResource: com.pulumi.aws.ec2.NetworkInterface,
) : KotlinCustomResource(javaResource, NetworkInterfaceMapper) {
    /**
     * ARN of the network interface.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block to define the attachment of the ENI. See Attachment below for more details!
     */
    public val attachments: Output<List<NetworkInterfaceAttachment>>
        get() = javaResource.attachments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Description for the network interface.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of network interface to create. Set to `efa` for Elastic Fabric Adapter. Changing `interface_type` will cause the resource to be destroyed and re-created.
     */
    public val interfaceType: Output<String>
        get() = javaResource.interfaceType().applyValue({ args0 -> args0 })

    /**
     * Number of IPv4 prefixes that AWS automatically assigns to the network interface.
     */
    public val ipv4PrefixCount: Output<Int>
        get() = javaResource.ipv4PrefixCount().applyValue({ args0 -> args0 })

    /**
     * One or more IPv4 prefixes assigned to the network interface.
     */
    public val ipv4Prefixes: Output<List<String>>
        get() = javaResource.ipv4Prefixes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Number of IPv6 addresses to assign to a network interface. You can't use this option if specifying specific `ipv6_addresses`. If your subnet has the AssignIpv6AddressOnCreation attribute set to `true`, you can specify `0` to override this setting.
     */
    public val ipv6AddressCount: Output<Int>
        get() = javaResource.ipv6AddressCount().applyValue({ args0 -> args0 })

    /**
     * Whether `ipv6_address_list` is allowed and controls the IPs to assign to the ENI and `ipv6_addresses` and `ipv6_address_count` become read-only. Default false.
     */
    public val ipv6AddressListEnabled: Output<Boolean>?
        get() = javaResource.ipv6AddressListEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of private IPs to assign to the ENI in sequential order.
     */
    public val ipv6AddressLists: Output<List<String>>
        get() = javaResource.ipv6AddressLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Addresses are assigned without regard to order. You can't use this option if you're specifying `ipv6_address_count`.
     */
    public val ipv6Addresses: Output<List<String>>
        get() = javaResource.ipv6Addresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Number of IPv6 prefixes that AWS automatically assigns to the network interface.
     */
    public val ipv6PrefixCount: Output<Int>
        get() = javaResource.ipv6PrefixCount().applyValue({ args0 -> args0 })

    /**
     * One or more IPv6 prefixes assigned to the network interface.
     */
    public val ipv6Prefixes: Output<List<String>>
        get() = javaResource.ipv6Prefixes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * MAC address of the network interface.
     */
    public val macAddress: Output<String>
        get() = javaResource.macAddress().applyValue({ args0 -> args0 })

    public val outpostArn: Output<String>
        get() = javaResource.outpostArn().applyValue({ args0 -> args0 })

    /**
     * AWS account ID of the owner of the network interface.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * Private DNS name of the network interface (IPv4).
     */
    public val privateDnsName: Output<String>
        get() = javaResource.privateDnsName().applyValue({ args0 -> args0 })

    public val privateIp: Output<String>
        get() = javaResource.privateIp().applyValue({ args0 -> args0 })

    /**
     * Whether `private_ip_list` is allowed and controls the IPs to assign to the ENI and `private_ips` and `private_ips_count` become read-only. Default false.
     */
    public val privateIpListEnabled: Output<Boolean>?
        get() = javaResource.privateIpListEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of private IPs to assign to the ENI in sequential order. Requires setting `private_ip_list_enabled` to `true`.
     */
    public val privateIpLists: Output<List<String>>
        get() = javaResource.privateIpLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of private IPs to assign to the ENI without regard to order.
     */
    public val privateIps: Output<List<String>>
        get() = javaResource.privateIps().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Number of secondary private IPs to assign to the ENI. The total number of private IPs will be 1 + `private_ips_count`, as a primary private IP will be assiged to an ENI by default.
     */
    public val privateIpsCount: Output<Int>
        get() = javaResource.privateIpsCount().applyValue({ args0 -> args0 })

    /**
     * List of security group IDs to assign to the ENI.
     */
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Whether to enable source destination checking for the ENI. Default true.
     */
    public val sourceDestCheck: Output<Boolean>?
        get() = javaResource.sourceDestCheck().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Subnet ID to create the ENI in.
     * The following arguments are optional:
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object NetworkInterfaceMapper : ResourceMapper<NetworkInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.NetworkInterface::class == javaResource::class

    override fun map(javaResource: Resource): NetworkInterface = NetworkInterface(
        javaResource as
            com.pulumi.aws.ec2.NetworkInterface,
    )
}

/**
 * @see [NetworkInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkInterface].
 */
public suspend fun networkInterface(
    name: String,
    block: suspend NetworkInterfaceResourceBuilder.() -> Unit,
): NetworkInterface {
    val builder = NetworkInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkInterface(name: String): NetworkInterface {
    val builder = NetworkInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
