@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.NetworkInterfaceArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.NetworkInterfaceAttachmentArgs
import com.pulumi.aws.ec2.kotlin.inputs.NetworkInterfaceAttachmentArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic network interface (ENI) resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkInterface;
 * import com.pulumi.aws.ec2.NetworkInterfaceArgs;
 * import com.pulumi.aws.ec2.inputs.NetworkInterfaceAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new NetworkInterface("test", NetworkInterfaceArgs.builder()
 *             .subnetId(aws_subnet.public_a().id())
 *             .privateIps("10.0.0.50")
 *             .securityGroups(aws_security_group.web().id())
 *             .attachments(NetworkInterfaceAttachmentArgs.builder()
 *                 .instance(aws_instance.test().id())
 *                 .deviceIndex(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Network Interfaces using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/networkInterface:NetworkInterface test eni-e5aa89a3
 * ```
 * @property attachments Configuration block to define the attachment of the ENI. See Attachment below for more details!
 * @property description Description for the network interface.
 * @property interfaceType Type of network interface to create. Set to `efa` for Elastic Fabric Adapter. Changing `interface_type` will cause the resource to be destroyed and re-created.
 * @property ipv4PrefixCount Number of IPv4 prefixes that AWS automatically assigns to the network interface.
 * @property ipv4Prefixes One or more IPv4 prefixes assigned to the network interface.
 * @property ipv6AddressCount Number of IPv6 addresses to assign to a network interface. You can't use this option if specifying specific `ipv6_addresses`. If your subnet has the AssignIpv6AddressOnCreation attribute set to `true`, you can specify `0` to override this setting.
 * @property ipv6AddressListEnabled Whether `ipv6_address_list` is allowed and controls the IPs to assign to the ENI and `ipv6_addresses` and `ipv6_address_count` become read-only. Default false.
 * @property ipv6AddressLists List of private IPs to assign to the ENI in sequential order.
 * @property ipv6Addresses One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Addresses are assigned without regard to order. You can't use this option if you're specifying `ipv6_address_count`.
 * @property ipv6PrefixCount Number of IPv6 prefixes that AWS automatically assigns to the network interface.
 * @property ipv6Prefixes One or more IPv6 prefixes assigned to the network interface.
 * @property privateIp
 * @property privateIpListEnabled Whether `private_ip_list` is allowed and controls the IPs to assign to the ENI and `private_ips` and `private_ips_count` become read-only. Default false.
 * @property privateIpLists List of private IPs to assign to the ENI in sequential order. Requires setting `private_ip_list_enabled` to `true`.
 * @property privateIps List of private IPs to assign to the ENI without regard to order.
 * @property privateIpsCount Number of secondary private IPs to assign to the ENI. The total number of private IPs will be 1 + `private_ips_count`, as a primary private IP will be assiged to an ENI by default.
 * @property securityGroups List of security group IDs to assign to the ENI.
 * @property sourceDestCheck Whether to enable source destination checking for the ENI. Default true.
 * @property subnetId Subnet ID to create the ENI in.
 * The following arguments are optional:
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class NetworkInterfaceArgs(
    public val attachments: Output<List<NetworkInterfaceAttachmentArgs>>? = null,
    public val description: Output<String>? = null,
    public val interfaceType: Output<String>? = null,
    public val ipv4PrefixCount: Output<Int>? = null,
    public val ipv4Prefixes: Output<List<String>>? = null,
    public val ipv6AddressCount: Output<Int>? = null,
    public val ipv6AddressListEnabled: Output<Boolean>? = null,
    public val ipv6AddressLists: Output<List<String>>? = null,
    public val ipv6Addresses: Output<List<String>>? = null,
    public val ipv6PrefixCount: Output<Int>? = null,
    public val ipv6Prefixes: Output<List<String>>? = null,
    public val privateIp: Output<String>? = null,
    public val privateIpListEnabled: Output<Boolean>? = null,
    public val privateIpLists: Output<List<String>>? = null,
    public val privateIps: Output<List<String>>? = null,
    public val privateIpsCount: Output<Int>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val sourceDestCheck: Output<Boolean>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.NetworkInterfaceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.NetworkInterfaceArgs =
        com.pulumi.aws.ec2.NetworkInterfaceArgs.builder()
            .attachments(
                attachments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .interfaceType(interfaceType?.applyValue({ args0 -> args0 }))
            .ipv4PrefixCount(ipv4PrefixCount?.applyValue({ args0 -> args0 }))
            .ipv4Prefixes(ipv4Prefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6AddressCount(ipv6AddressCount?.applyValue({ args0 -> args0 }))
            .ipv6AddressListEnabled(ipv6AddressListEnabled?.applyValue({ args0 -> args0 }))
            .ipv6AddressLists(ipv6AddressLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6Addresses(ipv6Addresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6PrefixCount(ipv6PrefixCount?.applyValue({ args0 -> args0 }))
            .ipv6Prefixes(ipv6Prefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateIp(privateIp?.applyValue({ args0 -> args0 }))
            .privateIpListEnabled(privateIpListEnabled?.applyValue({ args0 -> args0 }))
            .privateIpLists(privateIpLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateIps(privateIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateIpsCount(privateIpsCount?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceDestCheck(sourceDestCheck?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkInterfaceArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceArgsBuilder internal constructor() {
    private var attachments: Output<List<NetworkInterfaceAttachmentArgs>>? = null

    private var description: Output<String>? = null

    private var interfaceType: Output<String>? = null

    private var ipv4PrefixCount: Output<Int>? = null

    private var ipv4Prefixes: Output<List<String>>? = null

    private var ipv6AddressCount: Output<Int>? = null

    private var ipv6AddressListEnabled: Output<Boolean>? = null

    private var ipv6AddressLists: Output<List<String>>? = null

    private var ipv6Addresses: Output<List<String>>? = null

    private var ipv6PrefixCount: Output<Int>? = null

    private var ipv6Prefixes: Output<List<String>>? = null

    private var privateIp: Output<String>? = null

    private var privateIpListEnabled: Output<Boolean>? = null

    private var privateIpLists: Output<List<String>>? = null

    private var privateIps: Output<List<String>>? = null

    private var privateIpsCount: Output<Int>? = null

    private var securityGroups: Output<List<String>>? = null

    private var sourceDestCheck: Output<Boolean>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block to define the attachment of the ENI. See Attachment below for more details!
     */
    @JvmName("jaspigandveogjdf")
    public suspend fun attachments(`value`: Output<List<NetworkInterfaceAttachmentArgs>>) {
        this.attachments = value
    }

    @JvmName("mbfoscltjfuvaasu")
    public suspend fun attachments(vararg values: Output<NetworkInterfaceAttachmentArgs>) {
        this.attachments = Output.all(values.asList())
    }

    /**
     * @param values Configuration block to define the attachment of the ENI. See Attachment below for more details!
     */
    @JvmName("dtgaaeaewegwsmiv")
    public suspend fun attachments(values: List<Output<NetworkInterfaceAttachmentArgs>>) {
        this.attachments = Output.all(values)
    }

    /**
     * @param value Description for the network interface.
     */
    @JvmName("ewwkaokewfqgecia")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Type of network interface to create. Set to `efa` for Elastic Fabric Adapter. Changing `interface_type` will cause the resource to be destroyed and re-created.
     */
    @JvmName("aqesxtbocgwjqkpe")
    public suspend fun interfaceType(`value`: Output<String>) {
        this.interfaceType = value
    }

    /**
     * @param value Number of IPv4 prefixes that AWS automatically assigns to the network interface.
     */
    @JvmName("gntxlbvhbtxhptxw")
    public suspend fun ipv4PrefixCount(`value`: Output<Int>) {
        this.ipv4PrefixCount = value
    }

    /**
     * @param value One or more IPv4 prefixes assigned to the network interface.
     */
    @JvmName("dutiagktpukaxlmm")
    public suspend fun ipv4Prefixes(`value`: Output<List<String>>) {
        this.ipv4Prefixes = value
    }

    @JvmName("pithqowhywqfylpj")
    public suspend fun ipv4Prefixes(vararg values: Output<String>) {
        this.ipv4Prefixes = Output.all(values.asList())
    }

    /**
     * @param values One or more IPv4 prefixes assigned to the network interface.
     */
    @JvmName("rbbvgwqngrennqex")
    public suspend fun ipv4Prefixes(values: List<Output<String>>) {
        this.ipv4Prefixes = Output.all(values)
    }

    /**
     * @param value Number of IPv6 addresses to assign to a network interface. You can't use this option if specifying specific `ipv6_addresses`. If your subnet has the AssignIpv6AddressOnCreation attribute set to `true`, you can specify `0` to override this setting.
     */
    @JvmName("riixhdqvvowejsvv")
    public suspend fun ipv6AddressCount(`value`: Output<Int>) {
        this.ipv6AddressCount = value
    }

    /**
     * @param value Whether `ipv6_address_list` is allowed and controls the IPs to assign to the ENI and `ipv6_addresses` and `ipv6_address_count` become read-only. Default false.
     */
    @JvmName("ipnikdxrykqafspi")
    public suspend fun ipv6AddressListEnabled(`value`: Output<Boolean>) {
        this.ipv6AddressListEnabled = value
    }

    /**
     * @param value List of private IPs to assign to the ENI in sequential order.
     */
    @JvmName("wtprovrilqaptelj")
    public suspend fun ipv6AddressLists(`value`: Output<List<String>>) {
        this.ipv6AddressLists = value
    }

    @JvmName("tgjfxoaognrhmexq")
    public suspend fun ipv6AddressLists(vararg values: Output<String>) {
        this.ipv6AddressLists = Output.all(values.asList())
    }

    /**
     * @param values List of private IPs to assign to the ENI in sequential order.
     */
    @JvmName("lqknqsiesjucsjiw")
    public suspend fun ipv6AddressLists(values: List<Output<String>>) {
        this.ipv6AddressLists = Output.all(values)
    }

    /**
     * @param value One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Addresses are assigned without regard to order. You can't use this option if you're specifying `ipv6_address_count`.
     */
    @JvmName("khpljjiwatkvbyho")
    public suspend fun ipv6Addresses(`value`: Output<List<String>>) {
        this.ipv6Addresses = value
    }

    @JvmName("sqfbrquebrolgnjt")
    public suspend fun ipv6Addresses(vararg values: Output<String>) {
        this.ipv6Addresses = Output.all(values.asList())
    }

    /**
     * @param values One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Addresses are assigned without regard to order. You can't use this option if you're specifying `ipv6_address_count`.
     */
    @JvmName("nfcyfwuglcdpafkd")
    public suspend fun ipv6Addresses(values: List<Output<String>>) {
        this.ipv6Addresses = Output.all(values)
    }

    /**
     * @param value Number of IPv6 prefixes that AWS automatically assigns to the network interface.
     */
    @JvmName("bwmogbwmkabcjucu")
    public suspend fun ipv6PrefixCount(`value`: Output<Int>) {
        this.ipv6PrefixCount = value
    }

    /**
     * @param value One or more IPv6 prefixes assigned to the network interface.
     */
    @JvmName("tigcfjkxppyqxtab")
    public suspend fun ipv6Prefixes(`value`: Output<List<String>>) {
        this.ipv6Prefixes = value
    }

    @JvmName("qspsesgdyshhnsxj")
    public suspend fun ipv6Prefixes(vararg values: Output<String>) {
        this.ipv6Prefixes = Output.all(values.asList())
    }

    /**
     * @param values One or more IPv6 prefixes assigned to the network interface.
     */
    @JvmName("iqqtpqyyduqxbpkk")
    public suspend fun ipv6Prefixes(values: List<Output<String>>) {
        this.ipv6Prefixes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("cheiaslttsmkrjjl")
    public suspend fun privateIp(`value`: Output<String>) {
        this.privateIp = value
    }

    /**
     * @param value Whether `private_ip_list` is allowed and controls the IPs to assign to the ENI and `private_ips` and `private_ips_count` become read-only. Default false.
     */
    @JvmName("rgfpxyopigsdsewl")
    public suspend fun privateIpListEnabled(`value`: Output<Boolean>) {
        this.privateIpListEnabled = value
    }

    /**
     * @param value List of private IPs to assign to the ENI in sequential order. Requires setting `private_ip_list_enabled` to `true`.
     */
    @JvmName("lsooyqdelhxsqqhe")
    public suspend fun privateIpLists(`value`: Output<List<String>>) {
        this.privateIpLists = value
    }

    @JvmName("rlahluaustpbucnp")
    public suspend fun privateIpLists(vararg values: Output<String>) {
        this.privateIpLists = Output.all(values.asList())
    }

    /**
     * @param values List of private IPs to assign to the ENI in sequential order. Requires setting `private_ip_list_enabled` to `true`.
     */
    @JvmName("qdcwlssoxdmhilot")
    public suspend fun privateIpLists(values: List<Output<String>>) {
        this.privateIpLists = Output.all(values)
    }

    /**
     * @param value List of private IPs to assign to the ENI without regard to order.
     */
    @JvmName("ymkswoldhyejtrpe")
    public suspend fun privateIps(`value`: Output<List<String>>) {
        this.privateIps = value
    }

    @JvmName("hjudvfjkdsymwopt")
    public suspend fun privateIps(vararg values: Output<String>) {
        this.privateIps = Output.all(values.asList())
    }

    /**
     * @param values List of private IPs to assign to the ENI without regard to order.
     */
    @JvmName("honvxtyvhuiubxls")
    public suspend fun privateIps(values: List<Output<String>>) {
        this.privateIps = Output.all(values)
    }

    /**
     * @param value Number of secondary private IPs to assign to the ENI. The total number of private IPs will be 1 + `private_ips_count`, as a primary private IP will be assiged to an ENI by default.
     */
    @JvmName("rqonwsdqcimgafbm")
    public suspend fun privateIpsCount(`value`: Output<Int>) {
        this.privateIpsCount = value
    }

    /**
     * @param value List of security group IDs to assign to the ENI.
     */
    @JvmName("kaitiiorlvfojyjd")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("nllgwxwptogibdup")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values List of security group IDs to assign to the ENI.
     */
    @JvmName("pobklwniajjdmibe")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value Whether to enable source destination checking for the ENI. Default true.
     */
    @JvmName("nbnhejclkuhnowhy")
    public suspend fun sourceDestCheck(`value`: Output<Boolean>) {
        this.sourceDestCheck = value
    }

    /**
     * @param value Subnet ID to create the ENI in.
     * The following arguments are optional:
     */
    @JvmName("xqdtecihrxwjmgyr")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mtfutfgexfprjngk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block to define the attachment of the ENI. See Attachment below for more details!
     */
    @JvmName("qxeluwvqjggdsggc")
    public suspend fun attachments(`value`: List<NetworkInterfaceAttachmentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachments = mapped
    }

    /**
     * @param argument Configuration block to define the attachment of the ENI. See Attachment below for more details!
     */
    @JvmName("lqfcihgimxxuposm")
    public suspend
    fun attachments(argument: List<suspend NetworkInterfaceAttachmentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceAttachmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.attachments = mapped
    }

    /**
     * @param argument Configuration block to define the attachment of the ENI. See Attachment below for more details!
     */
    @JvmName("udjfrlvfiqsudoet")
    public suspend fun attachments(
        vararg
        argument: suspend NetworkInterfaceAttachmentArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceAttachmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.attachments = mapped
    }

    /**
     * @param argument Configuration block to define the attachment of the ENI. See Attachment below for more details!
     */
    @JvmName("mjtuwkvbaqxamalr")
    public suspend
    fun attachments(argument: suspend NetworkInterfaceAttachmentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkInterfaceAttachmentArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.attachments = mapped
    }

    /**
     * @param values Configuration block to define the attachment of the ENI. See Attachment below for more details!
     */
    @JvmName("xeqibtperehpuwrj")
    public suspend fun attachments(vararg values: NetworkInterfaceAttachmentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attachments = mapped
    }

    /**
     * @param value Description for the network interface.
     */
    @JvmName("jnlwvgjxldqovbuv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Type of network interface to create. Set to `efa` for Elastic Fabric Adapter. Changing `interface_type` will cause the resource to be destroyed and re-created.
     */
    @JvmName("sqwivrawxndmocqu")
    public suspend fun interfaceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interfaceType = mapped
    }

    /**
     * @param value Number of IPv4 prefixes that AWS automatically assigns to the network interface.
     */
    @JvmName("nelwlbobrjrkmfml")
    public suspend fun ipv4PrefixCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4PrefixCount = mapped
    }

    /**
     * @param value One or more IPv4 prefixes assigned to the network interface.
     */
    @JvmName("wkvsxsvadjbvfxic")
    public suspend fun ipv4Prefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Prefixes = mapped
    }

    /**
     * @param values One or more IPv4 prefixes assigned to the network interface.
     */
    @JvmName("wipdlkohbtlqvubd")
    public suspend fun ipv4Prefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv4Prefixes = mapped
    }

    /**
     * @param value Number of IPv6 addresses to assign to a network interface. You can't use this option if specifying specific `ipv6_addresses`. If your subnet has the AssignIpv6AddressOnCreation attribute set to `true`, you can specify `0` to override this setting.
     */
    @JvmName("ektngwnnjialbmpa")
    public suspend fun ipv6AddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressCount = mapped
    }

    /**
     * @param value Whether `ipv6_address_list` is allowed and controls the IPs to assign to the ENI and `ipv6_addresses` and `ipv6_address_count` become read-only. Default false.
     */
    @JvmName("rewubolvfyjprxkc")
    public suspend fun ipv6AddressListEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressListEnabled = mapped
    }

    /**
     * @param value List of private IPs to assign to the ENI in sequential order.
     */
    @JvmName("eqkqowemhatktkat")
    public suspend fun ipv6AddressLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressLists = mapped
    }

    /**
     * @param values List of private IPs to assign to the ENI in sequential order.
     */
    @JvmName("ypbwbaresafobtqb")
    public suspend fun ipv6AddressLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6AddressLists = mapped
    }

    /**
     * @param value One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Addresses are assigned without regard to order. You can't use this option if you're specifying `ipv6_address_count`.
     */
    @JvmName("kwpyvlvdihuwwwmd")
    public suspend fun ipv6Addresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param values One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Addresses are assigned without regard to order. You can't use this option if you're specifying `ipv6_address_count`.
     */
    @JvmName("nmwaddpwoibmpnyc")
    public suspend fun ipv6Addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param value Number of IPv6 prefixes that AWS automatically assigns to the network interface.
     */
    @JvmName("kuekanvclhdhjego")
    public suspend fun ipv6PrefixCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6PrefixCount = mapped
    }

    /**
     * @param value One or more IPv6 prefixes assigned to the network interface.
     */
    @JvmName("earrtrkadaimtnjx")
    public suspend fun ipv6Prefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Prefixes = mapped
    }

    /**
     * @param values One or more IPv6 prefixes assigned to the network interface.
     */
    @JvmName("axenairyyeglqeqh")
    public suspend fun ipv6Prefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6Prefixes = mapped
    }

    /**
     * @param value
     */
    @JvmName("wbeioyvyenctvsjt")
    public suspend fun privateIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIp = mapped
    }

    /**
     * @param value Whether `private_ip_list` is allowed and controls the IPs to assign to the ENI and `private_ips` and `private_ips_count` become read-only. Default false.
     */
    @JvmName("ivoivneqihrktqwv")
    public suspend fun privateIpListEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpListEnabled = mapped
    }

    /**
     * @param value List of private IPs to assign to the ENI in sequential order. Requires setting `private_ip_list_enabled` to `true`.
     */
    @JvmName("fvvkfoiwkailhert")
    public suspend fun privateIpLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpLists = mapped
    }

    /**
     * @param values List of private IPs to assign to the ENI in sequential order. Requires setting `private_ip_list_enabled` to `true`.
     */
    @JvmName("bmwnmioredadqtfa")
    public suspend fun privateIpLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIpLists = mapped
    }

    /**
     * @param value List of private IPs to assign to the ENI without regard to order.
     */
    @JvmName("ttamgbhokrcoobxv")
    public suspend fun privateIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIps = mapped
    }

    /**
     * @param values List of private IPs to assign to the ENI without regard to order.
     */
    @JvmName("wljyiilslenaqnfp")
    public suspend fun privateIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIps = mapped
    }

    /**
     * @param value Number of secondary private IPs to assign to the ENI. The total number of private IPs will be 1 + `private_ips_count`, as a primary private IP will be assiged to an ENI by default.
     */
    @JvmName("clmnspacqpnmrady")
    public suspend fun privateIpsCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpsCount = mapped
    }

    /**
     * @param value List of security group IDs to assign to the ENI.
     */
    @JvmName("raewirqdijjwmiph")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values List of security group IDs to assign to the ENI.
     */
    @JvmName("icnsrwrjtyyoosgd")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value Whether to enable source destination checking for the ENI. Default true.
     */
    @JvmName("wosenjqcluyeqmup")
    public suspend fun sourceDestCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDestCheck = mapped
    }

    /**
     * @param value Subnet ID to create the ENI in.
     * The following arguments are optional:
     */
    @JvmName("hkmldpmubrankpef")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vfhsranskpkugokh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ekurjaflisstkcwk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkInterfaceArgs = NetworkInterfaceArgs(
        attachments = attachments,
        description = description,
        interfaceType = interfaceType,
        ipv4PrefixCount = ipv4PrefixCount,
        ipv4Prefixes = ipv4Prefixes,
        ipv6AddressCount = ipv6AddressCount,
        ipv6AddressListEnabled = ipv6AddressListEnabled,
        ipv6AddressLists = ipv6AddressLists,
        ipv6Addresses = ipv6Addresses,
        ipv6PrefixCount = ipv6PrefixCount,
        ipv6Prefixes = ipv6Prefixes,
        privateIp = privateIp,
        privateIpListEnabled = privateIpListEnabled,
        privateIpLists = privateIpLists,
        privateIps = privateIps,
        privateIpsCount = privateIpsCount,
        securityGroups = securityGroups,
        sourceDestCheck = sourceDestCheck,
        subnetId = subnetId,
        tags = tags,
    )
}
