@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NetworkInterfaceAttachment].
 */
@PulumiTagMarker
public class NetworkInterfaceAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkInterfaceAttachmentArgs = NetworkInterfaceAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkInterfaceAttachmentArgsBuilder.() -> Unit) {
        val builder = NetworkInterfaceAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkInterfaceAttachment {
        val builtJavaResource = com.pulumi.aws.ec2.NetworkInterfaceAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkInterfaceAttachment(builtJavaResource)
    }
}

/**
 * Attach an Elastic network interface (ENI) resource with EC2 instance.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkInterfaceAttachment;
 * import com.pulumi.aws.ec2.NetworkInterfaceAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new NetworkInterfaceAttachment("test", NetworkInterfaceAttachmentArgs.builder()
 *             .instanceId(aws_instance.test().id())
 *             .networkInterfaceId(aws_network_interface.test().id())
 *             .deviceIndex(0)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Elastic network interface (ENI) Attachments using its Attachment ID. For example:
 * ```sh
 *  $ pulumi import aws:ec2/networkInterfaceAttachment:NetworkInterfaceAttachment secondary_nic eni-attach-0a33842b4ec347c4c
 * ```
 *
 */
public class NetworkInterfaceAttachment internal constructor(
    override val javaResource: com.pulumi.aws.ec2.NetworkInterfaceAttachment,
) : KotlinCustomResource(javaResource, NetworkInterfaceAttachmentMapper) {
    /**
     * The ENI Attachment ID.
     */
    public val attachmentId: Output<String>
        get() = javaResource.attachmentId().applyValue({ args0 -> args0 })

    /**
     * Network interface index (int).
     */
    public val deviceIndex: Output<Int>
        get() = javaResource.deviceIndex().applyValue({ args0 -> args0 })

    /**
     * Instance ID to attach.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * ENI ID to attach.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The status of the Network Interface Attachment.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object NetworkInterfaceAttachmentMapper : ResourceMapper<NetworkInterfaceAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.NetworkInterfaceAttachment::class == javaResource::class

    override fun map(javaResource: Resource): NetworkInterfaceAttachment =
        NetworkInterfaceAttachment(javaResource as com.pulumi.aws.ec2.NetworkInterfaceAttachment)
}

/**
 * @see [NetworkInterfaceAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkInterfaceAttachment].
 */
public suspend fun networkInterfaceAttachment(
    name: String,
    block: suspend NetworkInterfaceAttachmentResourceBuilder.() -> Unit,
):
    NetworkInterfaceAttachment {
    val builder = NetworkInterfaceAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkInterfaceAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkInterfaceAttachment(name: String): NetworkInterfaceAttachment {
    val builder = NetworkInterfaceAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
