@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.NetworkInterfaceSecurityGroupAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This resource attaches a security group to an Elastic Network Interface (ENI).
 * It can be used to attach a security group to any existing ENI, be it a
 * secondary ENI or one attached as the primary interface on an instance.
 * > **NOTE on instances, interfaces, and security groups:** This provider currently
 * provides the capability to assign security groups via the [`aws&#46;ec2&#46;Instance`][1]
 * and the [`aws&#46;ec2&#46;NetworkInterface`][2] resources. Using this resource in
 * conjunction with security groups provided in-line in those resources will cause
 * conflicts, and will lead to spurious diffs and undefined behavior - please use
 * one or the other.
 * ## Example Usage
 * The following provides a very basic example of setting up an instance (provided
 * by `instance`) in the default security group, creating a security group
 * (provided by `sg`) and then attaching the security group to the instance's
 * primary network interface via the `aws.ec2.NetworkInterfaceSecurityGroupAttachment` resource,
 * named `sg_attachment`:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.ec2.NetworkInterfaceSecurityGroupAttachment;
 * import com.pulumi.aws.ec2.NetworkInterfaceSecurityGroupAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var ami = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .filters(GetAmiFilterArgs.builder()
 *                 .name("name")
 *                 .values("amzn-ami-hvm-*")
 *                 .build())
 *             .owners("amazon")
 *             .build());
 *         var instance = new Instance("instance", InstanceArgs.builder()
 *             .instanceType("t2.micro")
 *             .ami(ami.applyValue(getAmiResult -> getAmiResult.id()))
 *             .tags(Map.of("type", "test-instance"))
 *             .build());
 *         var sg = new SecurityGroup("sg", SecurityGroupArgs.builder()
 *             .tags(Map.of("type", "test-security-group"))
 *             .build());
 *         var sgAttachment = new NetworkInterfaceSecurityGroupAttachment("sgAttachment", NetworkInterfaceSecurityGroupAttachmentArgs.builder()
 *             .securityGroupId(sg.id())
 *             .networkInterfaceId(instance.primaryNetworkInterfaceId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Network Interface Security Group attachments using the associated network interface ID and security group ID, separated by an underscore (`_`). For example:
 * ```sh
 *  $ pulumi import aws:ec2/networkInterfaceSecurityGroupAttachment:NetworkInterfaceSecurityGroupAttachment sg_attachment eni-1234567890abcdef0_sg-1234567890abcdef0
 * ```
 * @property networkInterfaceId The ID of the network interface to attach to.
 * @property securityGroupId The ID of the security group.
 */
public data class NetworkInterfaceSecurityGroupAttachmentArgs(
    public val networkInterfaceId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.NetworkInterfaceSecurityGroupAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ec2.NetworkInterfaceSecurityGroupAttachmentArgs =
        com.pulumi.aws.ec2.NetworkInterfaceSecurityGroupAttachmentArgs.builder()
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfaceSecurityGroupAttachmentArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceSecurityGroupAttachmentArgsBuilder internal constructor() {
    private var networkInterfaceId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    /**
     * @param value The ID of the network interface to attach to.
     */
    @JvmName("uknccoorholctqdx")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("rvwksgnvlxxcvsfc")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The ID of the network interface to attach to.
     */
    @JvmName("jahavyvpqlcuecec")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("vkjumclbtflaffnl")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    internal fun build(): NetworkInterfaceSecurityGroupAttachmentArgs =
        NetworkInterfaceSecurityGroupAttachmentArgs(
            networkInterfaceId = networkInterfaceId,
            securityGroupId = securityGroupId,
        )
}
