@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.PeeringConnectionOptionsAccepter
import com.pulumi.aws.ec2.kotlin.outputs.PeeringConnectionOptionsRequester
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.ec2.kotlin.outputs.PeeringConnectionOptionsAccepter.Companion.toKotlin as peeringConnectionOptionsAccepterToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.PeeringConnectionOptionsRequester.Companion.toKotlin as peeringConnectionOptionsRequesterToKotlin

/**
 * Builder for [PeeringConnectionOptions].
 */
@PulumiTagMarker
public class PeeringConnectionOptionsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PeeringConnectionOptionsArgs = PeeringConnectionOptionsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PeeringConnectionOptionsArgsBuilder.() -> Unit) {
        val builder = PeeringConnectionOptionsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PeeringConnectionOptions {
        val builtJavaResource = com.pulumi.aws.ec2.PeeringConnectionOptions(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PeeringConnectionOptions(builtJavaResource)
    }
}

/**
 * Provides a resource to manage VPC peering connection options.
 * > **NOTE on VPC Peering Connections and VPC Peering Connection Options:** This provider provides
 * both a standalone VPC Peering Connection Options and a VPC Peering Connection
 * resource with `accepter` and `requester` attributes. Do not manage options for the same VPC peering
 * connection in both a VPC Peering Connection resource and a VPC Peering Connection Options resource.
 * Doing so will cause a conflict of options and will overwrite the options.
 * Using a VPC Peering Connection Options resource decouples management of the connection options from
 * management of the VPC Peering Connection and allows options to be set correctly in cross-region and
 * cross-account scenarios.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpcPeeringConnection;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionArgs;
 * import com.pulumi.aws.ec2.PeeringConnectionOptions;
 * import com.pulumi.aws.ec2.PeeringConnectionOptionsArgs;
 * import com.pulumi.aws.ec2.inputs.PeeringConnectionOptionsAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooVpc = new Vpc("fooVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var bar = new Vpc("bar", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var fooVpcPeeringConnection = new VpcPeeringConnection("fooVpcPeeringConnection", VpcPeeringConnectionArgs.builder()
 *             .vpcId(fooVpc.id())
 *             .peerVpcId(bar.id())
 *             .autoAccept(true)
 *             .build());
 *         var fooPeeringConnectionOptions = new PeeringConnectionOptions("fooPeeringConnectionOptions", PeeringConnectionOptionsArgs.builder()
 *             .vpcPeeringConnectionId(fooVpcPeeringConnection.id())
 *             .accepter(PeeringConnectionOptionsAccepterArgs.builder()
 *                 .allowRemoteVpcDnsResolution(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Cross-Account Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.VpcPeeringConnection;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionArgs;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionAccepter;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionAccepterArgs;
 * import com.pulumi.aws.ec2.PeeringConnectionOptions;
 * import com.pulumi.aws.ec2.PeeringConnectionOptionsArgs;
 * import com.pulumi.aws.ec2.inputs.PeeringConnectionOptionsRequesterArgs;
 * import com.pulumi.aws.ec2.inputs.PeeringConnectionOptionsAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var requester = new Provider("requester");
 *         var accepter = new Provider("accepter");
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.requester())
 *                 .build());
 *         var peerVpc = new Vpc("peerVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.accepter())
 *                 .build());
 *         final var peerCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var peerVpcPeeringConnection = new VpcPeeringConnection("peerVpcPeeringConnection", VpcPeeringConnectionArgs.builder()
 *             .vpcId(main.id())
 *             .peerVpcId(peerVpc.id())
 *             .peerOwnerId(peerCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .autoAccept(false)
 *             .tags(Map.of("Side", "Requester"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.requester())
 *                 .build());
 *         var peerVpcPeeringConnectionAccepter = new VpcPeeringConnectionAccepter("peerVpcPeeringConnectionAccepter", VpcPeeringConnectionAccepterArgs.builder()
 *             .vpcPeeringConnectionId(peerVpcPeeringConnection.id())
 *             .autoAccept(true)
 *             .tags(Map.of("Side", "Accepter"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.accepter())
 *                 .build());
 *         var requesterPeeringConnectionOptions = new PeeringConnectionOptions("requesterPeeringConnectionOptions", PeeringConnectionOptionsArgs.builder()
 *             .vpcPeeringConnectionId(peerVpcPeeringConnectionAccepter.id())
 *             .requester(PeeringConnectionOptionsRequesterArgs.builder()
 *                 .allowRemoteVpcDnsResolution(true)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.requester())
 *                 .build());
 *         var accepterPeeringConnectionOptions = new PeeringConnectionOptions("accepterPeeringConnectionOptions", PeeringConnectionOptionsArgs.builder()
 *             .vpcPeeringConnectionId(peerVpcPeeringConnectionAccepter.id())
 *             .accepter(PeeringConnectionOptionsAccepterArgs.builder()
 *                 .allowRemoteVpcDnsResolution(true)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.accepter())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Peering Connection Options using the VPC peering `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/peeringConnectionOptions:PeeringConnectionOptions foo pcx-111aaa111
 * ```
 *
 */
public class PeeringConnectionOptions internal constructor(
    override val javaResource: com.pulumi.aws.ec2.PeeringConnectionOptions,
) : KotlinCustomResource(javaResource, PeeringConnectionOptionsMapper) {
    /**
     * An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that acceptsthe peering connection (a maximum of one).
     */
    public val accepter: Output<PeeringConnectionOptionsAccepter>
        get() = javaResource.accepter().applyValue({ args0 ->
            args0.let({ args0 ->
                peeringConnectionOptionsAccepterToKotlin(args0)
            })
        })

    /**
     * A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requeststhe peering connection (a maximum of one).
     */
    public val requester: Output<PeeringConnectionOptionsRequester>
        get() = javaResource.requester().applyValue({ args0 ->
            args0.let({ args0 ->
                peeringConnectionOptionsRequesterToKotlin(args0)
            })
        })

    /**
     * The ID of the requester VPC peering connection.
     */
    public val vpcPeeringConnectionId: Output<String>
        get() = javaResource.vpcPeeringConnectionId().applyValue({ args0 -> args0 })
}

public object PeeringConnectionOptionsMapper : ResourceMapper<PeeringConnectionOptions> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.PeeringConnectionOptions::class == javaResource::class

    override fun map(javaResource: Resource): PeeringConnectionOptions =
        PeeringConnectionOptions(javaResource as com.pulumi.aws.ec2.PeeringConnectionOptions)
}

/**
 * @see [PeeringConnectionOptions].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PeeringConnectionOptions].
 */
public suspend fun peeringConnectionOptions(
    name: String,
    block: suspend PeeringConnectionOptionsResourceBuilder.() -> Unit,
): PeeringConnectionOptions {
    val builder = PeeringConnectionOptionsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PeeringConnectionOptions].
 * @param name The _unique_ name of the resulting resource.
 */
public fun peeringConnectionOptions(name: String): PeeringConnectionOptions {
    val builder = PeeringConnectionOptionsResourceBuilder()
    builder.name(name)
    return builder.build()
}
