@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.PeeringConnectionOptionsArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.PeeringConnectionOptionsAccepterArgs
import com.pulumi.aws.ec2.kotlin.inputs.PeeringConnectionOptionsAccepterArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.PeeringConnectionOptionsRequesterArgs
import com.pulumi.aws.ec2.kotlin.inputs.PeeringConnectionOptionsRequesterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage VPC peering connection options.
 * > **NOTE on VPC Peering Connections and VPC Peering Connection Options:** This provider provides
 * both a standalone VPC Peering Connection Options and a VPC Peering Connection
 * resource with `accepter` and `requester` attributes. Do not manage options for the same VPC peering
 * connection in both a VPC Peering Connection resource and a VPC Peering Connection Options resource.
 * Doing so will cause a conflict of options and will overwrite the options.
 * Using a VPC Peering Connection Options resource decouples management of the connection options from
 * management of the VPC Peering Connection and allows options to be set correctly in cross-region and
 * cross-account scenarios.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpcPeeringConnection;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionArgs;
 * import com.pulumi.aws.ec2.PeeringConnectionOptions;
 * import com.pulumi.aws.ec2.PeeringConnectionOptionsArgs;
 * import com.pulumi.aws.ec2.inputs.PeeringConnectionOptionsAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooVpc = new Vpc("fooVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var bar = new Vpc("bar", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var fooVpcPeeringConnection = new VpcPeeringConnection("fooVpcPeeringConnection", VpcPeeringConnectionArgs.builder()
 *             .vpcId(fooVpc.id())
 *             .peerVpcId(bar.id())
 *             .autoAccept(true)
 *             .build());
 *         var fooPeeringConnectionOptions = new PeeringConnectionOptions("fooPeeringConnectionOptions", PeeringConnectionOptionsArgs.builder()
 *             .vpcPeeringConnectionId(fooVpcPeeringConnection.id())
 *             .accepter(PeeringConnectionOptionsAccepterArgs.builder()
 *                 .allowRemoteVpcDnsResolution(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Cross-Account Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.VpcPeeringConnection;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionArgs;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionAccepter;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionAccepterArgs;
 * import com.pulumi.aws.ec2.PeeringConnectionOptions;
 * import com.pulumi.aws.ec2.PeeringConnectionOptionsArgs;
 * import com.pulumi.aws.ec2.inputs.PeeringConnectionOptionsRequesterArgs;
 * import com.pulumi.aws.ec2.inputs.PeeringConnectionOptionsAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var requester = new Provider("requester");
 *         var accepter = new Provider("accepter");
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.requester())
 *                 .build());
 *         var peerVpc = new Vpc("peerVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.accepter())
 *                 .build());
 *         final var peerCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var peerVpcPeeringConnection = new VpcPeeringConnection("peerVpcPeeringConnection", VpcPeeringConnectionArgs.builder()
 *             .vpcId(main.id())
 *             .peerVpcId(peerVpc.id())
 *             .peerOwnerId(peerCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .autoAccept(false)
 *             .tags(Map.of("Side", "Requester"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.requester())
 *                 .build());
 *         var peerVpcPeeringConnectionAccepter = new VpcPeeringConnectionAccepter("peerVpcPeeringConnectionAccepter", VpcPeeringConnectionAccepterArgs.builder()
 *             .vpcPeeringConnectionId(peerVpcPeeringConnection.id())
 *             .autoAccept(true)
 *             .tags(Map.of("Side", "Accepter"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.accepter())
 *                 .build());
 *         var requesterPeeringConnectionOptions = new PeeringConnectionOptions("requesterPeeringConnectionOptions", PeeringConnectionOptionsArgs.builder()
 *             .vpcPeeringConnectionId(peerVpcPeeringConnectionAccepter.id())
 *             .requester(PeeringConnectionOptionsRequesterArgs.builder()
 *                 .allowRemoteVpcDnsResolution(true)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.requester())
 *                 .build());
 *         var accepterPeeringConnectionOptions = new PeeringConnectionOptions("accepterPeeringConnectionOptions", PeeringConnectionOptionsArgs.builder()
 *             .vpcPeeringConnectionId(peerVpcPeeringConnectionAccepter.id())
 *             .accepter(PeeringConnectionOptionsAccepterArgs.builder()
 *                 .allowRemoteVpcDnsResolution(true)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.accepter())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Peering Connection Options using the VPC peering `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/peeringConnectionOptions:PeeringConnectionOptions foo pcx-111aaa111
 * ```
 * @property accepter An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that acceptsthe peering connection (a maximum of one).
 * @property requester A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requeststhe peering connection (a maximum of one).
 * @property vpcPeeringConnectionId The ID of the requester VPC peering connection.
 */
public data class PeeringConnectionOptionsArgs(
    public val accepter: Output<PeeringConnectionOptionsAccepterArgs>? = null,
    public val requester: Output<PeeringConnectionOptionsRequesterArgs>? = null,
    public val vpcPeeringConnectionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.PeeringConnectionOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.PeeringConnectionOptionsArgs =
        com.pulumi.aws.ec2.PeeringConnectionOptionsArgs.builder()
            .accepter(accepter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requester(requester?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpcPeeringConnectionId(vpcPeeringConnectionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeeringConnectionOptionsArgs].
 */
@PulumiTagMarker
public class PeeringConnectionOptionsArgsBuilder internal constructor() {
    private var accepter: Output<PeeringConnectionOptionsAccepterArgs>? = null

    private var requester: Output<PeeringConnectionOptionsRequesterArgs>? = null

    private var vpcPeeringConnectionId: Output<String>? = null

    /**
     * @param value An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that acceptsthe peering connection (a maximum of one).
     */
    @JvmName("pmbdgvhojwglspog")
    public suspend fun accepter(`value`: Output<PeeringConnectionOptionsAccepterArgs>) {
        this.accepter = value
    }

    /**
     * @param value A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requeststhe peering connection (a maximum of one).
     */
    @JvmName("qtdkjbveuvupqftf")
    public suspend fun requester(`value`: Output<PeeringConnectionOptionsRequesterArgs>) {
        this.requester = value
    }

    /**
     * @param value The ID of the requester VPC peering connection.
     */
    @JvmName("vrpufdrchcaclibx")
    public suspend fun vpcPeeringConnectionId(`value`: Output<String>) {
        this.vpcPeeringConnectionId = value
    }

    /**
     * @param value An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that acceptsthe peering connection (a maximum of one).
     */
    @JvmName("troupahjtepkovwy")
    public suspend fun accepter(`value`: PeeringConnectionOptionsAccepterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accepter = mapped
    }

    /**
     * @param argument An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that acceptsthe peering connection (a maximum of one).
     */
    @JvmName("wlmnpqmacxipltlp")
    public suspend
    fun accepter(argument: suspend PeeringConnectionOptionsAccepterArgsBuilder.() -> Unit) {
        val toBeMapped = PeeringConnectionOptionsAccepterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.accepter = mapped
    }

    /**
     * @param value A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requeststhe peering connection (a maximum of one).
     */
    @JvmName("damqttrkydytqnvs")
    public suspend fun requester(`value`: PeeringConnectionOptionsRequesterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requester = mapped
    }

    /**
     * @param argument A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requeststhe peering connection (a maximum of one).
     */
    @JvmName("bgrsarbkreewvpxp")
    public suspend
    fun requester(argument: suspend PeeringConnectionOptionsRequesterArgsBuilder.() -> Unit) {
        val toBeMapped = PeeringConnectionOptionsRequesterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.requester = mapped
    }

    /**
     * @param value The ID of the requester VPC peering connection.
     */
    @JvmName("hoyowenwkapdgpsu")
    public suspend fun vpcPeeringConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcPeeringConnectionId = mapped
    }

    internal fun build(): PeeringConnectionOptionsArgs = PeeringConnectionOptionsArgs(
        accepter = accepter,
        requester = requester,
        vpcPeeringConnectionId = vpcPeeringConnectionId,
    )
}
