@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ProxyProtocolPolicy].
 */
@PulumiTagMarker
public class ProxyProtocolPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProxyProtocolPolicyArgs = ProxyProtocolPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProxyProtocolPolicyArgsBuilder.() -> Unit) {
        val builder = ProxyProtocolPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProxyProtocolPolicy {
        val builtJavaResource = com.pulumi.aws.ec2.ProxyProtocolPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProxyProtocolPolicy(builtJavaResource)
    }
}

/**
 * Provides a proxy protocol policy, which allows an ELB to carry a client connection information to a backend.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.ec2.ProxyProtocolPolicy;
 * import com.pulumi.aws.ec2.ProxyProtocolPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lb = new LoadBalancer("lb", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .listeners(
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(25)
 *                     .instanceProtocol("tcp")
 *                     .lbPort(25)
 *                     .lbProtocol("tcp")
 *                     .build(),
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(587)
 *                     .instanceProtocol("tcp")
 *                     .lbPort(587)
 *                     .lbProtocol("tcp")
 *                     .build())
 *             .build());
 *         var smtp = new ProxyProtocolPolicy("smtp", ProxyProtocolPolicyArgs.builder()
 *             .loadBalancer(lb.name())
 *             .instancePorts(
 *                 "25",
 *                 "587")
 *             .build());
 *     }
 * }
 * ```
 */
public class ProxyProtocolPolicy internal constructor(
    override val javaResource: com.pulumi.aws.ec2.ProxyProtocolPolicy,
) : KotlinCustomResource(javaResource, ProxyProtocolPolicyMapper) {
    /**
     * List of instance ports to which the policy
     * should be applied. This can be specified if the protocol is SSL or TCP.
     */
    public val instancePorts: Output<List<String>>
        get() = javaResource.instancePorts().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The load balancer to which the policy
     * should be attached.
     */
    public val loadBalancer: Output<String>
        get() = javaResource.loadBalancer().applyValue({ args0 -> args0 })
}

public object ProxyProtocolPolicyMapper : ResourceMapper<ProxyProtocolPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.ProxyProtocolPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ProxyProtocolPolicy = ProxyProtocolPolicy(
        javaResource
            as com.pulumi.aws.ec2.ProxyProtocolPolicy,
    )
}

/**
 * @see [ProxyProtocolPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProxyProtocolPolicy].
 */
public suspend fun proxyProtocolPolicy(
    name: String,
    block: suspend ProxyProtocolPolicyResourceBuilder.() -> Unit,
): ProxyProtocolPolicy {
    val builder = ProxyProtocolPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProxyProtocolPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun proxyProtocolPolicy(name: String): ProxyProtocolPolicy {
    val builder = ProxyProtocolPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
