@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.ProxyProtocolPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a proxy protocol policy, which allows an ELB to carry a client connection information to a backend.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.ec2.ProxyProtocolPolicy;
 * import com.pulumi.aws.ec2.ProxyProtocolPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lb = new LoadBalancer("lb", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .listeners(
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(25)
 *                     .instanceProtocol("tcp")
 *                     .lbPort(25)
 *                     .lbProtocol("tcp")
 *                     .build(),
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(587)
 *                     .instanceProtocol("tcp")
 *                     .lbPort(587)
 *                     .lbProtocol("tcp")
 *                     .build())
 *             .build());
 *         var smtp = new ProxyProtocolPolicy("smtp", ProxyProtocolPolicyArgs.builder()
 *             .loadBalancer(lb.name())
 *             .instancePorts(
 *                 "25",
 *                 "587")
 *             .build());
 *     }
 * }
 * ```
 * @property instancePorts List of instance ports to which the policy
 * should be applied. This can be specified if the protocol is SSL or TCP.
 * @property loadBalancer The load balancer to which the policy
 * should be attached.
 */
public data class ProxyProtocolPolicyArgs(
    public val instancePorts: Output<List<String>>? = null,
    public val loadBalancer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.ProxyProtocolPolicyArgs> {
    override fun toJava(): com.pulumi.aws.ec2.ProxyProtocolPolicyArgs =
        com.pulumi.aws.ec2.ProxyProtocolPolicyArgs.builder()
            .instancePorts(instancePorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .loadBalancer(loadBalancer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProxyProtocolPolicyArgs].
 */
@PulumiTagMarker
public class ProxyProtocolPolicyArgsBuilder internal constructor() {
    private var instancePorts: Output<List<String>>? = null

    private var loadBalancer: Output<String>? = null

    /**
     * @param value List of instance ports to which the policy
     * should be applied. This can be specified if the protocol is SSL or TCP.
     */
    @JvmName("upodjqiemasaepfr")
    public suspend fun instancePorts(`value`: Output<List<String>>) {
        this.instancePorts = value
    }

    @JvmName("vjrqxkmtbimfmqbk")
    public suspend fun instancePorts(vararg values: Output<String>) {
        this.instancePorts = Output.all(values.asList())
    }

    /**
     * @param values List of instance ports to which the policy
     * should be applied. This can be specified if the protocol is SSL or TCP.
     */
    @JvmName("xrmdxnvamqpfrvis")
    public suspend fun instancePorts(values: List<Output<String>>) {
        this.instancePorts = Output.all(values)
    }

    /**
     * @param value The load balancer to which the policy
     * should be attached.
     */
    @JvmName("vsqtxcladmjpjjsb")
    public suspend fun loadBalancer(`value`: Output<String>) {
        this.loadBalancer = value
    }

    /**
     * @param value List of instance ports to which the policy
     * should be applied. This can be specified if the protocol is SSL or TCP.
     */
    @JvmName("yrkrhrtwqyiqakme")
    public suspend fun instancePorts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instancePorts = mapped
    }

    /**
     * @param values List of instance ports to which the policy
     * should be applied. This can be specified if the protocol is SSL or TCP.
     */
    @JvmName("gjrnihpjgejavyao")
    public suspend fun instancePorts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instancePorts = mapped
    }

    /**
     * @param value The load balancer to which the policy
     * should be attached.
     */
    @JvmName("egnlaxbrbawcvrey")
    public suspend fun loadBalancer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancer = mapped
    }

    internal fun build(): ProxyProtocolPolicyArgs = ProxyProtocolPolicyArgs(
        instancePorts = instancePorts,
        loadBalancer = loadBalancer,
    )
}
