@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Route].
 */
@PulumiTagMarker
public class RouteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteArgs = RouteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteArgsBuilder.() -> Unit) {
        val builder = RouteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Route {
        val builtJavaResource = com.pulumi.aws.ec2.Route(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Route(builtJavaResource)
    }
}

/**
 * Provides a resource to create a routing table entry (a route) in a VPC routing table.
 * > **NOTE on Route Tables and Routes:** This provider currently provides both a standalone Route resource and a Route Table resource with routes defined in-line. At this time you cannot use a Route Table with in-line routes in conjunction with any Route resources. Doing so will cause a conflict of rule settings and will overwrite rules.
 * > **NOTE on `gateway_id` attribute:** The AWS API is very forgiving with the resource ID passed in the `gateway_id` attribute. For example an `aws.ec2.Route` resource can be created with an `aws.ec2.NatGateway` or `aws.ec2.EgressOnlyInternetGateway` ID specified for the `gateway_id` attribute. Specifying anything other than an `aws.ec2.InternetGateway` or `aws.ec2.VpnGateway` ID will lead to this provider reporting a permanent diff between your configuration and recorded state, as the AWS API returns the more-specific attribute. If you are experiencing constant diffs with an `aws.ec2.Route` resource, the first thing to check is that the correct attribute is being specified.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Route;
 * import com.pulumi.aws.ec2.RouteArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var route = new Route("route", RouteArgs.builder()
 *             .routeTableId("rtb-4fbb3ac4")
 *             .destinationCidrBlock("10.0.1.0/22")
 *             .vpcPeeringConnectionId("pcx-45ff3dc1")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_route_table.testing())
 *                 .build());
 *     }
 * }
 * ```
 * ## Example IPv6 Usage
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const vpc = new aws.ec2.Vpc("vpc", {
 *     cidrBlock: "10.1.0.0/16",
 *     assignGeneratedIpv6CidrBlock: true,
 * });
 * const egress = new aws.ec2.EgressOnlyInternetGateway("egress", {vpcId: vpc.id});
 * const route = new aws.ec2.Route("route", {
 *     routeTableId: "rtb-4fbb3ac4",
 *     destinationIpv6CidrBlock: "::/0",
 *     egressOnlyGatewayId: egress.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * vpc = aws.ec2.Vpc("vpc",
 *     cidr_block="10.1.0.0/16",
 *     assign_generated_ipv6_cidr_block=True)
 * egress = aws.ec2.EgressOnlyInternetGateway("egress", vpc_id=vpc.id)
 * route = aws.ec2.Route("route",
 *     route_table_id="rtb-4fbb3ac4",
 *     destination_ipv6_cidr_block="::/0",
 *     egress_only_gateway_id=egress.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpc = new Aws.Ec2.Vpc("vpc", new()
 *     {
 *         CidrBlock = "10.1.0.0/16",
 *         AssignGeneratedIpv6CidrBlock = true,
 *     });
 *     var egress = new Aws.Ec2.EgressOnlyInternetGateway("egress", new()
 *     {
 *         VpcId = vpc.Id,
 *     });
 *     var route = new Aws.Ec2.Route("route", new()
 *     {
 *         RouteTableId = "rtb-4fbb3ac4",
 *         DestinationIpv6CidrBlock = "::/0",
 *         EgressOnlyGatewayId = egress.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		vpc, err := ec2.NewVpc(ctx, "vpc", &ec2.VpcArgs{
 * 			CidrBlock:                    pulumi.String("10.1.0.0/16"),
 * 			AssignGeneratedIpv6CidrBlock: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		egress, err := ec2.NewEgressOnlyInternetGateway(ctx, "egress", &ec2.EgressOnlyInternetGatewayArgs{
 * 			VpcId: vpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewRoute(ctx, "route", &ec2.RouteArgs{
 * 			RouteTableId:             pulumi.String("rtb-4fbb3ac4"),
 * 			DestinationIpv6CidrBlock: pulumi.String("::/0"),
 * 			EgressOnlyGatewayId:      egress.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.EgressOnlyInternetGateway;
 * import com.pulumi.aws.ec2.EgressOnlyInternetGatewayArgs;
 * import com.pulumi.aws.ec2.Route;
 * import com.pulumi.aws.ec2.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpc = new Vpc("vpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .assignGeneratedIpv6CidrBlock(true)
 *             .build());
 *         var egress = new EgressOnlyInternetGateway("egress", EgressOnlyInternetGatewayArgs.builder()
 *             .vpcId(vpc.id())
 *             .build());
 *         var route = new Route("route", RouteArgs.builder()
 *             .routeTableId("rtb-4fbb3ac4")
 *             .destinationIpv6CidrBlock("::/0")
 *             .egressOnlyGatewayId(egress.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   vpc:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.1.0.0/16
 *       assignGeneratedIpv6CidrBlock: true
 *   egress:
 *     type: aws:ec2:EgressOnlyInternetGateway
 *     properties:
 *       vpcId: ${vpc.id}
 *   route:
 *     type: aws:ec2:Route
 *     properties:
 *       routeTableId: rtb-4fbb3ac4
 *       destinationIpv6CidrBlock: ::/0
 *       egressOnlyGatewayId: ${egress.id}
 * ```
 * ## Import
 * Import a route in route table `rtb-656C65616E6F72` with an IPv6 destination CIDR of `2620:0:2d0:200::8/125`:
 * Import a route in route table `rtb-656C65616E6F72` with a managed prefix list destination of `pl-0570a1d2d725c16be`:
 * __Using `pulumi import` to import__ individual routes using `ROUTETABLEID_DESTINATION`. Import [local routes](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html#RouteTables) using the VPC's IPv4 or IPv6 CIDR blocks. For example:
 * Import a route in route table `rtb-656C65616E6F72` with an IPv4 destination CIDR of `10.42.0.0/16`:
 * ```sh
 *  $ pulumi import aws:ec2/route:Route my_route rtb-656C65616E6F72_10.42.0.0/16
 * ```
 *  Import a route in route table `rtb-656C65616E6F72` with an IPv6 destination CIDR of `2620:0:2d0:200::8/125`:
 * ```sh
 *  $ pulumi import aws:ec2/route:Route my_route rtb-656C65616E6F72_2620:0:2d0:200::8/125
 * ```
 *  Import a route in route table `rtb-656C65616E6F72` with a managed prefix list destination of `pl-0570a1d2d725c16be`:
 * ```sh
 *  $ pulumi import aws:ec2/route:Route my_route rtb-656C65616E6F72_pl-0570a1d2d725c16be
 * ```
 *
 */
public class Route internal constructor(
    override val javaResource: com.pulumi.aws.ec2.Route,
) : KotlinCustomResource(javaResource, RouteMapper) {
    /**
     * Identifier of a carrier gateway. This attribute can only be used when the VPC contains a subnet which is associated with a Wavelength Zone.
     */
    public val carrierGatewayId: Output<String>?
        get() = javaResource.carrierGatewayId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of a core network.
     */
    public val coreNetworkArn: Output<String>?
        get() = javaResource.coreNetworkArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The destination CIDR block.
     */
    public val destinationCidrBlock: Output<String>?
        get() = javaResource.destinationCidrBlock().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The destination IPv6 CIDR block.
     */
    public val destinationIpv6CidrBlock: Output<String>?
        get() = javaResource.destinationIpv6CidrBlock().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of a managed prefix list destination.
     * One of the following target arguments must be supplied:
     */
    public val destinationPrefixListId: Output<String>?
        get() = javaResource.destinationPrefixListId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of a VPC Egress Only Internet Gateway.
     */
    public val egressOnlyGatewayId: Output<String>?
        get() = javaResource.egressOnlyGatewayId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of a VPC internet gateway or a virtual private gateway. Specify `local` when updating a previously imported local route.
     */
    public val gatewayId: Output<String>?
        get() = javaResource.gatewayId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Identifier of an EC2 instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The AWS account ID of the owner of the EC2 instance.
     */
    public val instanceOwnerId: Output<String>
        get() = javaResource.instanceOwnerId().applyValue({ args0 -> args0 })

    /**
     * Identifier of a Outpost local gateway.
     */
    public val localGatewayId: Output<String>?
        get() = javaResource.localGatewayId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of a VPC NAT gateway.
     */
    public val natGatewayId: Output<String>?
        get() = javaResource.natGatewayId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of an EC2 network interface.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * How the route was created - `CreateRouteTable`, `CreateRoute` or `EnableVgwRoutePropagation`.
     */
    public val origin: Output<String>
        get() = javaResource.origin().applyValue({ args0 -> args0 })

    /**
     * The ID of the routing table.
     * One of the following destination arguments must be supplied:
     */
    public val routeTableId: Output<String>
        get() = javaResource.routeTableId().applyValue({ args0 -> args0 })

    /**
     * The state of the route - `active` or `blackhole`.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Identifier of an EC2 Transit Gateway.
     */
    public val transitGatewayId: Output<String>?
        get() = javaResource.transitGatewayId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of a VPC Endpoint.
     */
    public val vpcEndpointId: Output<String>?
        get() = javaResource.vpcEndpointId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of a VPC peering connection.
     * Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
     */
    public val vpcPeeringConnectionId: Output<String>?
        get() = javaResource.vpcPeeringConnectionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object RouteMapper : ResourceMapper<Route> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.Route::class == javaResource::class

    override fun map(javaResource: Resource): Route = Route(javaResource as com.pulumi.aws.ec2.Route)
}

/**
 * @see [Route].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Route].
 */
public suspend fun route(name: String, block: suspend RouteResourceBuilder.() -> Unit): Route {
    val builder = RouteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Route].
 * @param name The _unique_ name of the resulting resource.
 */
public fun route(name: String): Route {
    val builder = RouteResourceBuilder()
    builder.name(name)
    return builder.build()
}
