@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.RouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to create a routing table entry (a route) in a VPC routing table.
 * > **NOTE on Route Tables and Routes:** This provider currently provides both a standalone Route resource and a Route Table resource with routes defined in-line. At this time you cannot use a Route Table with in-line routes in conjunction with any Route resources. Doing so will cause a conflict of rule settings and will overwrite rules.
 * > **NOTE on `gateway_id` attribute:** The AWS API is very forgiving with the resource ID passed in the `gateway_id` attribute. For example an `aws.ec2.Route` resource can be created with an `aws.ec2.NatGateway` or `aws.ec2.EgressOnlyInternetGateway` ID specified for the `gateway_id` attribute. Specifying anything other than an `aws.ec2.InternetGateway` or `aws.ec2.VpnGateway` ID will lead to this provider reporting a permanent diff between your configuration and recorded state, as the AWS API returns the more-specific attribute. If you are experiencing constant diffs with an `aws.ec2.Route` resource, the first thing to check is that the correct attribute is being specified.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Route;
 * import com.pulumi.aws.ec2.RouteArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var route = new Route("route", RouteArgs.builder()
 *             .routeTableId("rtb-4fbb3ac4")
 *             .destinationCidrBlock("10.0.1.0/22")
 *             .vpcPeeringConnectionId("pcx-45ff3dc1")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_route_table.testing())
 *                 .build());
 *     }
 * }
 * ```
 * ## Example IPv6 Usage
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const vpc = new aws.ec2.Vpc("vpc", {
 *     cidrBlock: "10.1.0.0/16",
 *     assignGeneratedIpv6CidrBlock: true,
 * });
 * const egress = new aws.ec2.EgressOnlyInternetGateway("egress", {vpcId: vpc.id});
 * const route = new aws.ec2.Route("route", {
 *     routeTableId: "rtb-4fbb3ac4",
 *     destinationIpv6CidrBlock: "::/0",
 *     egressOnlyGatewayId: egress.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * vpc = aws.ec2.Vpc("vpc",
 *     cidr_block="10.1.0.0/16",
 *     assign_generated_ipv6_cidr_block=True)
 * egress = aws.ec2.EgressOnlyInternetGateway("egress", vpc_id=vpc.id)
 * route = aws.ec2.Route("route",
 *     route_table_id="rtb-4fbb3ac4",
 *     destination_ipv6_cidr_block="::/0",
 *     egress_only_gateway_id=egress.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpc = new Aws.Ec2.Vpc("vpc", new()
 *     {
 *         CidrBlock = "10.1.0.0/16",
 *         AssignGeneratedIpv6CidrBlock = true,
 *     });
 *     var egress = new Aws.Ec2.EgressOnlyInternetGateway("egress", new()
 *     {
 *         VpcId = vpc.Id,
 *     });
 *     var route = new Aws.Ec2.Route("route", new()
 *     {
 *         RouteTableId = "rtb-4fbb3ac4",
 *         DestinationIpv6CidrBlock = "::/0",
 *         EgressOnlyGatewayId = egress.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		vpc, err := ec2.NewVpc(ctx, "vpc", &ec2.VpcArgs{
 * 			CidrBlock:                    pulumi.String("10.1.0.0/16"),
 * 			AssignGeneratedIpv6CidrBlock: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		egress, err := ec2.NewEgressOnlyInternetGateway(ctx, "egress", &ec2.EgressOnlyInternetGatewayArgs{
 * 			VpcId: vpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewRoute(ctx, "route", &ec2.RouteArgs{
 * 			RouteTableId:             pulumi.String("rtb-4fbb3ac4"),
 * 			DestinationIpv6CidrBlock: pulumi.String("::/0"),
 * 			EgressOnlyGatewayId:      egress.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.EgressOnlyInternetGateway;
 * import com.pulumi.aws.ec2.EgressOnlyInternetGatewayArgs;
 * import com.pulumi.aws.ec2.Route;
 * import com.pulumi.aws.ec2.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpc = new Vpc("vpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .assignGeneratedIpv6CidrBlock(true)
 *             .build());
 *         var egress = new EgressOnlyInternetGateway("egress", EgressOnlyInternetGatewayArgs.builder()
 *             .vpcId(vpc.id())
 *             .build());
 *         var route = new Route("route", RouteArgs.builder()
 *             .routeTableId("rtb-4fbb3ac4")
 *             .destinationIpv6CidrBlock("::/0")
 *             .egressOnlyGatewayId(egress.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   vpc:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.1.0.0/16
 *       assignGeneratedIpv6CidrBlock: true
 *   egress:
 *     type: aws:ec2:EgressOnlyInternetGateway
 *     properties:
 *       vpcId: ${vpc.id}
 *   route:
 *     type: aws:ec2:Route
 *     properties:
 *       routeTableId: rtb-4fbb3ac4
 *       destinationIpv6CidrBlock: ::/0
 *       egressOnlyGatewayId: ${egress.id}
 * ```
 * ## Import
 * Import a route in route table `rtb-656C65616E6F72` with an IPv6 destination CIDR of `2620:0:2d0:200::8/125`:
 * Import a route in route table `rtb-656C65616E6F72` with a managed prefix list destination of `pl-0570a1d2d725c16be`:
 * __Using `pulumi import` to import__ individual routes using `ROUTETABLEID_DESTINATION`. Import [local routes](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html#RouteTables) using the VPC's IPv4 or IPv6 CIDR blocks. For example:
 * Import a route in route table `rtb-656C65616E6F72` with an IPv4 destination CIDR of `10.42.0.0/16`:
 * ```sh
 *  $ pulumi import aws:ec2/route:Route my_route rtb-656C65616E6F72_10.42.0.0/16
 * ```
 *  Import a route in route table `rtb-656C65616E6F72` with an IPv6 destination CIDR of `2620:0:2d0:200::8/125`:
 * ```sh
 *  $ pulumi import aws:ec2/route:Route my_route rtb-656C65616E6F72_2620:0:2d0:200::8/125
 * ```
 *  Import a route in route table `rtb-656C65616E6F72` with a managed prefix list destination of `pl-0570a1d2d725c16be`:
 * ```sh
 *  $ pulumi import aws:ec2/route:Route my_route rtb-656C65616E6F72_pl-0570a1d2d725c16be
 * ```
 * @property carrierGatewayId Identifier of a carrier gateway. This attribute can only be used when the VPC contains a subnet which is associated with a Wavelength Zone.
 * @property coreNetworkArn The Amazon Resource Name (ARN) of a core network.
 * @property destinationCidrBlock The destination CIDR block.
 * @property destinationIpv6CidrBlock The destination IPv6 CIDR block.
 * @property destinationPrefixListId The ID of a managed prefix list destination.
 * One of the following target arguments must be supplied:
 * @property egressOnlyGatewayId Identifier of a VPC Egress Only Internet Gateway.
 * @property gatewayId Identifier of a VPC internet gateway or a virtual private gateway. Specify `local` when updating a previously imported local route.
 * @property localGatewayId Identifier of a Outpost local gateway.
 * @property natGatewayId Identifier of a VPC NAT gateway.
 * @property networkInterfaceId Identifier of an EC2 network interface.
 * @property routeTableId The ID of the routing table.
 * One of the following destination arguments must be supplied:
 * @property transitGatewayId Identifier of an EC2 Transit Gateway.
 * @property vpcEndpointId Identifier of a VPC Endpoint.
 * @property vpcPeeringConnectionId Identifier of a VPC peering connection.
 * Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
 */
public data class RouteArgs(
    public val carrierGatewayId: Output<String>? = null,
    public val coreNetworkArn: Output<String>? = null,
    public val destinationCidrBlock: Output<String>? = null,
    public val destinationIpv6CidrBlock: Output<String>? = null,
    public val destinationPrefixListId: Output<String>? = null,
    public val egressOnlyGatewayId: Output<String>? = null,
    public val gatewayId: Output<String>? = null,
    public val localGatewayId: Output<String>? = null,
    public val natGatewayId: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val routeTableId: Output<String>? = null,
    public val transitGatewayId: Output<String>? = null,
    public val vpcEndpointId: Output<String>? = null,
    public val vpcPeeringConnectionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.RouteArgs> {
    override fun toJava(): com.pulumi.aws.ec2.RouteArgs = com.pulumi.aws.ec2.RouteArgs.builder()
        .carrierGatewayId(carrierGatewayId?.applyValue({ args0 -> args0 }))
        .coreNetworkArn(coreNetworkArn?.applyValue({ args0 -> args0 }))
        .destinationCidrBlock(destinationCidrBlock?.applyValue({ args0 -> args0 }))
        .destinationIpv6CidrBlock(destinationIpv6CidrBlock?.applyValue({ args0 -> args0 }))
        .destinationPrefixListId(destinationPrefixListId?.applyValue({ args0 -> args0 }))
        .egressOnlyGatewayId(egressOnlyGatewayId?.applyValue({ args0 -> args0 }))
        .gatewayId(gatewayId?.applyValue({ args0 -> args0 }))
        .localGatewayId(localGatewayId?.applyValue({ args0 -> args0 }))
        .natGatewayId(natGatewayId?.applyValue({ args0 -> args0 }))
        .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
        .routeTableId(routeTableId?.applyValue({ args0 -> args0 }))
        .transitGatewayId(transitGatewayId?.applyValue({ args0 -> args0 }))
        .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 }))
        .vpcPeeringConnectionId(vpcPeeringConnectionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteArgs].
 */
@PulumiTagMarker
public class RouteArgsBuilder internal constructor() {
    private var carrierGatewayId: Output<String>? = null

    private var coreNetworkArn: Output<String>? = null

    private var destinationCidrBlock: Output<String>? = null

    private var destinationIpv6CidrBlock: Output<String>? = null

    private var destinationPrefixListId: Output<String>? = null

    private var egressOnlyGatewayId: Output<String>? = null

    private var gatewayId: Output<String>? = null

    private var localGatewayId: Output<String>? = null

    private var natGatewayId: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var routeTableId: Output<String>? = null

    private var transitGatewayId: Output<String>? = null

    private var vpcEndpointId: Output<String>? = null

    private var vpcPeeringConnectionId: Output<String>? = null

    /**
     * @param value Identifier of a carrier gateway. This attribute can only be used when the VPC contains a subnet which is associated with a Wavelength Zone.
     */
    @JvmName("xaspywenyqbcyjjq")
    public suspend fun carrierGatewayId(`value`: Output<String>) {
        this.carrierGatewayId = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a core network.
     */
    @JvmName("ovelkpbxwnckojwa")
    public suspend fun coreNetworkArn(`value`: Output<String>) {
        this.coreNetworkArn = value
    }

    /**
     * @param value The destination CIDR block.
     */
    @JvmName("lvxpohtspglbcbjs")
    public suspend fun destinationCidrBlock(`value`: Output<String>) {
        this.destinationCidrBlock = value
    }

    /**
     * @param value The destination IPv6 CIDR block.
     */
    @JvmName("xiqcvptdnrpnmqwo")
    public suspend fun destinationIpv6CidrBlock(`value`: Output<String>) {
        this.destinationIpv6CidrBlock = value
    }

    /**
     * @param value The ID of a managed prefix list destination.
     * One of the following target arguments must be supplied:
     */
    @JvmName("uffvqfkcpoameyyl")
    public suspend fun destinationPrefixListId(`value`: Output<String>) {
        this.destinationPrefixListId = value
    }

    /**
     * @param value Identifier of a VPC Egress Only Internet Gateway.
     */
    @JvmName("ocptqbegigffueup")
    public suspend fun egressOnlyGatewayId(`value`: Output<String>) {
        this.egressOnlyGatewayId = value
    }

    /**
     * @param value Identifier of a VPC internet gateway or a virtual private gateway. Specify `local` when updating a previously imported local route.
     */
    @JvmName("qdgfhrtkuylcenbq")
    public suspend fun gatewayId(`value`: Output<String>) {
        this.gatewayId = value
    }

    /**
     * @param value Identifier of a Outpost local gateway.
     */
    @JvmName("cypqxdapnphfpudj")
    public suspend fun localGatewayId(`value`: Output<String>) {
        this.localGatewayId = value
    }

    /**
     * @param value Identifier of a VPC NAT gateway.
     */
    @JvmName("kyrpsgpfvfaqbfdk")
    public suspend fun natGatewayId(`value`: Output<String>) {
        this.natGatewayId = value
    }

    /**
     * @param value Identifier of an EC2 network interface.
     */
    @JvmName("qxrnarfufdnqdrub")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The ID of the routing table.
     * One of the following destination arguments must be supplied:
     */
    @JvmName("pchgnsbaobehrsvt")
    public suspend fun routeTableId(`value`: Output<String>) {
        this.routeTableId = value
    }

    /**
     * @param value Identifier of an EC2 Transit Gateway.
     */
    @JvmName("wcafedtlolppbksy")
    public suspend fun transitGatewayId(`value`: Output<String>) {
        this.transitGatewayId = value
    }

    /**
     * @param value Identifier of a VPC Endpoint.
     */
    @JvmName("ejgntpfnvwrlgtvt")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value Identifier of a VPC peering connection.
     * Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
     */
    @JvmName("aglgxtdrtktkywae")
    public suspend fun vpcPeeringConnectionId(`value`: Output<String>) {
        this.vpcPeeringConnectionId = value
    }

    /**
     * @param value Identifier of a carrier gateway. This attribute can only be used when the VPC contains a subnet which is associated with a Wavelength Zone.
     */
    @JvmName("wwegvaabifpwxlol")
    public suspend fun carrierGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.carrierGatewayId = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a core network.
     */
    @JvmName("rxrjidapydmbmurb")
    public suspend fun coreNetworkArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreNetworkArn = mapped
    }

    /**
     * @param value The destination CIDR block.
     */
    @JvmName("ucddggjhbnciavjh")
    public suspend fun destinationCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationCidrBlock = mapped
    }

    /**
     * @param value The destination IPv6 CIDR block.
     */
    @JvmName("aycogpdsuoywaeqw")
    public suspend fun destinationIpv6CidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationIpv6CidrBlock = mapped
    }

    /**
     * @param value The ID of a managed prefix list destination.
     * One of the following target arguments must be supplied:
     */
    @JvmName("hovkcflvtrhdmofg")
    public suspend fun destinationPrefixListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPrefixListId = mapped
    }

    /**
     * @param value Identifier of a VPC Egress Only Internet Gateway.
     */
    @JvmName("tedscjefphtwfupv")
    public suspend fun egressOnlyGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressOnlyGatewayId = mapped
    }

    /**
     * @param value Identifier of a VPC internet gateway or a virtual private gateway. Specify `local` when updating a previously imported local route.
     */
    @JvmName("hjxistsyjwxhlbic")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayId = mapped
    }

    /**
     * @param value Identifier of a Outpost local gateway.
     */
    @JvmName("qxkheygrqunwhavl")
    public suspend fun localGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localGatewayId = mapped
    }

    /**
     * @param value Identifier of a VPC NAT gateway.
     */
    @JvmName("mbhhhvbohcrvnyqy")
    public suspend fun natGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGatewayId = mapped
    }

    /**
     * @param value Identifier of an EC2 network interface.
     */
    @JvmName("lsxybdrxrsjaujri")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The ID of the routing table.
     * One of the following destination arguments must be supplied:
     */
    @JvmName("ktngivninajplxay")
    public suspend fun routeTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableId = mapped
    }

    /**
     * @param value Identifier of an EC2 Transit Gateway.
     */
    @JvmName("lqqqxinxevhbdmti")
    public suspend fun transitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayId = mapped
    }

    /**
     * @param value Identifier of a VPC Endpoint.
     */
    @JvmName("ivabjkdwxmscuwrm")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    /**
     * @param value Identifier of a VPC peering connection.
     * Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
     */
    @JvmName("mtdtonlbnsahxfof")
    public suspend fun vpcPeeringConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcPeeringConnectionId = mapped
    }

    internal fun build(): RouteArgs = RouteArgs(
        carrierGatewayId = carrierGatewayId,
        coreNetworkArn = coreNetworkArn,
        destinationCidrBlock = destinationCidrBlock,
        destinationIpv6CidrBlock = destinationIpv6CidrBlock,
        destinationPrefixListId = destinationPrefixListId,
        egressOnlyGatewayId = egressOnlyGatewayId,
        gatewayId = gatewayId,
        localGatewayId = localGatewayId,
        natGatewayId = natGatewayId,
        networkInterfaceId = networkInterfaceId,
        routeTableId = routeTableId,
        transitGatewayId = transitGatewayId,
        vpcEndpointId = vpcEndpointId,
        vpcPeeringConnectionId = vpcPeeringConnectionId,
    )
}
