@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.RouteTableRoute
import com.pulumi.aws.ec2.kotlin.outputs.RouteTableRoute.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [RouteTable].
 */
@PulumiTagMarker
public class RouteTableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteTableArgs = RouteTableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteTableArgsBuilder.() -> Unit) {
        val builder = RouteTableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RouteTable {
        val builtJavaResource = com.pulumi.aws.ec2.RouteTable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouteTable(builtJavaResource)
    }
}

/**
 * Provides a resource to create a VPC routing table.
 * > **NOTE on Route Tables and Routes:** This provider currently
 * provides both a standalone Route resource and a Route Table resource with routes
 * defined in-line. At this time you cannot use a Route Table with in-line routes
 * in conjunction with any Route resources. Doing so will cause
 * a conflict of rule settings and will overwrite rules.
 * > **NOTE on `gateway_id` and `nat_gateway_id`:** The AWS API is very forgiving with these two
 * attributes and the `aws.ec2.RouteTable` resource can be created with a NAT ID specified as a Gateway ID attribute.
 * This _will_ lead to a permanent diff between your configuration and statefile, as the API returns the correct
 * parameters in the returned route table. If you're experiencing constant diffs in your `aws.ec2.RouteTable` resources,
 * the first thing to check is whether or not you're specifying a NAT ID instead of a Gateway ID, or vice-versa.
 * > **NOTE on `propagating_vgws` and the `aws.ec2.VpnGatewayRoutePropagation` resource:**
 * If the `propagating_vgws` argument is present, it's not supported to _also_
 * define route propagations using `aws.ec2.VpnGatewayRoutePropagation`, since
 * this resource will delete any propagating gateways not explicitly listed in
 * `propagating_vgws`. Omit this argument when defining route propagation using
 * the separate resource.
 * ## Example Usage
 * ### Basic example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.RouteTable;
 * import com.pulumi.aws.ec2.RouteTableArgs;
 * import com.pulumi.aws.ec2.inputs.RouteTableRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RouteTable("example", RouteTableArgs.builder()
 *             .vpcId(aws_vpc.example().id())
 *             .routes(
 *                 RouteTableRouteArgs.builder()
 *                     .cidrBlock("10.0.1.0/24")
 *                     .gatewayId(aws_internet_gateway.example().id())
 *                     .build(),
 *                 RouteTableRouteArgs.builder()
 *                     .ipv6CidrBlock("::/0")
 *                     .egressOnlyGatewayId(aws_egress_only_internet_gateway.example().id())
 *                     .build())
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ### Adopting an existing local route
 * AWS creates certain routes that the AWS provider mostly ignores. You can manage them by importing or adopting them. See Import below for information on importing. This example shows adopting a route and then updating its target.
 * First, adopt an existing AWS-created route:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.RouteTable;
 * import com.pulumi.aws.ec2.RouteTableArgs;
 * import com.pulumi.aws.ec2.inputs.RouteTableRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testVpc = new Vpc("testVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var testRouteTable = new RouteTable("testRouteTable", RouteTableArgs.builder()
 *             .vpcId(testVpc.id())
 *             .routes(RouteTableRouteArgs.builder()
 *                 .cidrBlock("10.1.0.0/16")
 *                 .gatewayId("local")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route Tables using the route table `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/routeTable:RouteTable public_rt rtb-4e616f6d69
 * ```
 *
 */
public class RouteTable internal constructor(
    override val javaResource: com.pulumi.aws.ec2.RouteTable,
) : KotlinCustomResource(javaResource, RouteTableMapper) {
    /**
     * The ARN of the route table.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of the AWS account that owns the route table.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * A list of virtual gateways for propagation.
     */
    public val propagatingVgws: Output<List<String>>
        get() = javaResource.propagatingVgws().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A list of route objects. Their keys are documented below.
     * This means that omitting this argument is interpreted as ignoring any existing routes. To remove all managed routes an empty list should be specified. See the example above.
     */
    public val routes: Output<List<RouteTableRoute>>
        get() = javaResource.routes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The VPC ID.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object RouteTableMapper : ResourceMapper<RouteTable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.RouteTable::class == javaResource::class

    override fun map(javaResource: Resource): RouteTable = RouteTable(
        javaResource as
            com.pulumi.aws.ec2.RouteTable,
    )
}

/**
 * @see [RouteTable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteTable].
 */
public suspend fun routeTable(name: String, block: suspend RouteTableResourceBuilder.() -> Unit):
    RouteTable {
    val builder = RouteTableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteTable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeTable(name: String): RouteTable {
    val builder = RouteTableResourceBuilder()
    builder.name(name)
    return builder.build()
}
