@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.RouteTableArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.RouteTableRouteArgs
import com.pulumi.aws.ec2.kotlin.inputs.RouteTableRouteArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to create a VPC routing table.
 * > **NOTE on Route Tables and Routes:** This provider currently
 * provides both a standalone Route resource and a Route Table resource with routes
 * defined in-line. At this time you cannot use a Route Table with in-line routes
 * in conjunction with any Route resources. Doing so will cause
 * a conflict of rule settings and will overwrite rules.
 * > **NOTE on `gateway_id` and `nat_gateway_id`:** The AWS API is very forgiving with these two
 * attributes and the `aws.ec2.RouteTable` resource can be created with a NAT ID specified as a Gateway ID attribute.
 * This _will_ lead to a permanent diff between your configuration and statefile, as the API returns the correct
 * parameters in the returned route table. If you're experiencing constant diffs in your `aws.ec2.RouteTable` resources,
 * the first thing to check is whether or not you're specifying a NAT ID instead of a Gateway ID, or vice-versa.
 * > **NOTE on `propagating_vgws` and the `aws.ec2.VpnGatewayRoutePropagation` resource:**
 * If the `propagating_vgws` argument is present, it's not supported to _also_
 * define route propagations using `aws.ec2.VpnGatewayRoutePropagation`, since
 * this resource will delete any propagating gateways not explicitly listed in
 * `propagating_vgws`. Omit this argument when defining route propagation using
 * the separate resource.
 * ## Example Usage
 * ### Basic example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.RouteTable;
 * import com.pulumi.aws.ec2.RouteTableArgs;
 * import com.pulumi.aws.ec2.inputs.RouteTableRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RouteTable("example", RouteTableArgs.builder()
 *             .vpcId(aws_vpc.example().id())
 *             .routes(
 *                 RouteTableRouteArgs.builder()
 *                     .cidrBlock("10.0.1.0/24")
 *                     .gatewayId(aws_internet_gateway.example().id())
 *                     .build(),
 *                 RouteTableRouteArgs.builder()
 *                     .ipv6CidrBlock("::/0")
 *                     .egressOnlyGatewayId(aws_egress_only_internet_gateway.example().id())
 *                     .build())
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ### Adopting an existing local route
 * AWS creates certain routes that the AWS provider mostly ignores. You can manage them by importing or adopting them. See Import below for information on importing. This example shows adopting a route and then updating its target.
 * First, adopt an existing AWS-created route:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.RouteTable;
 * import com.pulumi.aws.ec2.RouteTableArgs;
 * import com.pulumi.aws.ec2.inputs.RouteTableRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testVpc = new Vpc("testVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var testRouteTable = new RouteTable("testRouteTable", RouteTableArgs.builder()
 *             .vpcId(testVpc.id())
 *             .routes(RouteTableRouteArgs.builder()
 *                 .cidrBlock("10.1.0.0/16")
 *                 .gatewayId("local")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route Tables using the route table `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/routeTable:RouteTable public_rt rtb-4e616f6d69
 * ```
 * @property propagatingVgws A list of virtual gateways for propagation.
 * @property routes A list of route objects. Their keys are documented below.
 * This means that omitting this argument is interpreted as ignoring any existing routes. To remove all managed routes an empty list should be specified. See the example above.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcId The VPC ID.
 */
public data class RouteTableArgs(
    public val propagatingVgws: Output<List<String>>? = null,
    public val routes: Output<List<RouteTableRouteArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.RouteTableArgs> {
    override fun toJava(): com.pulumi.aws.ec2.RouteTableArgs =
        com.pulumi.aws.ec2.RouteTableArgs.builder()
            .propagatingVgws(propagatingVgws?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .routes(routes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteTableArgs].
 */
@PulumiTagMarker
public class RouteTableArgsBuilder internal constructor() {
    private var propagatingVgws: Output<List<String>>? = null

    private var routes: Output<List<RouteTableRouteArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value A list of virtual gateways for propagation.
     */
    @JvmName("kvqjytplccktkgbv")
    public suspend fun propagatingVgws(`value`: Output<List<String>>) {
        this.propagatingVgws = value
    }

    @JvmName("srownqrxnysvysmv")
    public suspend fun propagatingVgws(vararg values: Output<String>) {
        this.propagatingVgws = Output.all(values.asList())
    }

    /**
     * @param values A list of virtual gateways for propagation.
     */
    @JvmName("blsivlqmligcdpqu")
    public suspend fun propagatingVgws(values: List<Output<String>>) {
        this.propagatingVgws = Output.all(values)
    }

    /**
     * @param value A list of route objects. Their keys are documented below.
     * This means that omitting this argument is interpreted as ignoring any existing routes. To remove all managed routes an empty list should be specified. See the example above.
     */
    @JvmName("vvopudspftdswrmn")
    public suspend fun routes(`value`: Output<List<RouteTableRouteArgs>>) {
        this.routes = value
    }

    @JvmName("agefshouwppdlrqm")
    public suspend fun routes(vararg values: Output<RouteTableRouteArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values A list of route objects. Their keys are documented below.
     * This means that omitting this argument is interpreted as ignoring any existing routes. To remove all managed routes an empty list should be specified. See the example above.
     */
    @JvmName("dbdekhbfjjvyqlne")
    public suspend fun routes(values: List<Output<RouteTableRouteArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hgpjoeuphgliplxe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VPC ID.
     */
    @JvmName("kxvxcaepurctvbpx")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value A list of virtual gateways for propagation.
     */
    @JvmName("kcikcuqrtcwqxmgn")
    public suspend fun propagatingVgws(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propagatingVgws = mapped
    }

    /**
     * @param values A list of virtual gateways for propagation.
     */
    @JvmName("gipjetvikvyxxbal")
    public suspend fun propagatingVgws(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propagatingVgws = mapped
    }

    /**
     * @param value A list of route objects. Their keys are documented below.
     * This means that omitting this argument is interpreted as ignoring any existing routes. To remove all managed routes an empty list should be specified. See the example above.
     */
    @JvmName("xrlngibxejtvgggt")
    public suspend fun routes(`value`: List<RouteTableRouteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument A list of route objects. Their keys are documented below.
     * This means that omitting this argument is interpreted as ignoring any existing routes. To remove all managed routes an empty list should be specified. See the example above.
     */
    @JvmName("aknhxxstkingwlos")
    public suspend fun routes(argument: List<suspend RouteTableRouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteTableRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument A list of route objects. Their keys are documented below.
     * This means that omitting this argument is interpreted as ignoring any existing routes. To remove all managed routes an empty list should be specified. See the example above.
     */
    @JvmName("vlmqysojupncclxq")
    public suspend fun routes(vararg argument: suspend RouteTableRouteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RouteTableRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument A list of route objects. Their keys are documented below.
     * This means that omitting this argument is interpreted as ignoring any existing routes. To remove all managed routes an empty list should be specified. See the example above.
     */
    @JvmName("rruexlplsoilswei")
    public suspend fun routes(argument: suspend RouteTableRouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RouteTableRouteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values A list of route objects. Their keys are documented below.
     * This means that omitting this argument is interpreted as ignoring any existing routes. To remove all managed routes an empty list should be specified. See the example above.
     */
    @JvmName("jooidncfllpsgfts")
    public suspend fun routes(vararg values: RouteTableRouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mvwsbjqwhomjgvpl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ortwjogidmqresaq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VPC ID.
     */
    @JvmName("vsvucwtlglkvwvth")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): RouteTableArgs = RouteTableArgs(
        propagatingVgws = propagatingVgws,
        routes = routes,
        tags = tags,
        vpcId = vpcId,
    )
}
