@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RouteTableAssociation].
 */
@PulumiTagMarker
public class RouteTableAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteTableAssociationArgs = RouteTableAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteTableAssociationArgsBuilder.() -> Unit) {
        val builder = RouteTableAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RouteTableAssociation {
        val builtJavaResource = com.pulumi.aws.ec2.RouteTableAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouteTableAssociation(builtJavaResource)
    }
}

/**
 * Provides a resource to create an association between a route table and a subnet or a route table and an
 * internet gateway or virtual private gateway.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.RouteTableAssociation;
 * import com.pulumi.aws.ec2.RouteTableAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routeTableAssociation = new RouteTableAssociation("routeTableAssociation", RouteTableAssociationArgs.builder()
 *             .subnetId(aws_subnet.foo().id())
 *             .routeTableId(aws_route_table.bar().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * With EC2 Internet Gateways:
 * __Using `pulumi import` to import__ EC2 Route Table Associations using the associated resource ID and Route Table ID separated by a forward slash (`/`). For example:
 * With EC2 Subnets:
 * ```sh
 *  $ pulumi import aws:ec2/routeTableAssociation:RouteTableAssociation assoc subnet-6777656e646f6c796e/rtb-656c65616e6f72
 * ```
 *  With EC2 Internet Gateways:
 * ```sh
 *  $ pulumi import aws:ec2/routeTableAssociation:RouteTableAssociation assoc igw-01b3a60780f8d034a/rtb-656c65616e6f72
 * ```
 *
 */
public class RouteTableAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.RouteTableAssociation,
) : KotlinCustomResource(javaResource, RouteTableAssociationMapper) {
    /**
     * The gateway ID to create an association. Conflicts with `subnet_id`.
     */
    public val gatewayId: Output<String>?
        get() = javaResource.gatewayId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the routing table to associate with.
     */
    public val routeTableId: Output<String>
        get() = javaResource.routeTableId().applyValue({ args0 -> args0 })

    /**
     * The subnet ID to create an association. Conflicts with `gateway_id`.
     */
    public val subnetId: Output<String>?
        get() = javaResource.subnetId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object RouteTableAssociationMapper : ResourceMapper<RouteTableAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.RouteTableAssociation::class == javaResource::class

    override fun map(javaResource: Resource): RouteTableAssociation =
        RouteTableAssociation(javaResource as com.pulumi.aws.ec2.RouteTableAssociation)
}

/**
 * @see [RouteTableAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteTableAssociation].
 */
public suspend fun routeTableAssociation(
    name: String,
    block: suspend RouteTableAssociationResourceBuilder.() -> Unit,
): RouteTableAssociation {
    val builder = RouteTableAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteTableAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeTableAssociation(name: String): RouteTableAssociation {
    val builder = RouteTableAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
