@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.RouteTableAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an association between a route table and a subnet or a route table and an
 * internet gateway or virtual private gateway.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.RouteTableAssociation;
 * import com.pulumi.aws.ec2.RouteTableAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routeTableAssociation = new RouteTableAssociation("routeTableAssociation", RouteTableAssociationArgs.builder()
 *             .subnetId(aws_subnet.foo().id())
 *             .routeTableId(aws_route_table.bar().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * With EC2 Internet Gateways:
 * __Using `pulumi import` to import__ EC2 Route Table Associations using the associated resource ID and Route Table ID separated by a forward slash (`/`). For example:
 * With EC2 Subnets:
 * ```sh
 *  $ pulumi import aws:ec2/routeTableAssociation:RouteTableAssociation assoc subnet-6777656e646f6c796e/rtb-656c65616e6f72
 * ```
 *  With EC2 Internet Gateways:
 * ```sh
 *  $ pulumi import aws:ec2/routeTableAssociation:RouteTableAssociation assoc igw-01b3a60780f8d034a/rtb-656c65616e6f72
 * ```
 * @property gatewayId The gateway ID to create an association. Conflicts with `subnet_id`.
 * @property routeTableId The ID of the routing table to associate with.
 * @property subnetId The subnet ID to create an association. Conflicts with `gateway_id`.
 */
public data class RouteTableAssociationArgs(
    public val gatewayId: Output<String>? = null,
    public val routeTableId: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.RouteTableAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.RouteTableAssociationArgs =
        com.pulumi.aws.ec2.RouteTableAssociationArgs.builder()
            .gatewayId(gatewayId?.applyValue({ args0 -> args0 }))
            .routeTableId(routeTableId?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteTableAssociationArgs].
 */
@PulumiTagMarker
public class RouteTableAssociationArgsBuilder internal constructor() {
    private var gatewayId: Output<String>? = null

    private var routeTableId: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The gateway ID to create an association. Conflicts with `subnet_id`.
     */
    @JvmName("ofvytmxborcyjxct")
    public suspend fun gatewayId(`value`: Output<String>) {
        this.gatewayId = value
    }

    /**
     * @param value The ID of the routing table to associate with.
     */
    @JvmName("amotblmnuljjqfdq")
    public suspend fun routeTableId(`value`: Output<String>) {
        this.routeTableId = value
    }

    /**
     * @param value The subnet ID to create an association. Conflicts with `gateway_id`.
     */
    @JvmName("owbbtctauykktaxx")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The gateway ID to create an association. Conflicts with `subnet_id`.
     */
    @JvmName("dyayftnavikmercd")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayId = mapped
    }

    /**
     * @param value The ID of the routing table to associate with.
     */
    @JvmName("emefmpemeohoeufl")
    public suspend fun routeTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableId = mapped
    }

    /**
     * @param value The subnet ID to create an association. Conflicts with `gateway_id`.
     */
    @JvmName("fhukukjmgsyiqgyq")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): RouteTableAssociationArgs = RouteTableAssociationArgs(
        gatewayId = gatewayId,
        routeTableId = routeTableId,
        subnetId = subnetId,
    )
}
