@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.SecurityGroupEgress
import com.pulumi.aws.ec2.kotlin.outputs.SecurityGroupIngress
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.SecurityGroupEgress.Companion.toKotlin as securityGroupEgressToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SecurityGroupIngress.Companion.toKotlin as securityGroupIngressToKotlin

/**
 * Builder for [SecurityGroup].
 */
@PulumiTagMarker
public class SecurityGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityGroupArgs = SecurityGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityGroupArgsBuilder.() -> Unit) {
        val builder = SecurityGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SecurityGroup {
        val builtJavaResource = com.pulumi.aws.ec2.SecurityGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityGroup(builtJavaResource)
    }
}

/**
 * Provides a security group resource.
 * > **NOTE on Security Groups and Security Group Rules:** This provider currently provides a Security Group resource with `ingress` and `egress` rules defined in-line and a Security Group Rule resource which manages one or more `ingress` or `egress` rules. Both of these resource were added before AWS assigned a [security group rule unique ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules.html), and they do not work well in all scenarios using the`description` and `tags` attributes, which rely on the unique ID. The `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources have been added to address these limitations and should be used for all new security group rules. You should not use the `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources in conjunction with an `aws.ec2.SecurityGroup` resource with in-line rules or with `aws.ec2.SecurityGroupRule` resources defined for the same Security Group, as rule conflicts may occur and rules will be overwritten.
 * > **NOTE:** Referencing Security Groups across VPC peering has certain restrictions. More information is available in the [VPC Peering User Guide](https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-security-groups.html).
 * > **NOTE:** Due to [AWS Lambda improved VPC networking changes that began deploying in September 2019](https://aws.amazon.com/blogs/compute/announcing-improved-vpc-networking-for-aws-lambda-functions/), security groups associated with Lambda Functions can take up to 45 minutes to successfully delete.
 * > **NOTE:** The `cidr_blocks` and `ipv6_cidr_blocks` parameters are optional in the `ingress` and `egress` blocks. If nothing is specified, traffic will be blocked as described in _NOTE on Egress rules_ later.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs;
 * import com.pulumi.aws.ec2.inputs.SecurityGroupEgressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var allowTls = new SecurityGroup("allowTls", SecurityGroupArgs.builder()
 *             .description("Allow TLS inbound traffic")
 *             .vpcId(aws_vpc.main().id())
 *             .ingress(SecurityGroupIngressArgs.builder()
 *                 .description("TLS from VPC")
 *                 .fromPort(443)
 *                 .toPort(443)
 *                 .protocol("tcp")
 *                 .cidrBlocks(aws_vpc.main().cidr_block())
 *                 .ipv6CidrBlocks(aws_vpc.main().ipv6_cidr_block())
 *                 .build())
 *             .egress(SecurityGroupEgressArgs.builder()
 *                 .fromPort(0)
 *                 .toPort(0)
 *                 .protocol("-1")
 *                 .cidrBlocks("0.0.0.0/0")
 *                 .ipv6CidrBlocks("::/0")
 *                 .build())
 *             .tags(Map.of("Name", "allow_tls"))
 *             .build());
 *     }
 * }
 * ```
 * ### Usage With Prefix List IDs
 * Prefix Lists are either managed by AWS internally, or created by the customer using a
 * Prefix List resource. Prefix Lists provided by
 * AWS are associated with a prefix list name, or service name, that is linked to a specific region.
 * Prefix list IDs are exported on VPC Endpoints, so you can use this format:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.ec2.inputs.SecurityGroupEgressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myEndpoint = new VpcEndpoint("myEndpoint");
 *         var example = new SecurityGroup("example", SecurityGroupArgs.builder()
 *             .egress(SecurityGroupEgressArgs.builder()
 *                 .fromPort(0)
 *                 .toPort(0)
 *                 .protocol("-1")
 *                 .prefixListIds(myEndpoint.prefixListId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Removing All Ingress and Egress Rules
 * The `ingress` and `egress` arguments are processed in attributes-as-blocks mode. Due to this, removing these arguments from the configuration will **not** cause the provider to destroy the managed rules. To subsequently remove all managed ingress and egress rules:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityGroup("example", SecurityGroupArgs.builder()
 *             .vpcId(aws_vpc.example().id())
 *             .ingress()
 *             .egress()
 *             .build());
 *     }
 * }
 * ```
 * ### `create_before_destroy`
 * (This example is one approach to recreating security groups. For more information on the challenges and the _Security Group Deletion Problem_, see the section above.)
 * Normally, the provider first deletes the existing security group resource and then creates a new one. When a security group is associated with a resource, the delete won't succeed. You can invert the default behavior using the `create_before_destroy` meta argument:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityGroup("example");
 *     }
 * }
 * ```
 * ### `replace_triggered_by`
 * (This example is one approach to recreating security groups. For more information on the challenges and the _Security Group Deletion Problem_, see the section above.)
 * To replace a resource when a security group changes, use the `replace_triggered_by` meta argument. Note that in this example, the `aws.ec2.Instance` will be destroyed and created again when the `aws.ec2.SecurityGroup` changes.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSecurityGroup = new SecurityGroup("exampleSecurityGroup");
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .instanceType("t3.small")
 *             .vpcSecurityGroupIds(aws_security_group.test().id())
 *             .build());
 *     }
 * }
 * ```
 * ### Shorter timeout
 * (This example is one approach to recreating security groups. For more information on the challenges and the _Security Group Deletion Problem_, see the section above.)
 * If destroying a security group takes a long time, it may be because the provider cannot distinguish between a dependent object (_e.g._, a security group rule or EC2 instance) that is _in the process of being deleted_ and one that is not. In other words, it may be waiting for a train that isn't scheduled to arrive. To fail faster, shorten the `delete` timeout from the default timeout:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityGroup("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Security Groups using the security group `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroup:SecurityGroup elb_sg sg-903004f8
 * ```
 *
 */
public class SecurityGroup internal constructor(
    override val javaResource: com.pulumi.aws.ec2.SecurityGroup,
) : KotlinCustomResource(javaResource, SecurityGroupMapper) {
    /**
     * ARN of the security group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Security group description. Defaults to `Managed by Pulumi`. Cannot be `""`. **NOTE**: This field maps to the AWS `GroupDescription` attribute, for which there is no Update API. If you'd like to classify your security groups in a way that can be updated, use `tags`.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Configuration block for egress rules. Can be specified multiple times for each egress rule. Each egress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    public val egress: Output<List<SecurityGroupEgress>>
        get() = javaResource.egress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    securityGroupEgressToKotlin(args0)
                })
            })
        })

    /**
     * Configuration block for ingress rules. Can be specified multiple times for each ingress rule. Each ingress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    public val ingress: Output<List<SecurityGroupIngress>>
        get() = javaResource.ingress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    securityGroupIngressToKotlin(args0)
                })
            })
        })

    /**
     * Name of the security group. If omitted, the provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Owner ID.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * Instruct the provider to revoke all of the Security Groups attached ingress and egress rules before deleting the rule itself. This is normally not needed, however certain AWS services such as Elastic Map Reduce may automatically add required rules to security groups used with the service, and those rules may contain a cyclic dependency that prevent the security groups from being destroyed without removing the dependency first. Default `false`.
     */
    public val revokeRulesOnDelete: Output<Boolean>?
        get() = javaResource.revokeRulesOnDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * VPC ID. Defaults to the region's default VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object SecurityGroupMapper : ResourceMapper<SecurityGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.SecurityGroup::class == javaResource::class

    override fun map(javaResource: Resource): SecurityGroup = SecurityGroup(
        javaResource as
            com.pulumi.aws.ec2.SecurityGroup,
    )
}

/**
 * @see [SecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityGroup].
 */
public suspend fun securityGroup(
    name: String,
    block: suspend SecurityGroupResourceBuilder.() -> Unit,
): SecurityGroup {
    val builder = SecurityGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityGroup(name: String): SecurityGroup {
    val builder = SecurityGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
