@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.SecurityGroupArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.SecurityGroupEgressArgs
import com.pulumi.aws.ec2.kotlin.inputs.SecurityGroupEgressArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SecurityGroupIngressArgs
import com.pulumi.aws.ec2.kotlin.inputs.SecurityGroupIngressArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a security group resource.
 * > **NOTE on Security Groups and Security Group Rules:** This provider currently provides a Security Group resource with `ingress` and `egress` rules defined in-line and a Security Group Rule resource which manages one or more `ingress` or `egress` rules. Both of these resource were added before AWS assigned a [security group rule unique ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules.html), and they do not work well in all scenarios using the`description` and `tags` attributes, which rely on the unique ID. The `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources have been added to address these limitations and should be used for all new security group rules. You should not use the `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources in conjunction with an `aws.ec2.SecurityGroup` resource with in-line rules or with `aws.ec2.SecurityGroupRule` resources defined for the same Security Group, as rule conflicts may occur and rules will be overwritten.
 * > **NOTE:** Referencing Security Groups across VPC peering has certain restrictions. More information is available in the [VPC Peering User Guide](https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-security-groups.html).
 * > **NOTE:** Due to [AWS Lambda improved VPC networking changes that began deploying in September 2019](https://aws.amazon.com/blogs/compute/announcing-improved-vpc-networking-for-aws-lambda-functions/), security groups associated with Lambda Functions can take up to 45 minutes to successfully delete.
 * > **NOTE:** The `cidr_blocks` and `ipv6_cidr_blocks` parameters are optional in the `ingress` and `egress` blocks. If nothing is specified, traffic will be blocked as described in _NOTE on Egress rules_ later.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs;
 * import com.pulumi.aws.ec2.inputs.SecurityGroupEgressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var allowTls = new SecurityGroup("allowTls", SecurityGroupArgs.builder()
 *             .description("Allow TLS inbound traffic")
 *             .vpcId(aws_vpc.main().id())
 *             .ingress(SecurityGroupIngressArgs.builder()
 *                 .description("TLS from VPC")
 *                 .fromPort(443)
 *                 .toPort(443)
 *                 .protocol("tcp")
 *                 .cidrBlocks(aws_vpc.main().cidr_block())
 *                 .ipv6CidrBlocks(aws_vpc.main().ipv6_cidr_block())
 *                 .build())
 *             .egress(SecurityGroupEgressArgs.builder()
 *                 .fromPort(0)
 *                 .toPort(0)
 *                 .protocol("-1")
 *                 .cidrBlocks("0.0.0.0/0")
 *                 .ipv6CidrBlocks("::/0")
 *                 .build())
 *             .tags(Map.of("Name", "allow_tls"))
 *             .build());
 *     }
 * }
 * ```
 * ### Usage With Prefix List IDs
 * Prefix Lists are either managed by AWS internally, or created by the customer using a
 * Prefix List resource. Prefix Lists provided by
 * AWS are associated with a prefix list name, or service name, that is linked to a specific region.
 * Prefix list IDs are exported on VPC Endpoints, so you can use this format:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.ec2.inputs.SecurityGroupEgressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myEndpoint = new VpcEndpoint("myEndpoint");
 *         var example = new SecurityGroup("example", SecurityGroupArgs.builder()
 *             .egress(SecurityGroupEgressArgs.builder()
 *                 .fromPort(0)
 *                 .toPort(0)
 *                 .protocol("-1")
 *                 .prefixListIds(myEndpoint.prefixListId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Removing All Ingress and Egress Rules
 * The `ingress` and `egress` arguments are processed in attributes-as-blocks mode. Due to this, removing these arguments from the configuration will **not** cause the provider to destroy the managed rules. To subsequently remove all managed ingress and egress rules:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityGroup("example", SecurityGroupArgs.builder()
 *             .vpcId(aws_vpc.example().id())
 *             .ingress()
 *             .egress()
 *             .build());
 *     }
 * }
 * ```
 * ### `create_before_destroy`
 * (This example is one approach to recreating security groups. For more information on the challenges and the _Security Group Deletion Problem_, see the section above.)
 * Normally, the provider first deletes the existing security group resource and then creates a new one. When a security group is associated with a resource, the delete won't succeed. You can invert the default behavior using the `create_before_destroy` meta argument:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityGroup("example");
 *     }
 * }
 * ```
 * ### `replace_triggered_by`
 * (This example is one approach to recreating security groups. For more information on the challenges and the _Security Group Deletion Problem_, see the section above.)
 * To replace a resource when a security group changes, use the `replace_triggered_by` meta argument. Note that in this example, the `aws.ec2.Instance` will be destroyed and created again when the `aws.ec2.SecurityGroup` changes.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSecurityGroup = new SecurityGroup("exampleSecurityGroup");
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .instanceType("t3.small")
 *             .vpcSecurityGroupIds(aws_security_group.test().id())
 *             .build());
 *     }
 * }
 * ```
 * ### Shorter timeout
 * (This example is one approach to recreating security groups. For more information on the challenges and the _Security Group Deletion Problem_, see the section above.)
 * If destroying a security group takes a long time, it may be because the provider cannot distinguish between a dependent object (_e.g._, a security group rule or EC2 instance) that is _in the process of being deleted_ and one that is not. In other words, it may be waiting for a train that isn't scheduled to arrive. To fail faster, shorten the `delete` timeout from the default timeout:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityGroup("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Security Groups using the security group `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroup:SecurityGroup elb_sg sg-903004f8
 * ```
 * @property description Security group description. Defaults to `Managed by Pulumi`. Cannot be `""`. **NOTE**: This field maps to the AWS `GroupDescription` attribute, for which there is no Update API. If you'd like to classify your security groups in a way that can be updated, use `tags`.
 * @property egress Configuration block for egress rules. Can be specified multiple times for each egress rule. Each egress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
 * @property ingress Configuration block for ingress rules. Can be specified multiple times for each ingress rule. Each ingress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
 * @property name Name of the security group. If omitted, the provider will assign a random, unique name.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property revokeRulesOnDelete Instruct the provider to revoke all of the Security Groups attached ingress and egress rules before deleting the rule itself. This is normally not needed, however certain AWS services such as Elastic Map Reduce may automatically add required rules to security groups used with the service, and those rules may contain a cyclic dependency that prevent the security groups from being destroyed without removing the dependency first. Default `false`.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcId VPC ID. Defaults to the region's default VPC.
 */
public data class SecurityGroupArgs(
    public val description: Output<String>? = null,
    public val egress: Output<List<SecurityGroupEgressArgs>>? = null,
    public val ingress: Output<List<SecurityGroupIngressArgs>>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val revokeRulesOnDelete: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.SecurityGroupArgs> {
    override fun toJava(): com.pulumi.aws.ec2.SecurityGroupArgs =
        com.pulumi.aws.ec2.SecurityGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .egress(egress?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .ingress(
                ingress?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .revokeRulesOnDelete(revokeRulesOnDelete?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityGroupArgs].
 */
@PulumiTagMarker
public class SecurityGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var egress: Output<List<SecurityGroupEgressArgs>>? = null

    private var ingress: Output<List<SecurityGroupIngressArgs>>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var revokeRulesOnDelete: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Security group description. Defaults to `Managed by Pulumi`. Cannot be `""`. **NOTE**: This field maps to the AWS `GroupDescription` attribute, for which there is no Update API. If you'd like to classify your security groups in a way that can be updated, use `tags`.
     */
    @JvmName("etyehsdnvjturvdk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Configuration block for egress rules. Can be specified multiple times for each egress rule. Each egress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("arneoqlqrlogamdo")
    public suspend fun egress(`value`: Output<List<SecurityGroupEgressArgs>>) {
        this.egress = value
    }

    @JvmName("rhjwuoiwjtqrytkh")
    public suspend fun egress(vararg values: Output<SecurityGroupEgressArgs>) {
        this.egress = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for egress rules. Can be specified multiple times for each egress rule. Each egress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("uiwexcioygelsnbd")
    public suspend fun egress(values: List<Output<SecurityGroupEgressArgs>>) {
        this.egress = Output.all(values)
    }

    /**
     * @param value Configuration block for ingress rules. Can be specified multiple times for each ingress rule. Each ingress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("hylfjjhontymwxog")
    public suspend fun ingress(`value`: Output<List<SecurityGroupIngressArgs>>) {
        this.ingress = value
    }

    @JvmName("eyyediiuxpvnvmqm")
    public suspend fun ingress(vararg values: Output<SecurityGroupIngressArgs>) {
        this.ingress = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for ingress rules. Can be specified multiple times for each ingress rule. Each ingress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("vubdklnblhaefwll")
    public suspend fun ingress(values: List<Output<SecurityGroupIngressArgs>>) {
        this.ingress = Output.all(values)
    }

    /**
     * @param value Name of the security group. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("hvakddvxoqagkmuy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("hfetdadpqittcnty")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Instruct the provider to revoke all of the Security Groups attached ingress and egress rules before deleting the rule itself. This is normally not needed, however certain AWS services such as Elastic Map Reduce may automatically add required rules to security groups used with the service, and those rules may contain a cyclic dependency that prevent the security groups from being destroyed without removing the dependency first. Default `false`.
     */
    @JvmName("vgqftqmoooritfeg")
    public suspend fun revokeRulesOnDelete(`value`: Output<Boolean>) {
        this.revokeRulesOnDelete = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kxunaildswonmjdw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value VPC ID. Defaults to the region's default VPC.
     */
    @JvmName("vgeomsncuyikwtgi")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Security group description. Defaults to `Managed by Pulumi`. Cannot be `""`. **NOTE**: This field maps to the AWS `GroupDescription` attribute, for which there is no Update API. If you'd like to classify your security groups in a way that can be updated, use `tags`.
     */
    @JvmName("lhxslabjdmolrwjg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Configuration block for egress rules. Can be specified multiple times for each egress rule. Each egress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("unfiynbabecllpwx")
    public suspend fun egress(`value`: List<SecurityGroupEgressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egress = mapped
    }

    /**
     * @param argument Configuration block for egress rules. Can be specified multiple times for each egress rule. Each egress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("fwsfjthejccfurnd")
    public suspend fun egress(argument: List<suspend SecurityGroupEgressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SecurityGroupEgressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.egress = mapped
    }

    /**
     * @param argument Configuration block for egress rules. Can be specified multiple times for each egress rule. Each egress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("sfnkvefaijjkqtsg")
    public suspend fun egress(vararg argument: suspend SecurityGroupEgressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SecurityGroupEgressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.egress = mapped
    }

    /**
     * @param argument Configuration block for egress rules. Can be specified multiple times for each egress rule. Each egress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("xynbxxmnyerdbptq")
    public suspend fun egress(argument: suspend SecurityGroupEgressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SecurityGroupEgressArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.egress = mapped
    }

    /**
     * @param values Configuration block for egress rules. Can be specified multiple times for each egress rule. Each egress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("mjdfhmsvvnpihayy")
    public suspend fun egress(vararg values: SecurityGroupEgressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.egress = mapped
    }

    /**
     * @param value Configuration block for ingress rules. Can be specified multiple times for each ingress rule. Each ingress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("naobsatqlhhsmqyn")
    public suspend fun ingress(`value`: List<SecurityGroupIngressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingress = mapped
    }

    /**
     * @param argument Configuration block for ingress rules. Can be specified multiple times for each ingress rule. Each ingress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("gxarfnrcdoptnpkt")
    public suspend fun ingress(argument: List<suspend SecurityGroupIngressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SecurityGroupIngressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param argument Configuration block for ingress rules. Can be specified multiple times for each ingress rule. Each ingress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("mutfrklowhxppdqb")
    public suspend fun ingress(vararg argument: suspend SecurityGroupIngressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SecurityGroupIngressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param argument Configuration block for ingress rules. Can be specified multiple times for each ingress rule. Each ingress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("bvttifyegreynsps")
    public suspend fun ingress(argument: suspend SecurityGroupIngressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SecurityGroupIngressArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param values Configuration block for ingress rules. Can be specified multiple times for each ingress rule. Each ingress block supports fields documented below. This argument is processed in attribute-as-blocks mode.
     */
    @JvmName("ewccpbvqawonqvwl")
    public suspend fun ingress(vararg values: SecurityGroupIngressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingress = mapped
    }

    /**
     * @param value Name of the security group. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("xncpspgwfksywhtb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("pdivuxybipuxrpcf")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Instruct the provider to revoke all of the Security Groups attached ingress and egress rules before deleting the rule itself. This is normally not needed, however certain AWS services such as Elastic Map Reduce may automatically add required rules to security groups used with the service, and those rules may contain a cyclic dependency that prevent the security groups from being destroyed without removing the dependency first. Default `false`.
     */
    @JvmName("efynhwumplhouwos")
    public suspend fun revokeRulesOnDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revokeRulesOnDelete = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ijhuoxbwfqigqgir")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rkgjombmqyrwwdik")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value VPC ID. Defaults to the region's default VPC.
     */
    @JvmName("fhqmfskwujhsotcj")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): SecurityGroupArgs = SecurityGroupArgs(
        description = description,
        egress = egress,
        ingress = ingress,
        name = name,
        namePrefix = namePrefix,
        revokeRulesOnDelete = revokeRulesOnDelete,
        tags = tags,
        vpcId = vpcId,
    )
}
