@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SecurityGroupAssociation].
 */
@PulumiTagMarker
public class SecurityGroupAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityGroupAssociationArgs = SecurityGroupAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityGroupAssociationArgsBuilder.() -> Unit) {
        val builder = SecurityGroupAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SecurityGroupAssociation {
        val builtJavaResource = com.pulumi.aws.ec2.SecurityGroupAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityGroupAssociation(builtJavaResource)
    }
}

/**
 * Provides a resource to create an association between a VPC endpoint and a security group.
 * > **NOTE on VPC Endpoints and VPC Endpoint Security Group Associations:** The provider provides
 * both a standalone VPC Endpoint Security Group Association (an association between a VPC endpoint
 * and a single `security_group_id`) and a VPC Endpoint resource with a `security_group_ids`
 * attribute. Do not use the same security group ID in both a VPC Endpoint resource and a VPC Endpoint Security
 * Group Association resource. Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroupAssociation;
 * import com.pulumi.aws.ec2.SecurityGroupAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sgEc2 = new SecurityGroupAssociation("sgEc2", SecurityGroupAssociationArgs.builder()
 *             .vpcEndpointId(aws_vpc_endpoint.ec2().id())
 *             .securityGroupId(aws_security_group.sg().id())
 *             .build());
 *     }
 * }
 * ```
 */
public class SecurityGroupAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.SecurityGroupAssociation,
) : KotlinCustomResource(javaResource, SecurityGroupAssociationMapper) {
    /**
     * Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
     */
    public val replaceDefaultAssociation: Output<Boolean>?
        get() = javaResource.replaceDefaultAssociation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the security group to be associated with the VPC endpoint.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC endpoint with which the security group will be associated.
     */
    public val vpcEndpointId: Output<String>
        get() = javaResource.vpcEndpointId().applyValue({ args0 -> args0 })
}

public object SecurityGroupAssociationMapper : ResourceMapper<SecurityGroupAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.SecurityGroupAssociation::class == javaResource::class

    override fun map(javaResource: Resource): SecurityGroupAssociation =
        SecurityGroupAssociation(javaResource as com.pulumi.aws.ec2.SecurityGroupAssociation)
}

/**
 * @see [SecurityGroupAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityGroupAssociation].
 */
public suspend fun securityGroupAssociation(
    name: String,
    block: suspend SecurityGroupAssociationResourceBuilder.() -> Unit,
): SecurityGroupAssociation {
    val builder = SecurityGroupAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityGroupAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityGroupAssociation(name: String): SecurityGroupAssociation {
    val builder = SecurityGroupAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
