@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.SecurityGroupAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an association between a VPC endpoint and a security group.
 * > **NOTE on VPC Endpoints and VPC Endpoint Security Group Associations:** The provider provides
 * both a standalone VPC Endpoint Security Group Association (an association between a VPC endpoint
 * and a single `security_group_id`) and a VPC Endpoint resource with a `security_group_ids`
 * attribute. Do not use the same security group ID in both a VPC Endpoint resource and a VPC Endpoint Security
 * Group Association resource. Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroupAssociation;
 * import com.pulumi.aws.ec2.SecurityGroupAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sgEc2 = new SecurityGroupAssociation("sgEc2", SecurityGroupAssociationArgs.builder()
 *             .vpcEndpointId(aws_vpc_endpoint.ec2().id())
 *             .securityGroupId(aws_security_group.sg().id())
 *             .build());
 *     }
 * }
 * ```
 * @property replaceDefaultAssociation Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
 * @property securityGroupId The ID of the security group to be associated with the VPC endpoint.
 * @property vpcEndpointId The ID of the VPC endpoint with which the security group will be associated.
 */
public data class SecurityGroupAssociationArgs(
    public val replaceDefaultAssociation: Output<Boolean>? = null,
    public val securityGroupId: Output<String>? = null,
    public val vpcEndpointId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.SecurityGroupAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.SecurityGroupAssociationArgs =
        com.pulumi.aws.ec2.SecurityGroupAssociationArgs.builder()
            .replaceDefaultAssociation(replaceDefaultAssociation?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityGroupAssociationArgs].
 */
@PulumiTagMarker
public class SecurityGroupAssociationArgsBuilder internal constructor() {
    private var replaceDefaultAssociation: Output<Boolean>? = null

    private var securityGroupId: Output<String>? = null

    private var vpcEndpointId: Output<String>? = null

    /**
     * @param value Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
     */
    @JvmName("rqwfwemlbgkoljxx")
    public suspend fun replaceDefaultAssociation(`value`: Output<Boolean>) {
        this.replaceDefaultAssociation = value
    }

    /**
     * @param value The ID of the security group to be associated with the VPC endpoint.
     */
    @JvmName("knmsfcfnbskcxyru")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The ID of the VPC endpoint with which the security group will be associated.
     */
    @JvmName("epuacnplhojqorxp")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
     */
    @JvmName("mpdxodihonkktpgf")
    public suspend fun replaceDefaultAssociation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replaceDefaultAssociation = mapped
    }

    /**
     * @param value The ID of the security group to be associated with the VPC endpoint.
     */
    @JvmName("wdeceqlcvwsucjjl")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The ID of the VPC endpoint with which the security group will be associated.
     */
    @JvmName("snkpfsuqwitstsmw")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    internal fun build(): SecurityGroupAssociationArgs = SecurityGroupAssociationArgs(
        replaceDefaultAssociation = replaceDefaultAssociation,
        securityGroupId = securityGroupId,
        vpcEndpointId = vpcEndpointId,
    )
}
