@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SecurityGroupRule].
 */
@PulumiTagMarker
public class SecurityGroupRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityGroupRuleArgs = SecurityGroupRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityGroupRuleArgsBuilder.() -> Unit) {
        val builder = SecurityGroupRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SecurityGroupRule {
        val builtJavaResource = com.pulumi.aws.ec2.SecurityGroupRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityGroupRule(builtJavaResource)
    }
}

/**
 * Provides a security group rule resource. Represents a single `ingress` or
 * `egress` group rule, which can be added to external Security Groups.
 * > **NOTE on Security Groups and Security Group Rules:** This provider currently provides a Security Group resource with `ingress` and `egress` rules defined in-line and a Security Group Rule resource which manages one or more `ingress` or
 * `egress` rules. Both of these resource were added before AWS assigned a [security group rule unique ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules.html), and they do not work well in all scenarios using the`description` and `tags` attributes, which rely on the unique ID.
 * The `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources have been added to address these limitations and should be used for all new security group rules.
 * You should not use the `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources in conjunction with an `aws.ec2.SecurityGroup` resource with in-line rules or with `aws.ec2.SecurityGroupRule` resources defined for the same Security Group, as rule conflicts may occur and rules will be overwritten.
 * > **NOTE:** Setting `protocol = "all"` or `protocol = -1` with `from_port` and `to_port` will result in the EC2 API creating a security group rule with all ports open. This API behavior cannot be controlled by this provider and may generate warnings in the future.
 * > **NOTE:** Referencing Security Groups across VPC peering has certain restrictions. More information is available in the [VPC Peering User Guide](https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-security-groups.html).
 * ## Example Usage
 * Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroupRule;
 * import com.pulumi.aws.ec2.SecurityGroupRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityGroupRule("example", SecurityGroupRuleArgs.builder()
 *             .type("ingress")
 *             .fromPort(0)
 *             .toPort(65535)
 *             .protocol("tcp")
 *             .cidrBlocks(aws_vpc.example().cidr_block())
 *             .ipv6CidrBlocks(aws_vpc.example().ipv6_cidr_block())
 *             .securityGroupId("sg-123456")
 *             .build());
 *     }
 * }
 * ```
 * ### Usage With Prefix List IDs
 * Prefix Lists are either managed by AWS internally, or created by the customer using a
 * Managed Prefix List resource. Prefix Lists provided by
 * AWS are associated with a prefix list name, or service name, that is linked to a specific region.
 * Prefix list IDs are exported on VPC Endpoints, so you can use this format:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.SecurityGroupRule;
 * import com.pulumi.aws.ec2.SecurityGroupRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myEndpoint = new VpcEndpoint("myEndpoint");
 *         var allowAll = new SecurityGroupRule("allowAll", SecurityGroupRuleArgs.builder()
 *             .type("egress")
 *             .toPort(0)
 *             .protocol("-1")
 *             .prefixListIds(myEndpoint.prefixListId())
 *             .fromPort(0)
 *             .securityGroupId("sg-123456")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Import a rule with various IPv4 and IPv6 source CIDR blocks:
 * Import a rule, applicable to all ports, with a protocol other than TCP/UDP/ICMP/ICMPV6/ALL, e.g., Multicast Transport Protocol (MTP), using the IANA protocol number. For example92.
 * Import a default any/any egress rule to 0.0.0.0/0:
 * Import an egress rule with a prefix list ID destination:
 * Import a rule applicable to all protocols and ports with a security group source:
 * Import a rule that has itself and an IPv6 CIDR block as sources:
 * __Using `pulumi import` to import__ Security Group Rules using the `security_group_id`, `type`, `protocol`, `from_port`, `to_port`, and source(s)/destination(s) (such as a `cidr_block`) separated by underscores (`_`). All parts are required. For example:
 * __NOTE:__ Not all rule permissions (e.g., not all of a rule's CIDR blocks) need to be imported for this provider to manage rule permissions. However, importing some of a rule's permissions but not others, and then making changes to the rule will result in the creation of an additional rule to capture the updated permissions. Rule permissions that were not imported are left intact in the original rule.
 * Import an ingress rule in security group `sg-6e616f6d69` for TCP port 8000 with an IPv4 destination CIDR of `10.0.3.0/24`:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress sg-6e616f6d69_ingress_tcp_8000_8000_10.0.3.0/24
 * ```
 *  Import a rule with various IPv4 and IPv6 source CIDR blocks:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress sg-4973616163_ingress_tcp_100_121_10.1.0.0/16_2001:db8::/48_10.2.0.0/16_2002:db8::/48
 * ```
 *  Import a rule, applicable to all ports, with a protocol other than TCP/UDP/ICMP/ICMPV6/ALL, e.g., Multicast Transport Protocol (MTP), using the IANA protocol number. For example92.
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress sg-6777656e646f6c796e_ingress_92_0_65536_10.0.3.0/24_10.0.4.0/24
 * ```
 *  Import a default any/any egress rule to 0.0.0.0/0:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule default_egress sg-6777656e646f6c796e_egress_all_0_0_0.0.0.0/0
 * ```
 *  Import an egress rule with a prefix list ID destination:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule egress sg-62726f6479_egress_tcp_8000_8000_pl-6469726b
 * ```
 *  Import a rule applicable to all protocols and ports with a security group source:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress_rule sg-7472697374616e_ingress_all_0_65536_sg-6176657279
 * ```
 *  Import a rule that has itself and an IPv6 CIDR block as sources:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule rule_name sg-656c65616e6f72_ingress_tcp_80_80_self_2001:db8::/48
 * ```
 *
 */
public class SecurityGroupRule internal constructor(
    override val javaResource: com.pulumi.aws.ec2.SecurityGroupRule,
) : KotlinCustomResource(javaResource, SecurityGroupRuleMapper) {
    /**
     * List of CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
     */
    public val cidrBlocks: Output<List<String>>?
        get() = javaResource.cidrBlocks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Description of the rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Start port (or ICMP type number if protocol is "icmp" or "icmpv6").
     */
    public val fromPort: Output<Int>
        get() = javaResource.fromPort().applyValue({ args0 -> args0 })

    /**
     * List of IPv6 CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
     */
    public val ipv6CidrBlocks: Output<List<String>>?
        get() = javaResource.ipv6CidrBlocks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of Prefix List IDs.
     */
    public val prefixListIds: Output<List<String>>?
        get() = javaResource.prefixListIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Protocol. If not icmp, icmpv6, tcp, udp, or all use the [protocol number](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * Security group to apply this rule to.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * If the `aws.ec2.SecurityGroupRule` resource has a single source or destination then this is the AWS Security Group Rule resource ID. Otherwise it is empty.
     */
    public val securityGroupRuleId: Output<String>
        get() = javaResource.securityGroupRuleId().applyValue({ args0 -> args0 })

    /**
     * Whether the security group itself will be added as a source to this ingress rule. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `source_security_group_id`.
     */
    public val self: Output<Boolean>?
        get() = javaResource.self().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Security group id to allow access to/from, depending on the `type`. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `self`.
     */
    public val sourceSecurityGroupId: Output<String>
        get() = javaResource.sourceSecurityGroupId().applyValue({ args0 -> args0 })

    /**
     * End port (or ICMP code if protocol is "icmp").
     */
    public val toPort: Output<Int>
        get() = javaResource.toPort().applyValue({ args0 -> args0 })

    /**
     * Type of rule being created. Valid options are `ingress` (inbound)
     * or `egress` (outbound).
     * The following arguments are optional:
     * > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `source_security_group_id` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SecurityGroupRuleMapper : ResourceMapper<SecurityGroupRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.SecurityGroupRule::class == javaResource::class

    override fun map(javaResource: Resource): SecurityGroupRule = SecurityGroupRule(
        javaResource as
            com.pulumi.aws.ec2.SecurityGroupRule,
    )
}

/**
 * @see [SecurityGroupRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityGroupRule].
 */
public suspend fun securityGroupRule(
    name: String,
    block: suspend SecurityGroupRuleResourceBuilder.() -> Unit,
): SecurityGroupRule {
    val builder = SecurityGroupRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityGroupRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityGroupRule(name: String): SecurityGroupRule {
    val builder = SecurityGroupRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
