@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.SecurityGroupRuleArgs.builder
import com.pulumi.aws.ec2.kotlin.enums.ProtocolType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a security group rule resource. Represents a single `ingress` or
 * `egress` group rule, which can be added to external Security Groups.
 * > **NOTE on Security Groups and Security Group Rules:** This provider currently provides a Security Group resource with `ingress` and `egress` rules defined in-line and a Security Group Rule resource which manages one or more `ingress` or
 * `egress` rules. Both of these resource were added before AWS assigned a [security group rule unique ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules.html), and they do not work well in all scenarios using the`description` and `tags` attributes, which rely on the unique ID.
 * The `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources have been added to address these limitations and should be used for all new security group rules.
 * You should not use the `aws.vpc.SecurityGroupEgressRule` and `aws.vpc.SecurityGroupIngressRule` resources in conjunction with an `aws.ec2.SecurityGroup` resource with in-line rules or with `aws.ec2.SecurityGroupRule` resources defined for the same Security Group, as rule conflicts may occur and rules will be overwritten.
 * > **NOTE:** Setting `protocol = "all"` or `protocol = -1` with `from_port` and `to_port` will result in the EC2 API creating a security group rule with all ports open. This API behavior cannot be controlled by this provider and may generate warnings in the future.
 * > **NOTE:** Referencing Security Groups across VPC peering has certain restrictions. More information is available in the [VPC Peering User Guide](https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-security-groups.html).
 * ## Example Usage
 * Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroupRule;
 * import com.pulumi.aws.ec2.SecurityGroupRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityGroupRule("example", SecurityGroupRuleArgs.builder()
 *             .type("ingress")
 *             .fromPort(0)
 *             .toPort(65535)
 *             .protocol("tcp")
 *             .cidrBlocks(aws_vpc.example().cidr_block())
 *             .ipv6CidrBlocks(aws_vpc.example().ipv6_cidr_block())
 *             .securityGroupId("sg-123456")
 *             .build());
 *     }
 * }
 * ```
 * ### Usage With Prefix List IDs
 * Prefix Lists are either managed by AWS internally, or created by the customer using a
 * Managed Prefix List resource. Prefix Lists provided by
 * AWS are associated with a prefix list name, or service name, that is linked to a specific region.
 * Prefix list IDs are exported on VPC Endpoints, so you can use this format:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.SecurityGroupRule;
 * import com.pulumi.aws.ec2.SecurityGroupRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myEndpoint = new VpcEndpoint("myEndpoint");
 *         var allowAll = new SecurityGroupRule("allowAll", SecurityGroupRuleArgs.builder()
 *             .type("egress")
 *             .toPort(0)
 *             .protocol("-1")
 *             .prefixListIds(myEndpoint.prefixListId())
 *             .fromPort(0)
 *             .securityGroupId("sg-123456")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Import a rule with various IPv4 and IPv6 source CIDR blocks:
 * Import a rule, applicable to all ports, with a protocol other than TCP/UDP/ICMP/ICMPV6/ALL, e.g., Multicast Transport Protocol (MTP), using the IANA protocol number. For example92.
 * Import a default any/any egress rule to 0.0.0.0/0:
 * Import an egress rule with a prefix list ID destination:
 * Import a rule applicable to all protocols and ports with a security group source:
 * Import a rule that has itself and an IPv6 CIDR block as sources:
 * __Using `pulumi import` to import__ Security Group Rules using the `security_group_id`, `type`, `protocol`, `from_port`, `to_port`, and source(s)/destination(s) (such as a `cidr_block`) separated by underscores (`_`). All parts are required. For example:
 * __NOTE:__ Not all rule permissions (e.g., not all of a rule's CIDR blocks) need to be imported for this provider to manage rule permissions. However, importing some of a rule's permissions but not others, and then making changes to the rule will result in the creation of an additional rule to capture the updated permissions. Rule permissions that were not imported are left intact in the original rule.
 * Import an ingress rule in security group `sg-6e616f6d69` for TCP port 8000 with an IPv4 destination CIDR of `10.0.3.0/24`:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress sg-6e616f6d69_ingress_tcp_8000_8000_10.0.3.0/24
 * ```
 *  Import a rule with various IPv4 and IPv6 source CIDR blocks:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress sg-4973616163_ingress_tcp_100_121_10.1.0.0/16_2001:db8::/48_10.2.0.0/16_2002:db8::/48
 * ```
 *  Import a rule, applicable to all ports, with a protocol other than TCP/UDP/ICMP/ICMPV6/ALL, e.g., Multicast Transport Protocol (MTP), using the IANA protocol number. For example92.
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress sg-6777656e646f6c796e_ingress_92_0_65536_10.0.3.0/24_10.0.4.0/24
 * ```
 *  Import a default any/any egress rule to 0.0.0.0/0:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule default_egress sg-6777656e646f6c796e_egress_all_0_0_0.0.0.0/0
 * ```
 *  Import an egress rule with a prefix list ID destination:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule egress sg-62726f6479_egress_tcp_8000_8000_pl-6469726b
 * ```
 *  Import a rule applicable to all protocols and ports with a security group source:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress_rule sg-7472697374616e_ingress_all_0_65536_sg-6176657279
 * ```
 *  Import a rule that has itself and an IPv6 CIDR block as sources:
 * ```sh
 *  $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule rule_name sg-656c65616e6f72_ingress_tcp_80_80_self_2001:db8::/48
 * ```
 * @property cidrBlocks List of CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
 * @property description Description of the rule.
 * @property fromPort Start port (or ICMP type number if protocol is "icmp" or "icmpv6").
 * @property ipv6CidrBlocks List of IPv6 CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
 * @property prefixListIds List of Prefix List IDs.
 * @property protocol Protocol. If not icmp, icmpv6, tcp, udp, or all use the [protocol number](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
 * @property securityGroupId Security group to apply this rule to.
 * @property self Whether the security group itself will be added as a source to this ingress rule. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `source_security_group_id`.
 * @property sourceSecurityGroupId Security group id to allow access to/from, depending on the `type`. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `self`.
 * @property toPort End port (or ICMP code if protocol is "icmp").
 * @property type Type of rule being created. Valid options are `ingress` (inbound)
 * or `egress` (outbound).
 * The following arguments are optional:
 * > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `source_security_group_id` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
 */
public data class SecurityGroupRuleArgs(
    public val cidrBlocks: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val fromPort: Output<Int>? = null,
    public val ipv6CidrBlocks: Output<List<String>>? = null,
    public val prefixListIds: Output<List<String>>? = null,
    public val protocol: Output<Either<String, ProtocolType>>? = null,
    public val securityGroupId: Output<String>? = null,
    public val self: Output<Boolean>? = null,
    public val sourceSecurityGroupId: Output<String>? = null,
    public val toPort: Output<Int>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.SecurityGroupRuleArgs> {
    override fun toJava(): com.pulumi.aws.ec2.SecurityGroupRuleArgs =
        com.pulumi.aws.ec2.SecurityGroupRuleArgs.builder()
            .cidrBlocks(cidrBlocks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fromPort(fromPort?.applyValue({ args0 -> args0 }))
            .ipv6CidrBlocks(ipv6CidrBlocks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .prefixListIds(prefixListIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .self(self?.applyValue({ args0 -> args0 }))
            .sourceSecurityGroupId(sourceSecurityGroupId?.applyValue({ args0 -> args0 }))
            .toPort(toPort?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityGroupRuleArgs].
 */
@PulumiTagMarker
public class SecurityGroupRuleArgsBuilder internal constructor() {
    private var cidrBlocks: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var fromPort: Output<Int>? = null

    private var ipv6CidrBlocks: Output<List<String>>? = null

    private var prefixListIds: Output<List<String>>? = null

    private var protocol: Output<Either<String, ProtocolType>>? = null

    private var securityGroupId: Output<String>? = null

    private var self: Output<Boolean>? = null

    private var sourceSecurityGroupId: Output<String>? = null

    private var toPort: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
     */
    @JvmName("aihavsrtcexvniou")
    public suspend fun cidrBlocks(`value`: Output<List<String>>) {
        this.cidrBlocks = value
    }

    @JvmName("kxjnsqulfcgliqul")
    public suspend fun cidrBlocks(vararg values: Output<String>) {
        this.cidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values List of CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
     */
    @JvmName("cvrpkfhqkutrorfy")
    public suspend fun cidrBlocks(values: List<Output<String>>) {
        this.cidrBlocks = Output.all(values)
    }

    /**
     * @param value Description of the rule.
     */
    @JvmName("jumlpsdhvvraxkxd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Start port (or ICMP type number if protocol is "icmp" or "icmpv6").
     */
    @JvmName("udmahqvdujojivch")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value List of IPv6 CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
     */
    @JvmName("irmfmjjjtssrshln")
    public suspend fun ipv6CidrBlocks(`value`: Output<List<String>>) {
        this.ipv6CidrBlocks = value
    }

    @JvmName("kxqfqdvmrtsxmnkd")
    public suspend fun ipv6CidrBlocks(vararg values: Output<String>) {
        this.ipv6CidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values List of IPv6 CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
     */
    @JvmName("uxbqgyxalrkapimw")
    public suspend fun ipv6CidrBlocks(values: List<Output<String>>) {
        this.ipv6CidrBlocks = Output.all(values)
    }

    /**
     * @param value List of Prefix List IDs.
     */
    @JvmName("mtbbdticulwvxrnh")
    public suspend fun prefixListIds(`value`: Output<List<String>>) {
        this.prefixListIds = value
    }

    @JvmName("yvtqngfofjikufqb")
    public suspend fun prefixListIds(vararg values: Output<String>) {
        this.prefixListIds = Output.all(values.asList())
    }

    /**
     * @param values List of Prefix List IDs.
     */
    @JvmName("iaacewertoaedebp")
    public suspend fun prefixListIds(values: List<Output<String>>) {
        this.prefixListIds = Output.all(values)
    }

    /**
     * @param value Protocol. If not icmp, icmpv6, tcp, udp, or all use the [protocol number](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
     */
    @JvmName("psmucspswouqmjeg")
    public suspend fun protocol(`value`: Output<Either<String, ProtocolType>>) {
        this.protocol = value
    }

    /**
     * @param value Security group to apply this rule to.
     */
    @JvmName("eqdtrlatydxuailf")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value Whether the security group itself will be added as a source to this ingress rule. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `source_security_group_id`.
     */
    @JvmName("jkeihxbhqgphaobe")
    public suspend fun self(`value`: Output<Boolean>) {
        this.self = value
    }

    /**
     * @param value Security group id to allow access to/from, depending on the `type`. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `self`.
     */
    @JvmName("dqacuvcqyniehsbm")
    public suspend fun sourceSecurityGroupId(`value`: Output<String>) {
        this.sourceSecurityGroupId = value
    }

    /**
     * @param value End port (or ICMP code if protocol is "icmp").
     */
    @JvmName("mvbmhiwviucnunpy")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value Type of rule being created. Valid options are `ingress` (inbound)
     * or `egress` (outbound).
     * The following arguments are optional:
     * > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `source_security_group_id` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
     */
    @JvmName("mpwjlynnhslvulmp")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
     */
    @JvmName("mfuwqkvautbcgwqb")
    public suspend fun cidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlocks = mapped
    }

    /**
     * @param values List of CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
     */
    @JvmName("ymxtncbnmnokfpfx")
    public suspend fun cidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrBlocks = mapped
    }

    /**
     * @param value Description of the rule.
     */
    @JvmName("ytmwqtdyosnftwik")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Start port (or ICMP type number if protocol is "icmp" or "icmpv6").
     */
    @JvmName("leupjtllfpbxqrqc")
    public suspend fun fromPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value List of IPv6 CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
     */
    @JvmName("qwqjgmqwyofisptd")
    public suspend fun ipv6CidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlocks = mapped
    }

    /**
     * @param values List of IPv6 CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
     */
    @JvmName("jpigfaphbexqgjhk")
    public suspend fun ipv6CidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6CidrBlocks = mapped
    }

    /**
     * @param value List of Prefix List IDs.
     */
    @JvmName("qfqpxmlmqhyehvoa")
    public suspend fun prefixListIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixListIds = mapped
    }

    /**
     * @param values List of Prefix List IDs.
     */
    @JvmName("paxhjbkmbyqcxgiw")
    public suspend fun prefixListIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixListIds = mapped
    }

    /**
     * @param value Protocol. If not icmp, icmpv6, tcp, udp, or all use the [protocol number](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
     */
    @JvmName("avdgkogsmvjhjuoo")
    public suspend fun protocol(`value`: Either<String, ProtocolType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol. If not icmp, icmpv6, tcp, udp, or all use the [protocol number](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
     */
    @JvmName("ctmelypboyektcdw")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol. If not icmp, icmpv6, tcp, udp, or all use the [protocol number](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
     */
    @JvmName("jkxnikfljhgnjbso")
    public fun protocol(`value`: ProtocolType) {
        val toBeMapped = Either.ofRight<String, ProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Security group to apply this rule to.
     */
    @JvmName("bmkqpwmdpoaiqips")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value Whether the security group itself will be added as a source to this ingress rule. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `source_security_group_id`.
     */
    @JvmName("tfwibsictddgmnaw")
    public suspend fun self(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.self = mapped
    }

    /**
     * @param value Security group id to allow access to/from, depending on the `type`. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `self`.
     */
    @JvmName("gwyosfwxpaelxddn")
    public suspend fun sourceSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSecurityGroupId = mapped
    }

    /**
     * @param value End port (or ICMP code if protocol is "icmp").
     */
    @JvmName("tfhwnoxkaypksbif")
    public suspend fun toPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    /**
     * @param value Type of rule being created. Valid options are `ingress` (inbound)
     * or `egress` (outbound).
     * The following arguments are optional:
     * > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `source_security_group_id` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
     */
    @JvmName("bgrmwxiqomtdtouu")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SecurityGroupRuleArgs = SecurityGroupRuleArgs(
        cidrBlocks = cidrBlocks,
        description = description,
        fromPort = fromPort,
        ipv6CidrBlocks = ipv6CidrBlocks,
        prefixListIds = prefixListIds,
        protocol = protocol,
        securityGroupId = securityGroupId,
        self = self,
        sourceSecurityGroupId = sourceSecurityGroupId,
        toPort = toPort,
        type = type,
    )
}
