@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SerialConsoleAccess].
 */
@PulumiTagMarker
public class SerialConsoleAccessResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SerialConsoleAccessArgs = SerialConsoleAccessArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SerialConsoleAccessArgsBuilder.() -> Unit) {
        val builder = SerialConsoleAccessArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SerialConsoleAccess {
        val builtJavaResource = com.pulumi.aws.ec2.SerialConsoleAccess(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SerialConsoleAccess(builtJavaResource)
    }
}

/**
 * Provides a resource to manage whether serial console access is enabled for your AWS account in the current AWS region.
 * > **NOTE:** Removing this resource disables serial console access.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SerialConsoleAccess;
 * import com.pulumi.aws.ec2.SerialConsoleAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SerialConsoleAccess("example", SerialConsoleAccessArgs.builder()
 *             .enabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import serial console access state. For example:
 * ```sh
 *  $ pulumi import aws:ec2/serialConsoleAccess:SerialConsoleAccess example default
 * ```
 *
 */
public class SerialConsoleAccess internal constructor(
    override val javaResource: com.pulumi.aws.ec2.SerialConsoleAccess,
) : KotlinCustomResource(javaResource, SerialConsoleAccessMapper) {
    /**
     * Whether or not serial console access is enabled. Valid values are `true` or `false`. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SerialConsoleAccessMapper : ResourceMapper<SerialConsoleAccess> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.SerialConsoleAccess::class == javaResource::class

    override fun map(javaResource: Resource): SerialConsoleAccess = SerialConsoleAccess(
        javaResource
            as com.pulumi.aws.ec2.SerialConsoleAccess,
    )
}

/**
 * @see [SerialConsoleAccess].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SerialConsoleAccess].
 */
public suspend fun serialConsoleAccess(
    name: String,
    block: suspend SerialConsoleAccessResourceBuilder.() -> Unit,
): SerialConsoleAccess {
    val builder = SerialConsoleAccessResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SerialConsoleAccess].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serialConsoleAccess(name: String): SerialConsoleAccess {
    val builder = SerialConsoleAccessResourceBuilder()
    builder.name(name)
    return builder.build()
}
