@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.SerialConsoleAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage whether serial console access is enabled for your AWS account in the current AWS region.
 * > **NOTE:** Removing this resource disables serial console access.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SerialConsoleAccess;
 * import com.pulumi.aws.ec2.SerialConsoleAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SerialConsoleAccess("example", SerialConsoleAccessArgs.builder()
 *             .enabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import serial console access state. For example:
 * ```sh
 *  $ pulumi import aws:ec2/serialConsoleAccess:SerialConsoleAccess example default
 * ```
 * @property enabled Whether or not serial console access is enabled. Valid values are `true` or `false`. Defaults to `true`.
 */
public data class SerialConsoleAccessArgs(
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.SerialConsoleAccessArgs> {
    override fun toJava(): com.pulumi.aws.ec2.SerialConsoleAccessArgs =
        com.pulumi.aws.ec2.SerialConsoleAccessArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SerialConsoleAccessArgs].
 */
@PulumiTagMarker
public class SerialConsoleAccessArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether or not serial console access is enabled. Valid values are `true` or `false`. Defaults to `true`.
     */
    @JvmName("basfgexbwguqmleq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether or not serial console access is enabled. Valid values are `true` or `false`. Defaults to `true`.
     */
    @JvmName("ymbxxgerovivjdkg")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): SerialConsoleAccessArgs = SerialConsoleAccessArgs(
        enabled = enabled,
    )
}
