@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SnapshotCreateVolumePermission].
 */
@PulumiTagMarker
public class SnapshotCreateVolumePermissionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotCreateVolumePermissionArgs = SnapshotCreateVolumePermissionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotCreateVolumePermissionArgsBuilder.() -> Unit) {
        val builder = SnapshotCreateVolumePermissionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SnapshotCreateVolumePermission {
        val builtJavaResource =
            com.pulumi.aws.ec2.SnapshotCreateVolumePermission(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SnapshotCreateVolumePermission(builtJavaResource)
    }
}

/**
 * Adds permission to create volumes off of a given EBS Snapshot.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.Volume;
 * import com.pulumi.aws.ebs.VolumeArgs;
 * import com.pulumi.aws.ebs.Snapshot;
 * import com.pulumi.aws.ebs.SnapshotArgs;
 * import com.pulumi.aws.ec2.SnapshotCreateVolumePermission;
 * import com.pulumi.aws.ec2.SnapshotCreateVolumePermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Volume("example", VolumeArgs.builder()
 *             .availabilityZone("us-west-2a")
 *             .size(40)
 *             .build());
 *         var exampleSnapshot = new Snapshot("exampleSnapshot", SnapshotArgs.builder()
 *             .volumeId(example.id())
 *             .build());
 *         var examplePerm = new SnapshotCreateVolumePermission("examplePerm", SnapshotCreateVolumePermissionArgs.builder()
 *             .snapshotId(exampleSnapshot.id())
 *             .accountId("12345678")
 *             .build());
 *     }
 * }
 * ```
 */
public class SnapshotCreateVolumePermission internal constructor(
    override val javaResource: com.pulumi.aws.ec2.SnapshotCreateVolumePermission,
) : KotlinCustomResource(javaResource, SnapshotCreateVolumePermissionMapper) {
    /**
     * An AWS Account ID to add create volume permissions. The AWS Account cannot be the snapshot's owner
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * A snapshot ID
     */
    public val snapshotId: Output<String>
        get() = javaResource.snapshotId().applyValue({ args0 -> args0 })
}

public object SnapshotCreateVolumePermissionMapper : ResourceMapper<SnapshotCreateVolumePermission> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.SnapshotCreateVolumePermission::class == javaResource::class

    override fun map(javaResource: Resource): SnapshotCreateVolumePermission =
        SnapshotCreateVolumePermission(
            javaResource as
                com.pulumi.aws.ec2.SnapshotCreateVolumePermission,
        )
}

/**
 * @see [SnapshotCreateVolumePermission].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SnapshotCreateVolumePermission].
 */
public suspend fun snapshotCreateVolumePermission(
    name: String,
    block: suspend SnapshotCreateVolumePermissionResourceBuilder.() -> Unit,
):
    SnapshotCreateVolumePermission {
    val builder = SnapshotCreateVolumePermissionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SnapshotCreateVolumePermission].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshotCreateVolumePermission(name: String): SnapshotCreateVolumePermission {
    val builder = SnapshotCreateVolumePermissionResourceBuilder()
    builder.name(name)
    return builder.build()
}
