@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.SnapshotCreateVolumePermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Adds permission to create volumes off of a given EBS Snapshot.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.Volume;
 * import com.pulumi.aws.ebs.VolumeArgs;
 * import com.pulumi.aws.ebs.Snapshot;
 * import com.pulumi.aws.ebs.SnapshotArgs;
 * import com.pulumi.aws.ec2.SnapshotCreateVolumePermission;
 * import com.pulumi.aws.ec2.SnapshotCreateVolumePermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Volume("example", VolumeArgs.builder()
 *             .availabilityZone("us-west-2a")
 *             .size(40)
 *             .build());
 *         var exampleSnapshot = new Snapshot("exampleSnapshot", SnapshotArgs.builder()
 *             .volumeId(example.id())
 *             .build());
 *         var examplePerm = new SnapshotCreateVolumePermission("examplePerm", SnapshotCreateVolumePermissionArgs.builder()
 *             .snapshotId(exampleSnapshot.id())
 *             .accountId("12345678")
 *             .build());
 *     }
 * }
 * ```
 * @property accountId An AWS Account ID to add create volume permissions. The AWS Account cannot be the snapshot's owner
 * @property snapshotId A snapshot ID
 */
public data class SnapshotCreateVolumePermissionArgs(
    public val accountId: Output<String>? = null,
    public val snapshotId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.SnapshotCreateVolumePermissionArgs> {
    override fun toJava(): com.pulumi.aws.ec2.SnapshotCreateVolumePermissionArgs =
        com.pulumi.aws.ec2.SnapshotCreateVolumePermissionArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotCreateVolumePermissionArgs].
 */
@PulumiTagMarker
public class SnapshotCreateVolumePermissionArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var snapshotId: Output<String>? = null

    /**
     * @param value An AWS Account ID to add create volume permissions. The AWS Account cannot be the snapshot's owner
     */
    @JvmName("sxxmtukwvtqwdpxp")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value A snapshot ID
     */
    @JvmName("nbvvyyhihunschxi")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value An AWS Account ID to add create volume permissions. The AWS Account cannot be the snapshot's owner
     */
    @JvmName("fcvqmhsfrbwnnkrc")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value A snapshot ID
     */
    @JvmName("obfagrvfrtycioql")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    internal fun build(): SnapshotCreateVolumePermissionArgs = SnapshotCreateVolumePermissionArgs(
        accountId = accountId,
        snapshotId = snapshotId,
    )
}
