@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SpotDatafeedSubscription].
 */
@PulumiTagMarker
public class SpotDatafeedSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SpotDatafeedSubscriptionArgs = SpotDatafeedSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SpotDatafeedSubscriptionArgsBuilder.() -> Unit) {
        val builder = SpotDatafeedSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SpotDatafeedSubscription {
        val builtJavaResource = com.pulumi.aws.ec2.SpotDatafeedSubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SpotDatafeedSubscription(builtJavaResource)
    }
}

/**
 * > **Note:** There is only a single subscription allowed per account.
 * To help you understand the charges for your Spot instances, Amazon EC2 provides a data feed that describes your Spot instance usage and pricing.
 * This data feed is sent to an Amazon S3 bucket that you specify when you subscribe to the data feed.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.ec2.SpotDatafeedSubscription;
 * import com.pulumi.aws.ec2.SpotDatafeedSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultBucketV2 = new BucketV2("defaultBucketV2");
 *         var defaultSpotDatafeedSubscription = new SpotDatafeedSubscription("defaultSpotDatafeedSubscription", SpotDatafeedSubscriptionArgs.builder()
 *             .bucket(defaultBucketV2.id())
 *             .prefix("my_subdirectory")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a Spot Datafeed Subscription using the word `spot-datafeed-subscription`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/spotDatafeedSubscription:SpotDatafeedSubscription mysubscription spot-datafeed-subscription
 * ```
 *
 */
public class SpotDatafeedSubscription internal constructor(
    override val javaResource: com.pulumi.aws.ec2.SpotDatafeedSubscription,
) : KotlinCustomResource(javaResource, SpotDatafeedSubscriptionMapper) {
    /**
     * The Amazon S3 bucket in which to store the Spot instance data feed.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Path of folder inside bucket to place spot pricing data.
     */
    public val prefix: Output<String>?
        get() = javaResource.prefix().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SpotDatafeedSubscriptionMapper : ResourceMapper<SpotDatafeedSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.SpotDatafeedSubscription::class == javaResource::class

    override fun map(javaResource: Resource): SpotDatafeedSubscription =
        SpotDatafeedSubscription(javaResource as com.pulumi.aws.ec2.SpotDatafeedSubscription)
}

/**
 * @see [SpotDatafeedSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SpotDatafeedSubscription].
 */
public suspend fun spotDatafeedSubscription(
    name: String,
    block: suspend SpotDatafeedSubscriptionResourceBuilder.() -> Unit,
): SpotDatafeedSubscription {
    val builder = SpotDatafeedSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SpotDatafeedSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun spotDatafeedSubscription(name: String): SpotDatafeedSubscription {
    val builder = SpotDatafeedSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
