@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.SpotDatafeedSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * > **Note:** There is only a single subscription allowed per account.
 * To help you understand the charges for your Spot instances, Amazon EC2 provides a data feed that describes your Spot instance usage and pricing.
 * This data feed is sent to an Amazon S3 bucket that you specify when you subscribe to the data feed.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.ec2.SpotDatafeedSubscription;
 * import com.pulumi.aws.ec2.SpotDatafeedSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultBucketV2 = new BucketV2("defaultBucketV2");
 *         var defaultSpotDatafeedSubscription = new SpotDatafeedSubscription("defaultSpotDatafeedSubscription", SpotDatafeedSubscriptionArgs.builder()
 *             .bucket(defaultBucketV2.id())
 *             .prefix("my_subdirectory")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a Spot Datafeed Subscription using the word `spot-datafeed-subscription`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/spotDatafeedSubscription:SpotDatafeedSubscription mysubscription spot-datafeed-subscription
 * ```
 * @property bucket The Amazon S3 bucket in which to store the Spot instance data feed.
 * @property prefix Path of folder inside bucket to place spot pricing data.
 */
public data class SpotDatafeedSubscriptionArgs(
    public val bucket: Output<String>? = null,
    public val prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.SpotDatafeedSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.ec2.SpotDatafeedSubscriptionArgs =
        com.pulumi.aws.ec2.SpotDatafeedSubscriptionArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotDatafeedSubscriptionArgs].
 */
@PulumiTagMarker
public class SpotDatafeedSubscriptionArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value The Amazon S3 bucket in which to store the Spot instance data feed.
     */
    @JvmName("vwlftdhdoesaawus")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Path of folder inside bucket to place spot pricing data.
     */
    @JvmName("trgbsrcjlilawmbc")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The Amazon S3 bucket in which to store the Spot instance data feed.
     */
    @JvmName("gcsicxvlboljnmyb")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Path of folder inside bucket to place spot pricing data.
     */
    @JvmName("uvochnhnkbmtajak")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): SpotDatafeedSubscriptionArgs = SpotDatafeedSubscriptionArgs(
        bucket = bucket,
        prefix = prefix,
    )
}
