@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchSpecification
import com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfig
import com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestSpotMaintenanceStrategies
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchSpecification.Companion.toKotlin as spotFleetRequestLaunchSpecificationToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestLaunchTemplateConfig.Companion.toKotlin as spotFleetRequestLaunchTemplateConfigToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SpotFleetRequestSpotMaintenanceStrategies.Companion.toKotlin as spotFleetRequestSpotMaintenanceStrategiesToKotlin

/**
 * Builder for [SpotFleetRequest].
 */
@PulumiTagMarker
public class SpotFleetRequestResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SpotFleetRequestArgs = SpotFleetRequestArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SpotFleetRequestArgsBuilder.() -> Unit) {
        val builder = SpotFleetRequestArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SpotFleetRequest {
        val builtJavaResource = com.pulumi.aws.ec2.SpotFleetRequest(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SpotFleetRequest(builtJavaResource)
    }
}

/**
 * Provides an EC2 Spot Fleet Request resource. This allows a fleet of Spot
 * instances to be requested on the Spot market.
 * > **NOTE [AWS strongly discourages](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-best-practices.html#which-spot-request-method-to-use) the use of the legacy APIs called by this resource.
 * We recommend using the EC2 Fleet or Auto Scaling Group resources instead.
 * ## Example Usage
 * ### Using launch specifications
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SpotFleetRequest;
 * import com.pulumi.aws.ec2.SpotFleetRequestArgs;
 * import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cheapCompute = new SpotFleetRequest("cheapCompute", SpotFleetRequestArgs.builder()
 *             .iamFleetRole("arn:aws:iam::12345678:role/spot-fleet")
 *             .spotPrice("0.03")
 *             .allocationStrategy("diversified")
 *             .targetCapacity(6)
 *             .validUntil("2019-11-04T20:44:20Z")
 *             .launchSpecifications(
 *                 SpotFleetRequestLaunchSpecificationArgs.builder()
 *                     .instanceType("m4.10xlarge")
 *                     .ami("ami-1234")
 *                     .spotPrice("2.793")
 *                     .placementTenancy("dedicated")
 *                     .iamInstanceProfileArn(aws_iam_instance_profile.example().arn())
 *                     .build(),
 *                 SpotFleetRequestLaunchSpecificationArgs.builder()
 *                     .instanceType("m4.4xlarge")
 *                     .ami("ami-5678")
 *                     .keyName("my-key")
 *                     .spotPrice("1.117")
 *                     .iamInstanceProfileArn(aws_iam_instance_profile.example().arn())
 *                     .availabilityZone("us-west-1a")
 *                     .subnetId("subnet-1234")
 *                     .weightedCapacity(35)
 *                     .rootBlockDevices(SpotFleetRequestLaunchSpecificationRootBlockDeviceArgs.builder()
 *                         .volumeSize("300")
 *                         .volumeType("gp2")
 *                         .build())
 *                     .tags(Map.of("Name", "spot-fleet-example"))
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Using launch templates
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.ec2.SpotFleetRequest;
 * import com.pulumi.aws.ec2.SpotFleetRequestArgs;
 * import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigArgs;
 * import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooLaunchTemplate = new LaunchTemplate("fooLaunchTemplate", LaunchTemplateArgs.builder()
 *             .imageId("ami-516b9131")
 *             .instanceType("m1.small")
 *             .keyName("some-key")
 *             .build());
 *         var fooSpotFleetRequest = new SpotFleetRequest("fooSpotFleetRequest", SpotFleetRequestArgs.builder()
 *             .iamFleetRole("arn:aws:iam::12345678:role/spot-fleet")
 *             .spotPrice("0.005")
 *             .targetCapacity(2)
 *             .validUntil("2019-11-04T20:44:20Z")
 *             .launchTemplateConfigs(SpotFleetRequestLaunchTemplateConfigArgs.builder()
 *                 .launchTemplateSpecification(SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs.builder()
 *                     .id(fooLaunchTemplate.id())
 *                     .version(fooLaunchTemplate.latestVersion())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_policy_attachment.test-attach())
 *                 .build());
 *     }
 * }
 * ```
 * ### Using multiple launch specifications
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SpotFleetRequest;
 * import com.pulumi.aws.ec2.SpotFleetRequestArgs;
 * import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new SpotFleetRequest("foo", SpotFleetRequestArgs.builder()
 *             .iamFleetRole("arn:aws:iam::12345678:role/spot-fleet")
 *             .launchSpecifications(
 *                 SpotFleetRequestLaunchSpecificationArgs.builder()
 *                     .ami("ami-d06a90b0")
 *                     .availabilityZone("us-west-2a")
 *                     .instanceType("m1.small")
 *                     .keyName("my-key")
 *                     .build(),
 *                 SpotFleetRequestLaunchSpecificationArgs.builder()
 *                     .ami("ami-d06a90b0")
 *                     .availabilityZone("us-west-2a")
 *                     .instanceType("m5.large")
 *                     .keyName("my-key")
 *                     .build())
 *             .spotPrice("0.005")
 *             .targetCapacity(2)
 *             .validUntil("2019-11-04T20:44:20Z")
 *             .build());
 *     }
 * }
 * ```
 * ### Using multiple launch configurations
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetSubnetsArgs;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.ec2.SpotFleetRequest;
 * import com.pulumi.aws.ec2.SpotFleetRequestArgs;
 * import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigArgs;
 * import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = Ec2Functions.getSubnets(GetSubnetsArgs.builder()
 *             .filters(GetSubnetsFilterArgs.builder()
 *                 .name("vpc-id")
 *                 .values(var_.vpc_id())
 *                 .build())
 *             .build());
 *         var fooLaunchTemplate = new LaunchTemplate("fooLaunchTemplate", LaunchTemplateArgs.builder()
 *             .imageId("ami-516b9131")
 *             .instanceType("m1.small")
 *             .keyName("some-key")
 *             .build());
 *         var fooSpotFleetRequest = new SpotFleetRequest("fooSpotFleetRequest", SpotFleetRequestArgs.builder()
 *             .iamFleetRole("arn:aws:iam::12345678:role/spot-fleet")
 *             .spotPrice("0.005")
 *             .targetCapacity(2)
 *             .validUntil("2019-11-04T20:44:20Z")
 *             .launchTemplateConfigs(SpotFleetRequestLaunchTemplateConfigArgs.builder()
 *                 .launchTemplateSpecification(SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs.builder()
 *                     .id(fooLaunchTemplate.id())
 *                     .version(fooLaunchTemplate.latestVersion())
 *                     .build())
 *                 .overrides(
 *                     SpotFleetRequestLaunchTemplateConfigOverrideArgs.builder()
 *                         .subnetId(example.applyValue(getSubnetsResult -> getSubnetsResult.ids()[0]))
 *                         .build(),
 *                     SpotFleetRequestLaunchTemplateConfigOverrideArgs.builder()
 *                         .subnetId(example.applyValue(getSubnetsResult -> getSubnetsResult.ids()[1]))
 *                         .build(),
 *                     SpotFleetRequestLaunchTemplateConfigOverrideArgs.builder()
 *                         .subnetId(example.applyValue(getSubnetsResult -> getSubnetsResult.ids()[2]))
 *                         .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_policy_attachment.test-attach())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Spot Fleet Requests using `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/spotFleetRequest:SpotFleetRequest fleet sfr-005e9ec8-5546-4c31-b317-31a62325411e
 * ```
 *
 */
public class SpotFleetRequest internal constructor(
    override val javaResource: com.pulumi.aws.ec2.SpotFleetRequest,
) : KotlinCustomResource(javaResource, SpotFleetRequestMapper) {
    /**
     * Indicates how to allocate the target capacity across
     * the Spot pools specified by the Spot fleet request. Valid values: `lowestPrice`, `diversified`, `capacityOptimized`, `capacityOptimizedPrioritized`, and `priceCapacityOptimized`. The default is
     * `lowestPrice`.
     */
    public val allocationStrategy: Output<String>?
        get() = javaResource.allocationStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val clientToken: Output<String>
        get() = javaResource.clientToken().applyValue({ args0 -> args0 })

    /**
     * Reserved.
     */
    public val context: Output<String>?
        get() = javaResource.context().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether running Spot
     * instances should be terminated if the target capacity of the Spot fleet
     * request is decreased below the current size of the Spot fleet.
     */
    public val excessCapacityTerminationPolicy: Output<String>?
        get() = javaResource.excessCapacityTerminationPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of fleet request. Indicates whether the Spot Fleet only requests the target
     * capacity or also attempts to maintain it. Default is `maintain`.
     */
    public val fleetType: Output<String>?
        get() = javaResource.fleetType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Grants the Spot fleet permission to terminate
     * Spot instances on your behalf when you cancel its Spot fleet request using
     * CancelSpotFleetRequests or when the Spot fleet request expires, if you set
     * terminateInstancesWithExpiration.
     */
    public val iamFleetRole: Output<String>
        get() = javaResource.iamFleetRole().applyValue({ args0 -> args0 })

    /**
     * Indicates whether a Spot
     * instance stops or terminates when it is interrupted. Default is
     * `terminate`.
     */
    public val instanceInterruptionBehaviour: Output<String>?
        get() = javaResource.instanceInterruptionBehaviour().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of Spot pools across which to allocate your target Spot capacity.
     * Valid only when `allocation_strategy` is set to `lowestPrice`. Spot Fleet selects
     * the cheapest Spot pools and evenly allocates your target Spot capacity across
     * the number of Spot pools that you specify.
     */
    public val instancePoolsToUseCount: Output<Int>?
        get() = javaResource.instancePoolsToUseCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Used to define the launch configuration of the
     * spot-fleet request. Can be specified multiple times to define different bids
     * across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.
     * **Note**: This takes in similar but not
     * identical inputs as `aws.ec2.Instance`.  There are limitations on
     * what you can specify. See the list of officially supported inputs in the
     * [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `aws.ec2.Instance` parameter that corresponds to those inputs may be used and it have
     * a additional parameter `iam_instance_profile_arn` takes `aws.iam.InstanceProfile` attribute `arn` as input.
     */
    public val launchSpecifications: Output<List<SpotFleetRequestLaunchSpecification>>?
        get() = javaResource.launchSpecifications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        spotFleetRequestLaunchSpecificationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
     */
    public val launchTemplateConfigs: Output<List<SpotFleetRequestLaunchTemplateConfig>>?
        get() = javaResource.launchTemplateConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        spotFleetRequestLaunchTemplateConfigToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A list of elastic load balancer names to add to the Spot fleet.
     */
    public val loadBalancers: Output<List<String>>
        get() = javaResource.loadBalancers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The order of the launch template overrides to use in fulfilling On-Demand capacity. the possible values are: `lowestPrice` and `prioritized`. the default is `lowestPrice`.
     */
    public val onDemandAllocationStrategy: Output<String>?
        get() = javaResource.onDemandAllocationStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum amount per hour for On-Demand Instances that you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
     */
    public val onDemandMaxTotalPrice: Output<String>?
        get() = javaResource.onDemandMaxTotalPrice().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of On-Demand units to request. If the request type is `maintain`, you can specify a target capacity of 0 and add capacity later.
     */
    public val onDemandTargetCapacity: Output<Int>?
        get() = javaResource.onDemandTargetCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether Spot fleet should replace unhealthy instances. Default `false`.
     */
    public val replaceUnhealthyInstances: Output<Boolean>?
        get() = javaResource.replaceUnhealthyInstances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Nested argument containing maintenance strategies for managing your Spot Instances that are at an elevated risk of being interrupted. Defined below.
     */
    public val spotMaintenanceStrategies: Output<SpotFleetRequestSpotMaintenanceStrategies>?
        get() = javaResource.spotMaintenanceStrategies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    spotFleetRequestSpotMaintenanceStrategiesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The maximum bid price per unit hour.
     */
    public val spotPrice: Output<String>?
        get() = javaResource.spotPrice().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The state of the Spot fleet request.
     */
    public val spotRequestState: Output<String>
        get() = javaResource.spotRequestState().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The number of units to request. You can choose to set the
     * target capacity in terms of instances or a performance characteristic that is
     * important to your application workload, such as vCPUs, memory, or I/O.
     */
    public val targetCapacity: Output<Int>
        get() = javaResource.targetCapacity().applyValue({ args0 -> args0 })

    /**
     * The unit for the target capacity. This can only be done with `instance_requirements` defined
     */
    public val targetCapacityUnitType: Output<String>?
        get() = javaResource.targetCapacityUnitType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of `aws.alb.TargetGroup` ARNs, for use with Application Load Balancing.
     */
    public val targetGroupArns: Output<List<String>>
        get() = javaResource.targetGroupArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Indicates whether running Spot
     * instances should be terminated when the resource is deleted (and the Spot fleet request cancelled).
     * If no value is specified, the value of the `terminate_instances_with_expiration` argument is used.
     */
    public val terminateInstancesOnDelete: Output<String>?
        get() = javaResource.terminateInstancesOnDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether running Spot
     * instances should be terminated when the Spot fleet request expires.
     */
    public val terminateInstancesWithExpiration: Output<Boolean>?
        get() = javaResource.terminateInstancesWithExpiration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     */
    public val validFrom: Output<String>?
        get() = javaResource.validFrom().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request.
     */
    public val validUntil: Output<String>?
        get() = javaResource.validUntil().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If set, this provider will
     * wait for the Spot Request to be fulfilled, and will throw an error if the
     * timeout of 10m is reached.
     */
    public val waitForFulfillment: Output<Boolean>?
        get() = javaResource.waitForFulfillment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object SpotFleetRequestMapper : ResourceMapper<SpotFleetRequest> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.SpotFleetRequest::class == javaResource::class

    override fun map(javaResource: Resource): SpotFleetRequest = SpotFleetRequest(
        javaResource as
            com.pulumi.aws.ec2.SpotFleetRequest,
    )
}

/**
 * @see [SpotFleetRequest].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SpotFleetRequest].
 */
public suspend fun spotFleetRequest(
    name: String,
    block: suspend SpotFleetRequestResourceBuilder.() -> Unit,
): SpotFleetRequest {
    val builder = SpotFleetRequestResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SpotFleetRequest].
 * @param name The _unique_ name of the resulting resource.
 */
public fun spotFleetRequest(name: String): SpotFleetRequest {
    val builder = SpotFleetRequestResourceBuilder()
    builder.name(name)
    return builder.build()
}
