@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.SpotFleetRequestArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.SpotFleetRequestLaunchSpecificationArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotFleetRequestLaunchSpecificationArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SpotFleetRequestLaunchTemplateConfigArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotFleetRequestLaunchTemplateConfigArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SpotFleetRequestSpotMaintenanceStrategiesArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotFleetRequestSpotMaintenanceStrategiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EC2 Spot Fleet Request resource. This allows a fleet of Spot
 * instances to be requested on the Spot market.
 * > **NOTE [AWS strongly discourages](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-best-practices.html#which-spot-request-method-to-use) the use of the legacy APIs called by this resource.
 * We recommend using the EC2 Fleet or Auto Scaling Group resources instead.
 * ## Example Usage
 * ### Using launch specifications
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SpotFleetRequest;
 * import com.pulumi.aws.ec2.SpotFleetRequestArgs;
 * import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cheapCompute = new SpotFleetRequest("cheapCompute", SpotFleetRequestArgs.builder()
 *             .iamFleetRole("arn:aws:iam::12345678:role/spot-fleet")
 *             .spotPrice("0.03")
 *             .allocationStrategy("diversified")
 *             .targetCapacity(6)
 *             .validUntil("2019-11-04T20:44:20Z")
 *             .launchSpecifications(
 *                 SpotFleetRequestLaunchSpecificationArgs.builder()
 *                     .instanceType("m4.10xlarge")
 *                     .ami("ami-1234")
 *                     .spotPrice("2.793")
 *                     .placementTenancy("dedicated")
 *                     .iamInstanceProfileArn(aws_iam_instance_profile.example().arn())
 *                     .build(),
 *                 SpotFleetRequestLaunchSpecificationArgs.builder()
 *                     .instanceType("m4.4xlarge")
 *                     .ami("ami-5678")
 *                     .keyName("my-key")
 *                     .spotPrice("1.117")
 *                     .iamInstanceProfileArn(aws_iam_instance_profile.example().arn())
 *                     .availabilityZone("us-west-1a")
 *                     .subnetId("subnet-1234")
 *                     .weightedCapacity(35)
 *                     .rootBlockDevices(SpotFleetRequestLaunchSpecificationRootBlockDeviceArgs.builder()
 *                         .volumeSize("300")
 *                         .volumeType("gp2")
 *                         .build())
 *                     .tags(Map.of("Name", "spot-fleet-example"))
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Using launch templates
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.ec2.SpotFleetRequest;
 * import com.pulumi.aws.ec2.SpotFleetRequestArgs;
 * import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigArgs;
 * import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooLaunchTemplate = new LaunchTemplate("fooLaunchTemplate", LaunchTemplateArgs.builder()
 *             .imageId("ami-516b9131")
 *             .instanceType("m1.small")
 *             .keyName("some-key")
 *             .build());
 *         var fooSpotFleetRequest = new SpotFleetRequest("fooSpotFleetRequest", SpotFleetRequestArgs.builder()
 *             .iamFleetRole("arn:aws:iam::12345678:role/spot-fleet")
 *             .spotPrice("0.005")
 *             .targetCapacity(2)
 *             .validUntil("2019-11-04T20:44:20Z")
 *             .launchTemplateConfigs(SpotFleetRequestLaunchTemplateConfigArgs.builder()
 *                 .launchTemplateSpecification(SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs.builder()
 *                     .id(fooLaunchTemplate.id())
 *                     .version(fooLaunchTemplate.latestVersion())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_policy_attachment.test-attach())
 *                 .build());
 *     }
 * }
 * ```
 * ### Using multiple launch specifications
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SpotFleetRequest;
 * import com.pulumi.aws.ec2.SpotFleetRequestArgs;
 * import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new SpotFleetRequest("foo", SpotFleetRequestArgs.builder()
 *             .iamFleetRole("arn:aws:iam::12345678:role/spot-fleet")
 *             .launchSpecifications(
 *                 SpotFleetRequestLaunchSpecificationArgs.builder()
 *                     .ami("ami-d06a90b0")
 *                     .availabilityZone("us-west-2a")
 *                     .instanceType("m1.small")
 *                     .keyName("my-key")
 *                     .build(),
 *                 SpotFleetRequestLaunchSpecificationArgs.builder()
 *                     .ami("ami-d06a90b0")
 *                     .availabilityZone("us-west-2a")
 *                     .instanceType("m5.large")
 *                     .keyName("my-key")
 *                     .build())
 *             .spotPrice("0.005")
 *             .targetCapacity(2)
 *             .validUntil("2019-11-04T20:44:20Z")
 *             .build());
 *     }
 * }
 * ```
 * ### Using multiple launch configurations
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetSubnetsArgs;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.ec2.SpotFleetRequest;
 * import com.pulumi.aws.ec2.SpotFleetRequestArgs;
 * import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigArgs;
 * import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = Ec2Functions.getSubnets(GetSubnetsArgs.builder()
 *             .filters(GetSubnetsFilterArgs.builder()
 *                 .name("vpc-id")
 *                 .values(var_.vpc_id())
 *                 .build())
 *             .build());
 *         var fooLaunchTemplate = new LaunchTemplate("fooLaunchTemplate", LaunchTemplateArgs.builder()
 *             .imageId("ami-516b9131")
 *             .instanceType("m1.small")
 *             .keyName("some-key")
 *             .build());
 *         var fooSpotFleetRequest = new SpotFleetRequest("fooSpotFleetRequest", SpotFleetRequestArgs.builder()
 *             .iamFleetRole("arn:aws:iam::12345678:role/spot-fleet")
 *             .spotPrice("0.005")
 *             .targetCapacity(2)
 *             .validUntil("2019-11-04T20:44:20Z")
 *             .launchTemplateConfigs(SpotFleetRequestLaunchTemplateConfigArgs.builder()
 *                 .launchTemplateSpecification(SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs.builder()
 *                     .id(fooLaunchTemplate.id())
 *                     .version(fooLaunchTemplate.latestVersion())
 *                     .build())
 *                 .overrides(
 *                     SpotFleetRequestLaunchTemplateConfigOverrideArgs.builder()
 *                         .subnetId(example.applyValue(getSubnetsResult -> getSubnetsResult.ids()[0]))
 *                         .build(),
 *                     SpotFleetRequestLaunchTemplateConfigOverrideArgs.builder()
 *                         .subnetId(example.applyValue(getSubnetsResult -> getSubnetsResult.ids()[1]))
 *                         .build(),
 *                     SpotFleetRequestLaunchTemplateConfigOverrideArgs.builder()
 *                         .subnetId(example.applyValue(getSubnetsResult -> getSubnetsResult.ids()[2]))
 *                         .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_policy_attachment.test-attach())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Spot Fleet Requests using `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/spotFleetRequest:SpotFleetRequest fleet sfr-005e9ec8-5546-4c31-b317-31a62325411e
 * ```
 * @property allocationStrategy Indicates how to allocate the target capacity across
 * the Spot pools specified by the Spot fleet request. Valid values: `lowestPrice`, `diversified`, `capacityOptimized`, `capacityOptimizedPrioritized`, and `priceCapacityOptimized`. The default is
 * `lowestPrice`.
 * @property context Reserved.
 * @property excessCapacityTerminationPolicy Indicates whether running Spot
 * instances should be terminated if the target capacity of the Spot fleet
 * request is decreased below the current size of the Spot fleet.
 * @property fleetType The type of fleet request. Indicates whether the Spot Fleet only requests the target
 * capacity or also attempts to maintain it. Default is `maintain`.
 * @property iamFleetRole Grants the Spot fleet permission to terminate
 * Spot instances on your behalf when you cancel its Spot fleet request using
 * CancelSpotFleetRequests or when the Spot fleet request expires, if you set
 * terminateInstancesWithExpiration.
 * @property instanceInterruptionBehaviour Indicates whether a Spot
 * instance stops or terminates when it is interrupted. Default is
 * `terminate`.
 * @property instancePoolsToUseCount The number of Spot pools across which to allocate your target Spot capacity.
 * Valid only when `allocation_strategy` is set to `lowestPrice`. Spot Fleet selects
 * the cheapest Spot pools and evenly allocates your target Spot capacity across
 * the number of Spot pools that you specify.
 * @property launchSpecifications Used to define the launch configuration of the
 * spot-fleet request. Can be specified multiple times to define different bids
 * across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.
 * **Note**: This takes in similar but not
 * identical inputs as `aws.ec2.Instance`.  There are limitations on
 * what you can specify. See the list of officially supported inputs in the
 * [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `aws.ec2.Instance` parameter that corresponds to those inputs may be used and it have
 * a additional parameter `iam_instance_profile_arn` takes `aws.iam.InstanceProfile` attribute `arn` as input.
 * @property launchTemplateConfigs Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
 * @property loadBalancers A list of elastic load balancer names to add to the Spot fleet.
 * @property onDemandAllocationStrategy The order of the launch template overrides to use in fulfilling On-Demand capacity. the possible values are: `lowestPrice` and `prioritized`. the default is `lowestPrice`.
 * @property onDemandMaxTotalPrice The maximum amount per hour for On-Demand Instances that you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
 * @property onDemandTargetCapacity The number of On-Demand units to request. If the request type is `maintain`, you can specify a target capacity of 0 and add capacity later.
 * @property replaceUnhealthyInstances Indicates whether Spot fleet should replace unhealthy instances. Default `false`.
 * @property spotMaintenanceStrategies Nested argument containing maintenance strategies for managing your Spot Instances that are at an elevated risk of being interrupted. Defined below.
 * @property spotPrice The maximum bid price per unit hour.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetCapacity The number of units to request. You can choose to set the
 * target capacity in terms of instances or a performance characteristic that is
 * important to your application workload, such as vCPUs, memory, or I/O.
 * @property targetCapacityUnitType The unit for the target capacity. This can only be done with `instance_requirements` defined
 * @property targetGroupArns A list of `aws.alb.TargetGroup` ARNs, for use with Application Load Balancing.
 * @property terminateInstancesOnDelete Indicates whether running Spot
 * instances should be terminated when the resource is deleted (and the Spot fleet request cancelled).
 * If no value is specified, the value of the `terminate_instances_with_expiration` argument is used.
 * @property terminateInstancesWithExpiration Indicates whether running Spot
 * instances should be terminated when the Spot fleet request expires.
 * @property validFrom The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
 * @property validUntil The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request.
 * @property waitForFulfillment If set, this provider will
 * wait for the Spot Request to be fulfilled, and will throw an error if the
 * timeout of 10m is reached.
 */
public data class SpotFleetRequestArgs(
    public val allocationStrategy: Output<String>? = null,
    public val context: Output<String>? = null,
    public val excessCapacityTerminationPolicy: Output<String>? = null,
    public val fleetType: Output<String>? = null,
    public val iamFleetRole: Output<String>? = null,
    public val instanceInterruptionBehaviour: Output<String>? = null,
    public val instancePoolsToUseCount: Output<Int>? = null,
    public val launchSpecifications: Output<List<SpotFleetRequestLaunchSpecificationArgs>>? = null,
    public val launchTemplateConfigs: Output<List<SpotFleetRequestLaunchTemplateConfigArgs>>? = null,
    public val loadBalancers: Output<List<String>>? = null,
    public val onDemandAllocationStrategy: Output<String>? = null,
    public val onDemandMaxTotalPrice: Output<String>? = null,
    public val onDemandTargetCapacity: Output<Int>? = null,
    public val replaceUnhealthyInstances: Output<Boolean>? = null,
    public val spotMaintenanceStrategies: Output<SpotFleetRequestSpotMaintenanceStrategiesArgs>? =
        null,
    public val spotPrice: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetCapacity: Output<Int>? = null,
    public val targetCapacityUnitType: Output<String>? = null,
    public val targetGroupArns: Output<List<String>>? = null,
    public val terminateInstancesOnDelete: Output<String>? = null,
    public val terminateInstancesWithExpiration: Output<Boolean>? = null,
    public val validFrom: Output<String>? = null,
    public val validUntil: Output<String>? = null,
    public val waitForFulfillment: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.SpotFleetRequestArgs> {
    override fun toJava(): com.pulumi.aws.ec2.SpotFleetRequestArgs =
        com.pulumi.aws.ec2.SpotFleetRequestArgs.builder()
            .allocationStrategy(allocationStrategy?.applyValue({ args0 -> args0 }))
            .context(context?.applyValue({ args0 -> args0 }))
            .excessCapacityTerminationPolicy(excessCapacityTerminationPolicy?.applyValue({ args0 -> args0 }))
            .fleetType(fleetType?.applyValue({ args0 -> args0 }))
            .iamFleetRole(iamFleetRole?.applyValue({ args0 -> args0 }))
            .instanceInterruptionBehaviour(instanceInterruptionBehaviour?.applyValue({ args0 -> args0 }))
            .instancePoolsToUseCount(instancePoolsToUseCount?.applyValue({ args0 -> args0 }))
            .launchSpecifications(
                launchSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .launchTemplateConfigs(
                launchTemplateConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .loadBalancers(loadBalancers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .onDemandAllocationStrategy(onDemandAllocationStrategy?.applyValue({ args0 -> args0 }))
            .onDemandMaxTotalPrice(onDemandMaxTotalPrice?.applyValue({ args0 -> args0 }))
            .onDemandTargetCapacity(onDemandTargetCapacity?.applyValue({ args0 -> args0 }))
            .replaceUnhealthyInstances(replaceUnhealthyInstances?.applyValue({ args0 -> args0 }))
            .spotMaintenanceStrategies(
                spotMaintenanceStrategies?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .spotPrice(spotPrice?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetCapacity(targetCapacity?.applyValue({ args0 -> args0 }))
            .targetCapacityUnitType(targetCapacityUnitType?.applyValue({ args0 -> args0 }))
            .targetGroupArns(targetGroupArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .terminateInstancesOnDelete(terminateInstancesOnDelete?.applyValue({ args0 -> args0 }))
            .terminateInstancesWithExpiration(terminateInstancesWithExpiration?.applyValue({ args0 -> args0 }))
            .validFrom(validFrom?.applyValue({ args0 -> args0 }))
            .validUntil(validUntil?.applyValue({ args0 -> args0 }))
            .waitForFulfillment(waitForFulfillment?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotFleetRequestArgs].
 */
@PulumiTagMarker
public class SpotFleetRequestArgsBuilder internal constructor() {
    private var allocationStrategy: Output<String>? = null

    private var context: Output<String>? = null

    private var excessCapacityTerminationPolicy: Output<String>? = null

    private var fleetType: Output<String>? = null

    private var iamFleetRole: Output<String>? = null

    private var instanceInterruptionBehaviour: Output<String>? = null

    private var instancePoolsToUseCount: Output<Int>? = null

    private var launchSpecifications: Output<List<SpotFleetRequestLaunchSpecificationArgs>>? = null

    private var launchTemplateConfigs: Output<List<SpotFleetRequestLaunchTemplateConfigArgs>>? = null

    private var loadBalancers: Output<List<String>>? = null

    private var onDemandAllocationStrategy: Output<String>? = null

    private var onDemandMaxTotalPrice: Output<String>? = null

    private var onDemandTargetCapacity: Output<Int>? = null

    private var replaceUnhealthyInstances: Output<Boolean>? = null

    private var spotMaintenanceStrategies: Output<SpotFleetRequestSpotMaintenanceStrategiesArgs>? =
        null

    private var spotPrice: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetCapacity: Output<Int>? = null

    private var targetCapacityUnitType: Output<String>? = null

    private var targetGroupArns: Output<List<String>>? = null

    private var terminateInstancesOnDelete: Output<String>? = null

    private var terminateInstancesWithExpiration: Output<Boolean>? = null

    private var validFrom: Output<String>? = null

    private var validUntil: Output<String>? = null

    private var waitForFulfillment: Output<Boolean>? = null

    /**
     * @param value Indicates how to allocate the target capacity across
     * the Spot pools specified by the Spot fleet request. Valid values: `lowestPrice`, `diversified`, `capacityOptimized`, `capacityOptimizedPrioritized`, and `priceCapacityOptimized`. The default is
     * `lowestPrice`.
     */
    @JvmName("xelbeaokqqdyldbq")
    public suspend fun allocationStrategy(`value`: Output<String>) {
        this.allocationStrategy = value
    }

    /**
     * @param value Reserved.
     */
    @JvmName("ipmvvrwxniygjksj")
    public suspend fun context(`value`: Output<String>) {
        this.context = value
    }

    /**
     * @param value Indicates whether running Spot
     * instances should be terminated if the target capacity of the Spot fleet
     * request is decreased below the current size of the Spot fleet.
     */
    @JvmName("yphduwdffldbmkcj")
    public suspend fun excessCapacityTerminationPolicy(`value`: Output<String>) {
        this.excessCapacityTerminationPolicy = value
    }

    /**
     * @param value The type of fleet request. Indicates whether the Spot Fleet only requests the target
     * capacity or also attempts to maintain it. Default is `maintain`.
     */
    @JvmName("xukkieywwxejvxdb")
    public suspend fun fleetType(`value`: Output<String>) {
        this.fleetType = value
    }

    /**
     * @param value Grants the Spot fleet permission to terminate
     * Spot instances on your behalf when you cancel its Spot fleet request using
     * CancelSpotFleetRequests or when the Spot fleet request expires, if you set
     * terminateInstancesWithExpiration.
     */
    @JvmName("fjgkernnmaocaopt")
    public suspend fun iamFleetRole(`value`: Output<String>) {
        this.iamFleetRole = value
    }

    /**
     * @param value Indicates whether a Spot
     * instance stops or terminates when it is interrupted. Default is
     * `terminate`.
     */
    @JvmName("jlkipnshnoavrrvu")
    public suspend fun instanceInterruptionBehaviour(`value`: Output<String>) {
        this.instanceInterruptionBehaviour = value
    }

    /**
     * @param value The number of Spot pools across which to allocate your target Spot capacity.
     * Valid only when `allocation_strategy` is set to `lowestPrice`. Spot Fleet selects
     * the cheapest Spot pools and evenly allocates your target Spot capacity across
     * the number of Spot pools that you specify.
     */
    @JvmName("ecrcnuvweptrakev")
    public suspend fun instancePoolsToUseCount(`value`: Output<Int>) {
        this.instancePoolsToUseCount = value
    }

    /**
     * @param value Used to define the launch configuration of the
     * spot-fleet request. Can be specified multiple times to define different bids
     * across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.
     * **Note**: This takes in similar but not
     * identical inputs as `aws.ec2.Instance`.  There are limitations on
     * what you can specify. See the list of officially supported inputs in the
     * [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `aws.ec2.Instance` parameter that corresponds to those inputs may be used and it have
     * a additional parameter `iam_instance_profile_arn` takes `aws.iam.InstanceProfile` attribute `arn` as input.
     */
    @JvmName("pimagiaafnwjnqkb")
    public suspend
    fun launchSpecifications(`value`: Output<List<SpotFleetRequestLaunchSpecificationArgs>>) {
        this.launchSpecifications = value
    }

    @JvmName("minhhxounvifhnhd")
    public suspend fun launchSpecifications(
        vararg
        values: Output<SpotFleetRequestLaunchSpecificationArgs>,
    ) {
        this.launchSpecifications = Output.all(values.asList())
    }

    /**
     * @param values Used to define the launch configuration of the
     * spot-fleet request. Can be specified multiple times to define different bids
     * across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.
     * **Note**: This takes in similar but not
     * identical inputs as `aws.ec2.Instance`.  There are limitations on
     * what you can specify. See the list of officially supported inputs in the
     * [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `aws.ec2.Instance` parameter that corresponds to those inputs may be used and it have
     * a additional parameter `iam_instance_profile_arn` takes `aws.iam.InstanceProfile` attribute `arn` as input.
     */
    @JvmName("lylxaasvumpxkopt")
    public suspend
    fun launchSpecifications(values: List<Output<SpotFleetRequestLaunchSpecificationArgs>>) {
        this.launchSpecifications = Output.all(values)
    }

    /**
     * @param value Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
     */
    @JvmName("afivaaoyiwmymlvp")
    public suspend
    fun launchTemplateConfigs(`value`: Output<List<SpotFleetRequestLaunchTemplateConfigArgs>>) {
        this.launchTemplateConfigs = value
    }

    @JvmName("dtqlnllwsrdnqsbm")
    public suspend fun launchTemplateConfigs(
        vararg
        values: Output<SpotFleetRequestLaunchTemplateConfigArgs>,
    ) {
        this.launchTemplateConfigs = Output.all(values.asList())
    }

    /**
     * @param values Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
     */
    @JvmName("anyygfuqgppxrxbg")
    public suspend
    fun launchTemplateConfigs(values: List<Output<SpotFleetRequestLaunchTemplateConfigArgs>>) {
        this.launchTemplateConfigs = Output.all(values)
    }

    /**
     * @param value A list of elastic load balancer names to add to the Spot fleet.
     */
    @JvmName("pxexhhdljgfejnlc")
    public suspend fun loadBalancers(`value`: Output<List<String>>) {
        this.loadBalancers = value
    }

    @JvmName("fcyjxflxuexknvni")
    public suspend fun loadBalancers(vararg values: Output<String>) {
        this.loadBalancers = Output.all(values.asList())
    }

    /**
     * @param values A list of elastic load balancer names to add to the Spot fleet.
     */
    @JvmName("ntqqkytbtnghovfn")
    public suspend fun loadBalancers(values: List<Output<String>>) {
        this.loadBalancers = Output.all(values)
    }

    /**
     * @param value The order of the launch template overrides to use in fulfilling On-Demand capacity. the possible values are: `lowestPrice` and `prioritized`. the default is `lowestPrice`.
     */
    @JvmName("ooohrcijsblppnws")
    public suspend fun onDemandAllocationStrategy(`value`: Output<String>) {
        this.onDemandAllocationStrategy = value
    }

    /**
     * @param value The maximum amount per hour for On-Demand Instances that you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
     */
    @JvmName("ekxmdhbuxlmmpnhi")
    public suspend fun onDemandMaxTotalPrice(`value`: Output<String>) {
        this.onDemandMaxTotalPrice = value
    }

    /**
     * @param value The number of On-Demand units to request. If the request type is `maintain`, you can specify a target capacity of 0 and add capacity later.
     */
    @JvmName("amdwvxfdnbxdahaq")
    public suspend fun onDemandTargetCapacity(`value`: Output<Int>) {
        this.onDemandTargetCapacity = value
    }

    /**
     * @param value Indicates whether Spot fleet should replace unhealthy instances. Default `false`.
     */
    @JvmName("jphiwammevhudtwy")
    public suspend fun replaceUnhealthyInstances(`value`: Output<Boolean>) {
        this.replaceUnhealthyInstances = value
    }

    /**
     * @param value Nested argument containing maintenance strategies for managing your Spot Instances that are at an elevated risk of being interrupted. Defined below.
     */
    @JvmName("plbetobmnjkpbfmp")
    public suspend
    fun spotMaintenanceStrategies(`value`: Output<SpotFleetRequestSpotMaintenanceStrategiesArgs>) {
        this.spotMaintenanceStrategies = value
    }

    /**
     * @param value The maximum bid price per unit hour.
     */
    @JvmName("hccdkdklxlmdqhfj")
    public suspend fun spotPrice(`value`: Output<String>) {
        this.spotPrice = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("srgmdajsnaapjwwg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The number of units to request. You can choose to set the
     * target capacity in terms of instances or a performance characteristic that is
     * important to your application workload, such as vCPUs, memory, or I/O.
     */
    @JvmName("xxiexjoncahfqdal")
    public suspend fun targetCapacity(`value`: Output<Int>) {
        this.targetCapacity = value
    }

    /**
     * @param value The unit for the target capacity. This can only be done with `instance_requirements` defined
     */
    @JvmName("uvtuvxvvwueliwtv")
    public suspend fun targetCapacityUnitType(`value`: Output<String>) {
        this.targetCapacityUnitType = value
    }

    /**
     * @param value A list of `aws.alb.TargetGroup` ARNs, for use with Application Load Balancing.
     */
    @JvmName("wiomerhotemfeomr")
    public suspend fun targetGroupArns(`value`: Output<List<String>>) {
        this.targetGroupArns = value
    }

    @JvmName("apcvvwcdmtdhkvmr")
    public suspend fun targetGroupArns(vararg values: Output<String>) {
        this.targetGroupArns = Output.all(values.asList())
    }

    /**
     * @param values A list of `aws.alb.TargetGroup` ARNs, for use with Application Load Balancing.
     */
    @JvmName("kojbddcljsjknrsr")
    public suspend fun targetGroupArns(values: List<Output<String>>) {
        this.targetGroupArns = Output.all(values)
    }

    /**
     * @param value Indicates whether running Spot
     * instances should be terminated when the resource is deleted (and the Spot fleet request cancelled).
     * If no value is specified, the value of the `terminate_instances_with_expiration` argument is used.
     */
    @JvmName("htputvsyxljclwvk")
    public suspend fun terminateInstancesOnDelete(`value`: Output<String>) {
        this.terminateInstancesOnDelete = value
    }

    /**
     * @param value Indicates whether running Spot
     * instances should be terminated when the Spot fleet request expires.
     */
    @JvmName("ggavidpqyyrruwdq")
    public suspend fun terminateInstancesWithExpiration(`value`: Output<Boolean>) {
        this.terminateInstancesWithExpiration = value
    }

    /**
     * @param value The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     */
    @JvmName("pixtuhvqnvtcxaly")
    public suspend fun validFrom(`value`: Output<String>) {
        this.validFrom = value
    }

    /**
     * @param value The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request.
     */
    @JvmName("vqidqplkwagumjew")
    public suspend fun validUntil(`value`: Output<String>) {
        this.validUntil = value
    }

    /**
     * @param value If set, this provider will
     * wait for the Spot Request to be fulfilled, and will throw an error if the
     * timeout of 10m is reached.
     */
    @JvmName("gyhmxwyvixionryd")
    public suspend fun waitForFulfillment(`value`: Output<Boolean>) {
        this.waitForFulfillment = value
    }

    /**
     * @param value Indicates how to allocate the target capacity across
     * the Spot pools specified by the Spot fleet request. Valid values: `lowestPrice`, `diversified`, `capacityOptimized`, `capacityOptimizedPrioritized`, and `priceCapacityOptimized`. The default is
     * `lowestPrice`.
     */
    @JvmName("bnukcqriphufoglf")
    public suspend fun allocationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    /**
     * @param value Reserved.
     */
    @JvmName("cavncceegdsawyka")
    public suspend fun context(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.context = mapped
    }

    /**
     * @param value Indicates whether running Spot
     * instances should be terminated if the target capacity of the Spot fleet
     * request is decreased below the current size of the Spot fleet.
     */
    @JvmName("xpyrrxfbmqitysdf")
    public suspend fun excessCapacityTerminationPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excessCapacityTerminationPolicy = mapped
    }

    /**
     * @param value The type of fleet request. Indicates whether the Spot Fleet only requests the target
     * capacity or also attempts to maintain it. Default is `maintain`.
     */
    @JvmName("gmugtdednpealoun")
    public suspend fun fleetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetType = mapped
    }

    /**
     * @param value Grants the Spot fleet permission to terminate
     * Spot instances on your behalf when you cancel its Spot fleet request using
     * CancelSpotFleetRequests or when the Spot fleet request expires, if you set
     * terminateInstancesWithExpiration.
     */
    @JvmName("bmbrlgivhhgnlrsw")
    public suspend fun iamFleetRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamFleetRole = mapped
    }

    /**
     * @param value Indicates whether a Spot
     * instance stops or terminates when it is interrupted. Default is
     * `terminate`.
     */
    @JvmName("bgwcyvxcbjxcjguw")
    public suspend fun instanceInterruptionBehaviour(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceInterruptionBehaviour = mapped
    }

    /**
     * @param value The number of Spot pools across which to allocate your target Spot capacity.
     * Valid only when `allocation_strategy` is set to `lowestPrice`. Spot Fleet selects
     * the cheapest Spot pools and evenly allocates your target Spot capacity across
     * the number of Spot pools that you specify.
     */
    @JvmName("tfeukjqovpcowaus")
    public suspend fun instancePoolsToUseCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instancePoolsToUseCount = mapped
    }

    /**
     * @param value Used to define the launch configuration of the
     * spot-fleet request. Can be specified multiple times to define different bids
     * across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.
     * **Note**: This takes in similar but not
     * identical inputs as `aws.ec2.Instance`.  There are limitations on
     * what you can specify. See the list of officially supported inputs in the
     * [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `aws.ec2.Instance` parameter that corresponds to those inputs may be used and it have
     * a additional parameter `iam_instance_profile_arn` takes `aws.iam.InstanceProfile` attribute `arn` as input.
     */
    @JvmName("slnprvofwptejuqo")
    public suspend fun launchSpecifications(`value`: List<SpotFleetRequestLaunchSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchSpecifications = mapped
    }

    /**
     * @param argument Used to define the launch configuration of the
     * spot-fleet request. Can be specified multiple times to define different bids
     * across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.
     * **Note**: This takes in similar but not
     * identical inputs as `aws.ec2.Instance`.  There are limitations on
     * what you can specify. See the list of officially supported inputs in the
     * [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `aws.ec2.Instance` parameter that corresponds to those inputs may be used and it have
     * a additional parameter `iam_instance_profile_arn` takes `aws.iam.InstanceProfile` attribute `arn` as input.
     */
    @JvmName("rdumxrdgvvafydow")
    public suspend
    fun launchSpecifications(argument: List<suspend SpotFleetRequestLaunchSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpotFleetRequestLaunchSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.launchSpecifications = mapped
    }

    /**
     * @param argument Used to define the launch configuration of the
     * spot-fleet request. Can be specified multiple times to define different bids
     * across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.
     * **Note**: This takes in similar but not
     * identical inputs as `aws.ec2.Instance`.  There are limitations on
     * what you can specify. See the list of officially supported inputs in the
     * [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `aws.ec2.Instance` parameter that corresponds to those inputs may be used and it have
     * a additional parameter `iam_instance_profile_arn` takes `aws.iam.InstanceProfile` attribute `arn` as input.
     */
    @JvmName("nstnoboiyvqdnwyt")
    public suspend fun launchSpecifications(
        vararg
        argument: suspend SpotFleetRequestLaunchSpecificationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SpotFleetRequestLaunchSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.launchSpecifications = mapped
    }

    /**
     * @param argument Used to define the launch configuration of the
     * spot-fleet request. Can be specified multiple times to define different bids
     * across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.
     * **Note**: This takes in similar but not
     * identical inputs as `aws.ec2.Instance`.  There are limitations on
     * what you can specify. See the list of officially supported inputs in the
     * [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `aws.ec2.Instance` parameter that corresponds to those inputs may be used and it have
     * a additional parameter `iam_instance_profile_arn` takes `aws.iam.InstanceProfile` attribute `arn` as input.
     */
    @JvmName("brjjrydgpcwbtsrj")
    public suspend
    fun launchSpecifications(argument: suspend SpotFleetRequestLaunchSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SpotFleetRequestLaunchSpecificationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.launchSpecifications = mapped
    }

    /**
     * @param values Used to define the launch configuration of the
     * spot-fleet request. Can be specified multiple times to define different bids
     * across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.
     * **Note**: This takes in similar but not
     * identical inputs as `aws.ec2.Instance`.  There are limitations on
     * what you can specify. See the list of officially supported inputs in the
     * [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `aws.ec2.Instance` parameter that corresponds to those inputs may be used and it have
     * a additional parameter `iam_instance_profile_arn` takes `aws.iam.InstanceProfile` attribute `arn` as input.
     */
    @JvmName("kliqjqxqpubfkdak")
    public suspend fun launchSpecifications(vararg values: SpotFleetRequestLaunchSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.launchSpecifications = mapped
    }

    /**
     * @param value Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
     */
    @JvmName("moexvwctrmhpnpqv")
    public suspend
    fun launchTemplateConfigs(`value`: List<SpotFleetRequestLaunchTemplateConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param argument Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
     */
    @JvmName("kvcyahlxmqpqpbgt")
    public suspend
    fun launchTemplateConfigs(argument: List<suspend SpotFleetRequestLaunchTemplateConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpotFleetRequestLaunchTemplateConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param argument Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
     */
    @JvmName("lsjsxbmsuqqkhdup")
    public suspend fun launchTemplateConfigs(
        vararg
        argument: suspend SpotFleetRequestLaunchTemplateConfigArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SpotFleetRequestLaunchTemplateConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param argument Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
     */
    @JvmName("ktlfbsmjuomedoff")
    public suspend
    fun launchTemplateConfigs(argument: suspend SpotFleetRequestLaunchTemplateConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SpotFleetRequestLaunchTemplateConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param values Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
     */
    @JvmName("ocxmsvboeioboaye")
    public suspend fun launchTemplateConfigs(
        vararg
        values: SpotFleetRequestLaunchTemplateConfigArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param value A list of elastic load balancer names to add to the Spot fleet.
     */
    @JvmName("jthgntqnibucoicp")
    public suspend fun loadBalancers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancers = mapped
    }

    /**
     * @param values A list of elastic load balancer names to add to the Spot fleet.
     */
    @JvmName("boqbjhodfyirvqlp")
    public suspend fun loadBalancers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancers = mapped
    }

    /**
     * @param value The order of the launch template overrides to use in fulfilling On-Demand capacity. the possible values are: `lowestPrice` and `prioritized`. the default is `lowestPrice`.
     */
    @JvmName("jblxfggbwonpaqed")
    public suspend fun onDemandAllocationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandAllocationStrategy = mapped
    }

    /**
     * @param value The maximum amount per hour for On-Demand Instances that you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
     */
    @JvmName("ffhvufdwodvompro")
    public suspend fun onDemandMaxTotalPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandMaxTotalPrice = mapped
    }

    /**
     * @param value The number of On-Demand units to request. If the request type is `maintain`, you can specify a target capacity of 0 and add capacity later.
     */
    @JvmName("mprtteffywttygus")
    public suspend fun onDemandTargetCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandTargetCapacity = mapped
    }

    /**
     * @param value Indicates whether Spot fleet should replace unhealthy instances. Default `false`.
     */
    @JvmName("nyodfhbnsdlwsaaq")
    public suspend fun replaceUnhealthyInstances(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replaceUnhealthyInstances = mapped
    }

    /**
     * @param value Nested argument containing maintenance strategies for managing your Spot Instances that are at an elevated risk of being interrupted. Defined below.
     */
    @JvmName("ruubdpckkmqcnldw")
    public suspend
    fun spotMaintenanceStrategies(`value`: SpotFleetRequestSpotMaintenanceStrategiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotMaintenanceStrategies = mapped
    }

    /**
     * @param argument Nested argument containing maintenance strategies for managing your Spot Instances that are at an elevated risk of being interrupted. Defined below.
     */
    @JvmName("cdaberttwgajfrbg")
    public suspend
    fun spotMaintenanceStrategies(argument: suspend SpotFleetRequestSpotMaintenanceStrategiesArgsBuilder.() -> Unit) {
        val toBeMapped = SpotFleetRequestSpotMaintenanceStrategiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.spotMaintenanceStrategies = mapped
    }

    /**
     * @param value The maximum bid price per unit hour.
     */
    @JvmName("srloqptaojgfuqpr")
    public suspend fun spotPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPrice = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("axgphadhulueehdq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fqrjjhhbclrcciir")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The number of units to request. You can choose to set the
     * target capacity in terms of instances or a performance characteristic that is
     * important to your application workload, such as vCPUs, memory, or I/O.
     */
    @JvmName("ldpddkhhdhmfttic")
    public suspend fun targetCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetCapacity = mapped
    }

    /**
     * @param value The unit for the target capacity. This can only be done with `instance_requirements` defined
     */
    @JvmName("knuuyfxymqnsoyyd")
    public suspend fun targetCapacityUnitType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetCapacityUnitType = mapped
    }

    /**
     * @param value A list of `aws.alb.TargetGroup` ARNs, for use with Application Load Balancing.
     */
    @JvmName("tvuxwsnhkbmpyxcj")
    public suspend fun targetGroupArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupArns = mapped
    }

    /**
     * @param values A list of `aws.alb.TargetGroup` ARNs, for use with Application Load Balancing.
     */
    @JvmName("ligjbsdmfmoecwjl")
    public suspend fun targetGroupArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroupArns = mapped
    }

    /**
     * @param value Indicates whether running Spot
     * instances should be terminated when the resource is deleted (and the Spot fleet request cancelled).
     * If no value is specified, the value of the `terminate_instances_with_expiration` argument is used.
     */
    @JvmName("tqfychunndofcshv")
    public suspend fun terminateInstancesOnDelete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminateInstancesOnDelete = mapped
    }

    /**
     * @param value Indicates whether running Spot
     * instances should be terminated when the Spot fleet request expires.
     */
    @JvmName("immcslxfwcnjyyye")
    public suspend fun terminateInstancesWithExpiration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminateInstancesWithExpiration = mapped
    }

    /**
     * @param value The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     */
    @JvmName("vetwaggbcocchhlu")
    public suspend fun validFrom(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validFrom = mapped
    }

    /**
     * @param value The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request.
     */
    @JvmName("bxtgrjvkqmiixish")
    public suspend fun validUntil(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validUntil = mapped
    }

    /**
     * @param value If set, this provider will
     * wait for the Spot Request to be fulfilled, and will throw an error if the
     * timeout of 10m is reached.
     */
    @JvmName("btnltkrphcruhgbg")
    public suspend fun waitForFulfillment(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForFulfillment = mapped
    }

    internal fun build(): SpotFleetRequestArgs = SpotFleetRequestArgs(
        allocationStrategy = allocationStrategy,
        context = context,
        excessCapacityTerminationPolicy = excessCapacityTerminationPolicy,
        fleetType = fleetType,
        iamFleetRole = iamFleetRole,
        instanceInterruptionBehaviour = instanceInterruptionBehaviour,
        instancePoolsToUseCount = instancePoolsToUseCount,
        launchSpecifications = launchSpecifications,
        launchTemplateConfigs = launchTemplateConfigs,
        loadBalancers = loadBalancers,
        onDemandAllocationStrategy = onDemandAllocationStrategy,
        onDemandMaxTotalPrice = onDemandMaxTotalPrice,
        onDemandTargetCapacity = onDemandTargetCapacity,
        replaceUnhealthyInstances = replaceUnhealthyInstances,
        spotMaintenanceStrategies = spotMaintenanceStrategies,
        spotPrice = spotPrice,
        tags = tags,
        targetCapacity = targetCapacity,
        targetCapacityUnitType = targetCapacityUnitType,
        targetGroupArns = targetGroupArns,
        terminateInstancesOnDelete = terminateInstancesOnDelete,
        terminateInstancesWithExpiration = terminateInstancesWithExpiration,
        validFrom = validFrom,
        validUntil = validUntil,
        waitForFulfillment = waitForFulfillment,
    )
}
