@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestCapacityReservationSpecification
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestCpuOptions
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestCreditSpecification
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestEbsBlockDevice
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestEnclaveOptions
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestEphemeralBlockDevice
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestLaunchTemplate
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestMaintenanceOptions
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestMetadataOptions
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestNetworkInterface
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestPrivateDnsNameOptions
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestRootBlockDevice
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestCapacityReservationSpecification.Companion.toKotlin as spotInstanceRequestCapacityReservationSpecificationToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestCpuOptions.Companion.toKotlin as spotInstanceRequestCpuOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestCreditSpecification.Companion.toKotlin as spotInstanceRequestCreditSpecificationToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestEbsBlockDevice.Companion.toKotlin as spotInstanceRequestEbsBlockDeviceToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestEnclaveOptions.Companion.toKotlin as spotInstanceRequestEnclaveOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestEphemeralBlockDevice.Companion.toKotlin as spotInstanceRequestEphemeralBlockDeviceToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestLaunchTemplate.Companion.toKotlin as spotInstanceRequestLaunchTemplateToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestMaintenanceOptions.Companion.toKotlin as spotInstanceRequestMaintenanceOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestMetadataOptions.Companion.toKotlin as spotInstanceRequestMetadataOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestNetworkInterface.Companion.toKotlin as spotInstanceRequestNetworkInterfaceToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestPrivateDnsNameOptions.Companion.toKotlin as spotInstanceRequestPrivateDnsNameOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.SpotInstanceRequestRootBlockDevice.Companion.toKotlin as spotInstanceRequestRootBlockDeviceToKotlin

/**
 * Builder for [SpotInstanceRequest].
 */
@PulumiTagMarker
public class SpotInstanceRequestResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SpotInstanceRequestArgs = SpotInstanceRequestArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SpotInstanceRequestArgsBuilder.() -> Unit) {
        val builder = SpotInstanceRequestArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SpotInstanceRequest {
        val builtJavaResource = com.pulumi.aws.ec2.SpotInstanceRequest(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SpotInstanceRequest(builtJavaResource)
    }
}

/**
 * Provides an EC2 Spot Instance Request resource. This allows instances to be
 * requested on the spot market.
 * By default this provider creates Spot Instance Requests with a `persistent` type,
 * which means that for the duration of their lifetime, AWS will launch an
 * instance with the configured details if and when the spot market will accept
 * the requested price.
 * On destruction, this provider will make an attempt to terminate the associated Spot
 * Instance if there is one present.
 * Spot Instances requests with a `one-time` type will close the spot request
 * when the instance is terminated either by the request being below the current spot
 * price availability or by a user.
 * > **NOTE:** Because their behavior depends on the live status of the spot
 * market, Spot Instance Requests have a unique lifecycle that makes them behave
 * differently than other resources. Most importantly: there is __no
 * guarantee__ that a Spot Instance exists to fulfill the request at any given
 * point in time. See the [AWS Spot Instance
 * documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances.html)
 * for more information.
 * > **NOTE [AWS strongly discourages](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-best-practices.html#which-spot-request-method-to-use) the use of the legacy APIs called by this resource.
 * We recommend using the EC2 Instance resource with `instance_market_options` instead.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SpotInstanceRequest;
 * import com.pulumi.aws.ec2.SpotInstanceRequestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cheapWorker = new SpotInstanceRequest("cheapWorker", SpotInstanceRequestArgs.builder()
 *             .ami("ami-1234")
 *             .instanceType("c4.xlarge")
 *             .spotPrice("0.03")
 *             .tags(Map.of("Name", "CheapWorker"))
 *             .build());
 *     }
 * }
 * ```
 */
public class SpotInstanceRequest internal constructor(
    override val javaResource: com.pulumi.aws.ec2.SpotInstanceRequest,
) : KotlinCustomResource(javaResource, SpotInstanceRequestMapper) {
    /**
     * AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
     */
    public val ami: Output<String>
        get() = javaResource.ami().applyValue({ args0 -> args0 })

    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether to associate a public IP address with an instance in a VPC.
     */
    public val associatePublicIpAddress: Output<Boolean>
        get() = javaResource.associatePublicIpAddress().applyValue({ args0 -> args0 })

    /**
     * AZ to start the instance in.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The required duration for the Spot instances, in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).
     * The duration period starts as soon as your Spot instance receives its instance ID. At the end of the duration period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
     * Note that you can't specify an Availability Zone group or a launch group if you specify a duration.
     */
    public val blockDurationMinutes: Output<Int>?
        get() = javaResource.blockDurationMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * > **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     */
    public val capacityReservationSpecification:
        Output<SpotInstanceRequestCapacityReservationSpecification>
        get() = javaResource.capacityReservationSpecification().applyValue({ args0 ->
            args0.let({ args0 ->
                spotInstanceRequestCapacityReservationSpecificationToKotlin(args0)
            })
        })

    /**
     * Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     */
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    public val cpuCoreCount: Output<Int>
        get() = javaResource.cpuCoreCount().applyValue({ args0 -> args0 })

    /**
     * The CPU options for the instance. See CPU Options below for more details.
     */
    public val cpuOptions: Output<SpotInstanceRequestCpuOptions>
        get() = javaResource.cpuOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                spotInstanceRequestCpuOptionsToKotlin(args0)
            })
        })

    /**
     * If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     */
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    public val cpuThreadsPerCore: Output<Int>
        get() = javaResource.cpuThreadsPerCore().applyValue({ args0 -> args0 })

    /**
     * Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     */
    public val creditSpecification: Output<SpotInstanceRequestCreditSpecification>?
        get() = javaResource.creditSpecification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> spotInstanceRequestCreditSpecificationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     */
    public val disableApiStop: Output<Boolean>
        get() = javaResource.disableApiStop().applyValue({ args0 -> args0 })

    /**
     * If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
     */
    public val disableApiTermination: Output<Boolean>
        get() = javaResource.disableApiTermination().applyValue({ args0 -> args0 })

    /**
     * One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    public val ebsBlockDevices: Output<List<SpotInstanceRequestEbsBlockDevice>>
        get() = javaResource.ebsBlockDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> spotInstanceRequestEbsBlockDeviceToKotlin(args0) })
            })
        })

    /**
     * If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
     */
    public val ebsOptimized: Output<Boolean>
        get() = javaResource.ebsOptimized().applyValue({ args0 -> args0 })

    /**
     * Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     */
    public val enclaveOptions: Output<SpotInstanceRequestEnclaveOptions>
        get() = javaResource.enclaveOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                spotInstanceRequestEnclaveOptionsToKotlin(args0)
            })
        })

    /**
     * One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    public val ephemeralBlockDevices: Output<List<SpotInstanceRequestEphemeralBlockDevice>>
        get() = javaResource.ephemeralBlockDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> spotInstanceRequestEphemeralBlockDeviceToKotlin(args0) })
            })
        })

    /**
     * If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     */
    public val getPasswordData: Output<Boolean>?
        get() = javaResource.getPasswordData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If true, the launched EC2 instance will support hibernation.
     */
    public val hibernation: Output<Boolean>?
        get() = javaResource.hibernation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
     */
    public val hostId: Output<String>
        get() = javaResource.hostId().applyValue({ args0 -> args0 })

    /**
     * ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
     */
    public val hostResourceGroupArn: Output<String>
        get() = javaResource.hostResourceGroupArn().applyValue({ args0 -> args0 })

    /**
     * IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
     */
    public val iamInstanceProfile: Output<String>
        get() = javaResource.iamInstanceProfile().applyValue({ args0 -> args0 })

    /**
     * Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
     */
    public val instanceInitiatedShutdownBehavior: Output<String>
        get() = javaResource.instanceInitiatedShutdownBehavior().applyValue({ args0 -> args0 })

    /**
     * Indicates Spot instance behavior when it is interrupted. Valid values are `terminate`, `stop`, or `hibernate`. Default value is `terminate`.
     */
    public val instanceInterruptionBehavior: Output<String>?
        get() = javaResource.instanceInterruptionBehavior().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val instanceState: Output<String>
        get() = javaResource.instanceState().applyValue({ args0 -> args0 })

    /**
     * Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
     */
    public val ipv6AddressCount: Output<Int>
        get() = javaResource.ipv6AddressCount().applyValue({ args0 -> args0 })

    /**
     * Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     */
    public val ipv6Addresses: Output<List<String>>
        get() = javaResource.ipv6Addresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
     */
    public val keyName: Output<String>
        get() = javaResource.keyName().applyValue({ args0 -> args0 })

    /**
     * A launch group is a group of spot instances that launch together and terminate together.
     * If left empty instances are launched and terminated individually.
     */
    public val launchGroup: Output<String>?
        get() = javaResource.launchGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     */
    public val launchTemplate: Output<SpotInstanceRequestLaunchTemplate>?
        get() = javaResource.launchTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> spotInstanceRequestLaunchTemplateToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     */
    public val maintenanceOptions: Output<SpotInstanceRequestMaintenanceOptions>
        get() = javaResource.maintenanceOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                spotInstanceRequestMaintenanceOptionsToKotlin(args0)
            })
        })

    /**
     * Customize the metadata options of the instance. See Metadata Options below for more details.
     */
    public val metadataOptions: Output<SpotInstanceRequestMetadataOptions>
        get() = javaResource.metadataOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                spotInstanceRequestMetadataOptionsToKotlin(args0)
            })
        })

    /**
     * If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
     */
    public val monitoring: Output<Boolean>
        get() = javaResource.monitoring().applyValue({ args0 -> args0 })

    /**
     * Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    public val networkInterfaces: Output<List<SpotInstanceRequestNetworkInterface>>
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> spotInstanceRequestNetworkInterfaceToKotlin(args0) })
            })
        })

    public val outpostArn: Output<String>
        get() = javaResource.outpostArn().applyValue({ args0 -> args0 })

    public val passwordData: Output<String>
        get() = javaResource.passwordData().applyValue({ args0 -> args0 })

    /**
     * Placement Group to start the instance in.
     */
    public val placementGroup: Output<String>
        get() = javaResource.placementGroup().applyValue({ args0 -> args0 })

    /**
     * Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
     */
    public val placementPartitionNumber: Output<Int>
        get() = javaResource.placementPartitionNumber().applyValue({ args0 -> args0 })

    public val primaryNetworkInterfaceId: Output<String>
        get() = javaResource.primaryNetworkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The private DNS name assigned to the instance. Can only be
     * used inside the Amazon EC2, and only available if you've enabled DNS hostnames
     * for your VPC
     */
    public val privateDns: Output<String>
        get() = javaResource.privateDns().applyValue({ args0 -> args0 })

    /**
     * Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     */
    public val privateDnsNameOptions: Output<SpotInstanceRequestPrivateDnsNameOptions>
        get() = javaResource.privateDnsNameOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                spotInstanceRequestPrivateDnsNameOptionsToKotlin(args0)
            })
        })

    /**
     * Private IP address to associate with the instance in a VPC.
     */
    public val privateIp: Output<String>
        get() = javaResource.privateIp().applyValue({ args0 -> args0 })

    /**
     * The public DNS name assigned to the instance. For EC2-VPC, this
     * is only available if you've enabled DNS hostnames for your VPC
     */
    public val publicDns: Output<String>
        get() = javaResource.publicDns().applyValue({ args0 -> args0 })

    /**
     * The public IP address assigned to the instance, if applicable.
     */
    public val publicIp: Output<String>
        get() = javaResource.publicIp().applyValue({ args0 -> args0 })

    /**
     * Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     */
    public val rootBlockDevice: Output<SpotInstanceRequestRootBlockDevice>
        get() = javaResource.rootBlockDevice().applyValue({ args0 ->
            args0.let({ args0 ->
                spotInstanceRequestRootBlockDeviceToKotlin(args0)
            })
        })

    /**
     * List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     */
    public val secondaryPrivateIps: Output<List<String>>
        get() = javaResource.secondaryPrivateIps().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of security group names to associate with.
     * > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     */
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
     */
    public val sourceDestCheck: Output<Boolean>?
        get() = javaResource.sourceDestCheck().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The current [bid
   * status](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
     * of the Spot Instance Request.
     */
    public val spotBidStatus: Output<String>
        get() = javaResource.spotBidStatus().applyValue({ args0 -> args0 })

    /**
     * The Instance ID (if any) that is currently fulfilling
     * the Spot Instance request.
     */
    public val spotInstanceId: Output<String>
        get() = javaResource.spotInstanceId().applyValue({ args0 -> args0 })

    /**
     * The maximum price to request on the spot market.
     */
    public val spotPrice: Output<String>
        get() = javaResource.spotPrice().applyValue({ args0 -> args0 })

    /**
     * The current [request
   * state](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#creating-spot-request-status)
     * of the Spot Instance Request.
     */
    public val spotRequestState: Output<String>
        get() = javaResource.spotRequestState().applyValue({ args0 -> args0 })

    /**
     * If set to `one-time`, after
     * the instance is terminated, the spot request will be closed.
     */
    public val spotType: Output<String>?
        get() = javaResource.spotType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * VPC Subnet ID to launch in.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     */
    public val tenancy: Output<String>
        get() = javaResource.tenancy().applyValue({ args0 -> args0 })

    /**
     * User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     */
    public val userData: Output<String>
        get() = javaResource.userData().applyValue({ args0 -> args0 })

    /**
     * Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     */
    public val userDataBase64: Output<String>
        get() = javaResource.userDataBase64().applyValue({ args0 -> args0 })

    /**
     * When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
     */
    public val userDataReplaceOnChange: Output<Boolean>?
        get() = javaResource.userDataReplaceOnChange().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     */
    public val validFrom: Output<String>
        get() = javaResource.validFrom().applyValue({ args0 -> args0 })

    /**
     * The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request. The default end date is 7 days from the current date.
     */
    public val validUntil: Output<String>
        get() = javaResource.validUntil().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     */
    public val volumeTags: Output<Map<String, String>>?
        get() = javaResource.volumeTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * List of security group IDs to associate with.
     */
    public val vpcSecurityGroupIds: Output<List<String>>
        get() = javaResource.vpcSecurityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * If set, this provider will
     * wait for the Spot Request to be fulfilled, and will throw an error if the
     * timeout of 10m is reached.
     */
    public val waitForFulfillment: Output<Boolean>?
        get() = javaResource.waitForFulfillment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object SpotInstanceRequestMapper : ResourceMapper<SpotInstanceRequest> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.SpotInstanceRequest::class == javaResource::class

    override fun map(javaResource: Resource): SpotInstanceRequest = SpotInstanceRequest(
        javaResource
            as com.pulumi.aws.ec2.SpotInstanceRequest,
    )
}

/**
 * @see [SpotInstanceRequest].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SpotInstanceRequest].
 */
public suspend fun spotInstanceRequest(
    name: String,
    block: suspend SpotInstanceRequestResourceBuilder.() -> Unit,
): SpotInstanceRequest {
    val builder = SpotInstanceRequestResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SpotInstanceRequest].
 * @param name The _unique_ name of the resulting resource.
 */
public fun spotInstanceRequest(name: String): SpotInstanceRequest {
    val builder = SpotInstanceRequestResourceBuilder()
    builder.name(name)
    return builder.build()
}
