@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.SpotInstanceRequestArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestCapacityReservationSpecificationArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestCapacityReservationSpecificationArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestCpuOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestCpuOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestCreditSpecificationArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestCreditSpecificationArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestEbsBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestEbsBlockDeviceArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestEnclaveOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestEnclaveOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestEphemeralBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestEphemeralBlockDeviceArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestLaunchTemplateArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestLaunchTemplateArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestMaintenanceOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestMaintenanceOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestMetadataOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestMetadataOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestNetworkInterfaceArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestNetworkInterfaceArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestPrivateDnsNameOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestPrivateDnsNameOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestRootBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.SpotInstanceRequestRootBlockDeviceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EC2 Spot Instance Request resource. This allows instances to be
 * requested on the spot market.
 * By default this provider creates Spot Instance Requests with a `persistent` type,
 * which means that for the duration of their lifetime, AWS will launch an
 * instance with the configured details if and when the spot market will accept
 * the requested price.
 * On destruction, this provider will make an attempt to terminate the associated Spot
 * Instance if there is one present.
 * Spot Instances requests with a `one-time` type will close the spot request
 * when the instance is terminated either by the request being below the current spot
 * price availability or by a user.
 * > **NOTE:** Because their behavior depends on the live status of the spot
 * market, Spot Instance Requests have a unique lifecycle that makes them behave
 * differently than other resources. Most importantly: there is __no
 * guarantee__ that a Spot Instance exists to fulfill the request at any given
 * point in time. See the [AWS Spot Instance
 * documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances.html)
 * for more information.
 * > **NOTE [AWS strongly discourages](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-best-practices.html#which-spot-request-method-to-use) the use of the legacy APIs called by this resource.
 * We recommend using the EC2 Instance resource with `instance_market_options` instead.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SpotInstanceRequest;
 * import com.pulumi.aws.ec2.SpotInstanceRequestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cheapWorker = new SpotInstanceRequest("cheapWorker", SpotInstanceRequestArgs.builder()
 *             .ami("ami-1234")
 *             .instanceType("c4.xlarge")
 *             .spotPrice("0.03")
 *             .tags(Map.of("Name", "CheapWorker"))
 *             .build());
 *     }
 * }
 * ```
 * @property ami AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
 * @property associatePublicIpAddress Whether to associate a public IP address with an instance in a VPC.
 * @property availabilityZone AZ to start the instance in.
 * @property blockDurationMinutes The required duration for the Spot instances, in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).
 * The duration period starts as soon as your Spot instance receives its instance ID. At the end of the duration period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
 * Note that you can't specify an Availability Zone group or a launch group if you specify a duration.
 * @property capacityReservationSpecification Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
 * > **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
 * @property cpuCoreCount Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
 * @property cpuOptions The CPU options for the instance. See CPU Options below for more details.
 * @property cpuThreadsPerCore If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
 * @property creditSpecification Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
 * @property disableApiStop If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
 * @property disableApiTermination If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
 * @property ebsBlockDevices One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
 * @property ebsOptimized If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
 * @property enclaveOptions Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
 * @property ephemeralBlockDevices One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
 * @property getPasswordData If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
 * @property hibernation If true, the launched EC2 instance will support hibernation.
 * @property hostId ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
 * @property hostResourceGroupArn ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
 * @property iamInstanceProfile IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
 * @property instanceInitiatedShutdownBehavior Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
 * @property instanceInterruptionBehavior Indicates Spot instance behavior when it is interrupted. Valid values are `terminate`, `stop`, or `hibernate`. Default value is `terminate`.
 * @property instanceType Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
 * @property ipv6AddressCount Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
 * @property ipv6Addresses Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
 * @property keyName Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
 * @property launchGroup A launch group is a group of spot instances that launch together and terminate together.
 * If left empty instances are launched and terminated individually.
 * @property launchTemplate Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
 * @property maintenanceOptions Maintenance and recovery options for the instance. See Maintenance Options below for more details.
 * @property metadataOptions Customize the metadata options of the instance. See Metadata Options below for more details.
 * @property monitoring If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
 * @property networkInterfaces Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
 * @property placementGroup Placement Group to start the instance in.
 * @property placementPartitionNumber Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
 * @property privateDnsNameOptions Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
 * @property privateIp Private IP address to associate with the instance in a VPC.
 * @property rootBlockDevice Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
 * @property secondaryPrivateIps List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
 * @property securityGroups List of security group names to associate with.
 * > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
 * @property sourceDestCheck Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
 * @property spotPrice The maximum price to request on the spot market.
 * @property spotType If set to `one-time`, after
 * the instance is terminated, the spot request will be closed.
 * @property subnetId VPC Subnet ID to launch in.
 * @property tags Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tenancy Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
 * @property userData User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
 * @property userDataBase64 Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
 * @property userDataReplaceOnChange When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
 * @property validFrom The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
 * @property validUntil The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request. The default end date is 7 days from the current date.
 * @property volumeTags Map of tags to assign, at instance-creation time, to root and EBS volumes.
 * > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
 * @property vpcSecurityGroupIds List of security group IDs to associate with.
 * @property waitForFulfillment If set, this provider will
 * wait for the Spot Request to be fulfilled, and will throw an error if the
 * timeout of 10m is reached.
 */
public data class SpotInstanceRequestArgs(
    public val ami: Output<String>? = null,
    public val associatePublicIpAddress: Output<Boolean>? = null,
    public val availabilityZone: Output<String>? = null,
    public val blockDurationMinutes: Output<Int>? = null,
    public val capacityReservationSpecification:
    Output<SpotInstanceRequestCapacityReservationSpecificationArgs>? = null,
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    public val cpuCoreCount: Output<Int>? = null,
    public val cpuOptions: Output<SpotInstanceRequestCpuOptionsArgs>? = null,
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    public val cpuThreadsPerCore: Output<Int>? = null,
    public val creditSpecification: Output<SpotInstanceRequestCreditSpecificationArgs>? = null,
    public val disableApiStop: Output<Boolean>? = null,
    public val disableApiTermination: Output<Boolean>? = null,
    public val ebsBlockDevices: Output<List<SpotInstanceRequestEbsBlockDeviceArgs>>? = null,
    public val ebsOptimized: Output<Boolean>? = null,
    public val enclaveOptions: Output<SpotInstanceRequestEnclaveOptionsArgs>? = null,
    public val ephemeralBlockDevices: Output<List<SpotInstanceRequestEphemeralBlockDeviceArgs>>? =
        null,
    public val getPasswordData: Output<Boolean>? = null,
    public val hibernation: Output<Boolean>? = null,
    public val hostId: Output<String>? = null,
    public val hostResourceGroupArn: Output<String>? = null,
    public val iamInstanceProfile: Output<String>? = null,
    public val instanceInitiatedShutdownBehavior: Output<String>? = null,
    public val instanceInterruptionBehavior: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val ipv6AddressCount: Output<Int>? = null,
    public val ipv6Addresses: Output<List<String>>? = null,
    public val keyName: Output<String>? = null,
    public val launchGroup: Output<String>? = null,
    public val launchTemplate: Output<SpotInstanceRequestLaunchTemplateArgs>? = null,
    public val maintenanceOptions: Output<SpotInstanceRequestMaintenanceOptionsArgs>? = null,
    public val metadataOptions: Output<SpotInstanceRequestMetadataOptionsArgs>? = null,
    public val monitoring: Output<Boolean>? = null,
    public val networkInterfaces: Output<List<SpotInstanceRequestNetworkInterfaceArgs>>? = null,
    public val placementGroup: Output<String>? = null,
    public val placementPartitionNumber: Output<Int>? = null,
    public val privateDnsNameOptions: Output<SpotInstanceRequestPrivateDnsNameOptionsArgs>? = null,
    public val privateIp: Output<String>? = null,
    public val rootBlockDevice: Output<SpotInstanceRequestRootBlockDeviceArgs>? = null,
    public val secondaryPrivateIps: Output<List<String>>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val sourceDestCheck: Output<Boolean>? = null,
    public val spotPrice: Output<String>? = null,
    public val spotType: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tenancy: Output<String>? = null,
    public val userData: Output<String>? = null,
    public val userDataBase64: Output<String>? = null,
    public val userDataReplaceOnChange: Output<Boolean>? = null,
    public val validFrom: Output<String>? = null,
    public val validUntil: Output<String>? = null,
    public val volumeTags: Output<Map<String, String>>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
    public val waitForFulfillment: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.SpotInstanceRequestArgs> {
    override fun toJava(): com.pulumi.aws.ec2.SpotInstanceRequestArgs =
        com.pulumi.aws.ec2.SpotInstanceRequestArgs.builder()
            .ami(ami?.applyValue({ args0 -> args0 }))
            .associatePublicIpAddress(associatePublicIpAddress?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .blockDurationMinutes(blockDurationMinutes?.applyValue({ args0 -> args0 }))
            .capacityReservationSpecification(
                capacityReservationSpecification?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .cpuCoreCount(cpuCoreCount?.applyValue({ args0 -> args0 }))
            .cpuOptions(cpuOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cpuThreadsPerCore(cpuThreadsPerCore?.applyValue({ args0 -> args0 }))
            .creditSpecification(
                creditSpecification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .disableApiStop(disableApiStop?.applyValue({ args0 -> args0 }))
            .disableApiTermination(disableApiTermination?.applyValue({ args0 -> args0 }))
            .ebsBlockDevices(
                ebsBlockDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ebsOptimized(ebsOptimized?.applyValue({ args0 -> args0 }))
            .enclaveOptions(enclaveOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ephemeralBlockDevices(
                ephemeralBlockDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .getPasswordData(getPasswordData?.applyValue({ args0 -> args0 }))
            .hibernation(hibernation?.applyValue({ args0 -> args0 }))
            .hostId(hostId?.applyValue({ args0 -> args0 }))
            .hostResourceGroupArn(hostResourceGroupArn?.applyValue({ args0 -> args0 }))
            .iamInstanceProfile(iamInstanceProfile?.applyValue({ args0 -> args0 }))
            .instanceInitiatedShutdownBehavior(
                instanceInitiatedShutdownBehavior?.applyValue({ args0 ->
                    args0
                }),
            )
            .instanceInterruptionBehavior(instanceInterruptionBehavior?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .ipv6AddressCount(ipv6AddressCount?.applyValue({ args0 -> args0 }))
            .ipv6Addresses(ipv6Addresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .launchGroup(launchGroup?.applyValue({ args0 -> args0 }))
            .launchTemplate(launchTemplate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maintenanceOptions(
                maintenanceOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .metadataOptions(metadataOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .monitoring(monitoring?.applyValue({ args0 -> args0 }))
            .networkInterfaces(
                networkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .placementGroup(placementGroup?.applyValue({ args0 -> args0 }))
            .placementPartitionNumber(placementPartitionNumber?.applyValue({ args0 -> args0 }))
            .privateDnsNameOptions(
                privateDnsNameOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .privateIp(privateIp?.applyValue({ args0 -> args0 }))
            .rootBlockDevice(rootBlockDevice?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secondaryPrivateIps(secondaryPrivateIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceDestCheck(sourceDestCheck?.applyValue({ args0 -> args0 }))
            .spotPrice(spotPrice?.applyValue({ args0 -> args0 }))
            .spotType(spotType?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tenancy(tenancy?.applyValue({ args0 -> args0 }))
            .userData(userData?.applyValue({ args0 -> args0 }))
            .userDataBase64(userDataBase64?.applyValue({ args0 -> args0 }))
            .userDataReplaceOnChange(userDataReplaceOnChange?.applyValue({ args0 -> args0 }))
            .validFrom(validFrom?.applyValue({ args0 -> args0 }))
            .validUntil(validUntil?.applyValue({ args0 -> args0 }))
            .volumeTags(
                volumeTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .vpcSecurityGroupIds(vpcSecurityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .waitForFulfillment(waitForFulfillment?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotInstanceRequestArgs].
 */
@PulumiTagMarker
public class SpotInstanceRequestArgsBuilder internal constructor() {
    private var ami: Output<String>? = null

    private var associatePublicIpAddress: Output<Boolean>? = null

    private var availabilityZone: Output<String>? = null

    private var blockDurationMinutes: Output<Int>? = null

    private var capacityReservationSpecification:
        Output<SpotInstanceRequestCapacityReservationSpecificationArgs>? = null

    private var cpuCoreCount: Output<Int>? = null

    private var cpuOptions: Output<SpotInstanceRequestCpuOptionsArgs>? = null

    private var cpuThreadsPerCore: Output<Int>? = null

    private var creditSpecification: Output<SpotInstanceRequestCreditSpecificationArgs>? = null

    private var disableApiStop: Output<Boolean>? = null

    private var disableApiTermination: Output<Boolean>? = null

    private var ebsBlockDevices: Output<List<SpotInstanceRequestEbsBlockDeviceArgs>>? = null

    private var ebsOptimized: Output<Boolean>? = null

    private var enclaveOptions: Output<SpotInstanceRequestEnclaveOptionsArgs>? = null

    private var ephemeralBlockDevices: Output<List<SpotInstanceRequestEphemeralBlockDeviceArgs>>? =
        null

    private var getPasswordData: Output<Boolean>? = null

    private var hibernation: Output<Boolean>? = null

    private var hostId: Output<String>? = null

    private var hostResourceGroupArn: Output<String>? = null

    private var iamInstanceProfile: Output<String>? = null

    private var instanceInitiatedShutdownBehavior: Output<String>? = null

    private var instanceInterruptionBehavior: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var ipv6AddressCount: Output<Int>? = null

    private var ipv6Addresses: Output<List<String>>? = null

    private var keyName: Output<String>? = null

    private var launchGroup: Output<String>? = null

    private var launchTemplate: Output<SpotInstanceRequestLaunchTemplateArgs>? = null

    private var maintenanceOptions: Output<SpotInstanceRequestMaintenanceOptionsArgs>? = null

    private var metadataOptions: Output<SpotInstanceRequestMetadataOptionsArgs>? = null

    private var monitoring: Output<Boolean>? = null

    private var networkInterfaces: Output<List<SpotInstanceRequestNetworkInterfaceArgs>>? = null

    private var placementGroup: Output<String>? = null

    private var placementPartitionNumber: Output<Int>? = null

    private var privateDnsNameOptions: Output<SpotInstanceRequestPrivateDnsNameOptionsArgs>? = null

    private var privateIp: Output<String>? = null

    private var rootBlockDevice: Output<SpotInstanceRequestRootBlockDeviceArgs>? = null

    private var secondaryPrivateIps: Output<List<String>>? = null

    private var securityGroups: Output<List<String>>? = null

    private var sourceDestCheck: Output<Boolean>? = null

    private var spotPrice: Output<String>? = null

    private var spotType: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tenancy: Output<String>? = null

    private var userData: Output<String>? = null

    private var userDataBase64: Output<String>? = null

    private var userDataReplaceOnChange: Output<Boolean>? = null

    private var validFrom: Output<String>? = null

    private var validUntil: Output<String>? = null

    private var volumeTags: Output<Map<String, String>>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    private var waitForFulfillment: Output<Boolean>? = null

    /**
     * @param value AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
     */
    @JvmName("thqddpqoiwxytvqt")
    public suspend fun ami(`value`: Output<String>) {
        this.ami = value
    }

    /**
     * @param value Whether to associate a public IP address with an instance in a VPC.
     */
    @JvmName("ykwmdpgxajviqfoh")
    public suspend fun associatePublicIpAddress(`value`: Output<Boolean>) {
        this.associatePublicIpAddress = value
    }

    /**
     * @param value AZ to start the instance in.
     */
    @JvmName("vphrlhdbvkmmanlq")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The required duration for the Spot instances, in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).
     * The duration period starts as soon as your Spot instance receives its instance ID. At the end of the duration period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
     * Note that you can't specify an Availability Zone group or a launch group if you specify a duration.
     */
    @JvmName("byvbmmeuneqjyrsv")
    public suspend fun blockDurationMinutes(`value`: Output<Int>) {
        this.blockDurationMinutes = value
    }

    /**
     * @param value Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * > **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     */
    @JvmName("aawcgpjmxouwjkse")
    public suspend
    fun capacityReservationSpecification(`value`: Output<SpotInstanceRequestCapacityReservationSpecificationArgs>) {
        this.capacityReservationSpecification = value
    }

    /**
     * @param value Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     */
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    @JvmName("ilnulkvgujmxsbwv")
    public suspend fun cpuCoreCount(`value`: Output<Int>) {
        this.cpuCoreCount = value
    }

    /**
     * @param value The CPU options for the instance. See CPU Options below for more details.
     */
    @JvmName("sdrcwtsvbjbrkwcb")
    public suspend fun cpuOptions(`value`: Output<SpotInstanceRequestCpuOptionsArgs>) {
        this.cpuOptions = value
    }

    /**
     * @param value If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     */
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    @JvmName("hujrjhitkaexaxtf")
    public suspend fun cpuThreadsPerCore(`value`: Output<Int>) {
        this.cpuThreadsPerCore = value
    }

    /**
     * @param value Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     */
    @JvmName("lwosgowbgjkmvqhn")
    public suspend
    fun creditSpecification(`value`: Output<SpotInstanceRequestCreditSpecificationArgs>) {
        this.creditSpecification = value
    }

    /**
     * @param value If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     */
    @JvmName("qpaajpdexeafarty")
    public suspend fun disableApiStop(`value`: Output<Boolean>) {
        this.disableApiStop = value
    }

    /**
     * @param value If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
     */
    @JvmName("noehsullvisjnyhk")
    public suspend fun disableApiTermination(`value`: Output<Boolean>) {
        this.disableApiTermination = value
    }

    /**
     * @param value One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("glmfrnqybidamixn")
    public suspend fun ebsBlockDevices(`value`: Output<List<SpotInstanceRequestEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = value
    }

    @JvmName("rxkkqghrctwpuufr")
    public suspend fun ebsBlockDevices(vararg values: Output<SpotInstanceRequestEbsBlockDeviceArgs>) {
        this.ebsBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("lwwsornrfvhowaxy")
    public suspend fun ebsBlockDevices(values: List<Output<SpotInstanceRequestEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = Output.all(values)
    }

    /**
     * @param value If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
     */
    @JvmName("tgoaooqamealluya")
    public suspend fun ebsOptimized(`value`: Output<Boolean>) {
        this.ebsOptimized = value
    }

    /**
     * @param value Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     */
    @JvmName("krdocpwmgckjxqat")
    public suspend fun enclaveOptions(`value`: Output<SpotInstanceRequestEnclaveOptionsArgs>) {
        this.enclaveOptions = value
    }

    /**
     * @param value One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("dqygbcrfaasmymsc")
    public suspend
    fun ephemeralBlockDevices(`value`: Output<List<SpotInstanceRequestEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = value
    }

    @JvmName("nulfpwtequuokhdg")
    public suspend fun ephemeralBlockDevices(
        vararg
        values: Output<SpotInstanceRequestEphemeralBlockDeviceArgs>,
    ) {
        this.ephemeralBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("snomxonmxjyqfygl")
    public suspend
    fun ephemeralBlockDevices(values: List<Output<SpotInstanceRequestEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = Output.all(values)
    }

    /**
     * @param value If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     */
    @JvmName("fgxolcrkqmgqcahp")
    public suspend fun getPasswordData(`value`: Output<Boolean>) {
        this.getPasswordData = value
    }

    /**
     * @param value If true, the launched EC2 instance will support hibernation.
     */
    @JvmName("pnyakapsfscqyrgw")
    public suspend fun hibernation(`value`: Output<Boolean>) {
        this.hibernation = value
    }

    /**
     * @param value ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
     */
    @JvmName("aejejxbpokasirfj")
    public suspend fun hostId(`value`: Output<String>) {
        this.hostId = value
    }

    /**
     * @param value ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
     */
    @JvmName("lqbqkdmjhkhwddci")
    public suspend fun hostResourceGroupArn(`value`: Output<String>) {
        this.hostResourceGroupArn = value
    }

    /**
     * @param value IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
     */
    @JvmName("kftbvpbrajuwusbc")
    public suspend fun iamInstanceProfile(`value`: Output<String>) {
        this.iamInstanceProfile = value
    }

    /**
     * @param value Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
     */
    @JvmName("febagwhymyojtjqa")
    public suspend fun instanceInitiatedShutdownBehavior(`value`: Output<String>) {
        this.instanceInitiatedShutdownBehavior = value
    }

    /**
     * @param value Indicates Spot instance behavior when it is interrupted. Valid values are `terminate`, `stop`, or `hibernate`. Default value is `terminate`.
     */
    @JvmName("jdfuwyrnpcwdowrt")
    public suspend fun instanceInterruptionBehavior(`value`: Output<String>) {
        this.instanceInterruptionBehavior = value
    }

    /**
     * @param value Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     */
    @JvmName("kebhudjfnxcofvsu")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
     */
    @JvmName("looqmjexoutjqbpt")
    public suspend fun ipv6AddressCount(`value`: Output<Int>) {
        this.ipv6AddressCount = value
    }

    /**
     * @param value Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     */
    @JvmName("nvlvykvpwghhtnvn")
    public suspend fun ipv6Addresses(`value`: Output<List<String>>) {
        this.ipv6Addresses = value
    }

    @JvmName("vahuamiynmrfjluu")
    public suspend fun ipv6Addresses(vararg values: Output<String>) {
        this.ipv6Addresses = Output.all(values.asList())
    }

    /**
     * @param values Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     */
    @JvmName("yicpbgulyfghiuri")
    public suspend fun ipv6Addresses(values: List<Output<String>>) {
        this.ipv6Addresses = Output.all(values)
    }

    /**
     * @param value Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
     */
    @JvmName("tbxyrpnocpdmjkkk")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value A launch group is a group of spot instances that launch together and terminate together.
     * If left empty instances are launched and terminated individually.
     */
    @JvmName("ivnbyssfeanpaoej")
    public suspend fun launchGroup(`value`: Output<String>) {
        this.launchGroup = value
    }

    /**
     * @param value Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     */
    @JvmName("qcimglmwuaivjarb")
    public suspend fun launchTemplate(`value`: Output<SpotInstanceRequestLaunchTemplateArgs>) {
        this.launchTemplate = value
    }

    /**
     * @param value Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     */
    @JvmName("flgflaucfmypoqox")
    public suspend
    fun maintenanceOptions(`value`: Output<SpotInstanceRequestMaintenanceOptionsArgs>) {
        this.maintenanceOptions = value
    }

    /**
     * @param value Customize the metadata options of the instance. See Metadata Options below for more details.
     */
    @JvmName("viatsubqrhutamrt")
    public suspend fun metadataOptions(`value`: Output<SpotInstanceRequestMetadataOptionsArgs>) {
        this.metadataOptions = value
    }

    /**
     * @param value If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
     */
    @JvmName("pggfuipeprovbfqk")
    public suspend fun monitoring(`value`: Output<Boolean>) {
        this.monitoring = value
    }

    /**
     * @param value Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("yxgtitibrslvanft")
    public suspend
    fun networkInterfaces(`value`: Output<List<SpotInstanceRequestNetworkInterfaceArgs>>) {
        this.networkInterfaces = value
    }

    @JvmName("jixwfvcllkixvkyy")
    public suspend fun networkInterfaces(
        vararg
        values: Output<SpotInstanceRequestNetworkInterfaceArgs>,
    ) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("bxyaoknsfveqikyq")
    public suspend
    fun networkInterfaces(values: List<Output<SpotInstanceRequestNetworkInterfaceArgs>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value Placement Group to start the instance in.
     */
    @JvmName("rxeewmdsdwvdnxie")
    public suspend fun placementGroup(`value`: Output<String>) {
        this.placementGroup = value
    }

    /**
     * @param value Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
     */
    @JvmName("eyhxluwqgdvdjdnh")
    public suspend fun placementPartitionNumber(`value`: Output<Int>) {
        this.placementPartitionNumber = value
    }

    /**
     * @param value Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     */
    @JvmName("psounhexstwrgqkg")
    public suspend
    fun privateDnsNameOptions(`value`: Output<SpotInstanceRequestPrivateDnsNameOptionsArgs>) {
        this.privateDnsNameOptions = value
    }

    /**
     * @param value Private IP address to associate with the instance in a VPC.
     */
    @JvmName("eeyxdbisnvjnptdy")
    public suspend fun privateIp(`value`: Output<String>) {
        this.privateIp = value
    }

    /**
     * @param value Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     */
    @JvmName("vylhjgpyflqstvag")
    public suspend fun rootBlockDevice(`value`: Output<SpotInstanceRequestRootBlockDeviceArgs>) {
        this.rootBlockDevice = value
    }

    /**
     * @param value List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     */
    @JvmName("llmkngcusvaukudx")
    public suspend fun secondaryPrivateIps(`value`: Output<List<String>>) {
        this.secondaryPrivateIps = value
    }

    @JvmName("gqaroxroajowilop")
    public suspend fun secondaryPrivateIps(vararg values: Output<String>) {
        this.secondaryPrivateIps = Output.all(values.asList())
    }

    /**
     * @param values List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     */
    @JvmName("sxjxaoyoviaqatga")
    public suspend fun secondaryPrivateIps(values: List<Output<String>>) {
        this.secondaryPrivateIps = Output.all(values)
    }

    /**
     * @param value List of security group names to associate with.
     * > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     */
    @JvmName("ktewmjlwtnddxhkq")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("hakjpbtmwqdutpdh")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values List of security group names to associate with.
     * > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     */
    @JvmName("lqlbdtfkbokvsewm")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
     */
    @JvmName("mmyexnexxffasvyk")
    public suspend fun sourceDestCheck(`value`: Output<Boolean>) {
        this.sourceDestCheck = value
    }

    /**
     * @param value The maximum price to request on the spot market.
     */
    @JvmName("yaybeetdhskkkmwb")
    public suspend fun spotPrice(`value`: Output<String>) {
        this.spotPrice = value
    }

    /**
     * @param value If set to `one-time`, after
     * the instance is terminated, the spot request will be closed.
     */
    @JvmName("ebvfudqovjtdgyus")
    public suspend fun spotType(`value`: Output<String>) {
        this.spotType = value
    }

    /**
     * @param value VPC Subnet ID to launch in.
     */
    @JvmName("kacnwyinpcxappcf")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mmuodqkmcfujxppq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     */
    @JvmName("exnrkugagtcivfne")
    public suspend fun tenancy(`value`: Output<String>) {
        this.tenancy = value
    }

    /**
     * @param value User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     */
    @JvmName("oyumtifxjufsqpgc")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     */
    @JvmName("dhcihoybvopkyhcw")
    public suspend fun userDataBase64(`value`: Output<String>) {
        this.userDataBase64 = value
    }

    /**
     * @param value When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
     */
    @JvmName("xkhgauujbpqrtqxt")
    public suspend fun userDataReplaceOnChange(`value`: Output<Boolean>) {
        this.userDataReplaceOnChange = value
    }

    /**
     * @param value The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     */
    @JvmName("xpviuprudsfodkpr")
    public suspend fun validFrom(`value`: Output<String>) {
        this.validFrom = value
    }

    /**
     * @param value The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request. The default end date is 7 days from the current date.
     */
    @JvmName("rrtsdebiljmqacqv")
    public suspend fun validUntil(`value`: Output<String>) {
        this.validUntil = value
    }

    /**
     * @param value Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     */
    @JvmName("auydtqvggjxqilvd")
    public suspend fun volumeTags(`value`: Output<Map<String, String>>) {
        this.volumeTags = value
    }

    /**
     * @param value List of security group IDs to associate with.
     */
    @JvmName("manwjgdedbkdkqqe")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("nvmavmjuraihlnwu")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of security group IDs to associate with.
     */
    @JvmName("cokkddahoredoawq")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value If set, this provider will
     * wait for the Spot Request to be fulfilled, and will throw an error if the
     * timeout of 10m is reached.
     */
    @JvmName("qjxffmkebkjlftgp")
    public suspend fun waitForFulfillment(`value`: Output<Boolean>) {
        this.waitForFulfillment = value
    }

    /**
     * @param value AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
     */
    @JvmName("wgmysfonncnrbcso")
    public suspend fun ami(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ami = mapped
    }

    /**
     * @param value Whether to associate a public IP address with an instance in a VPC.
     */
    @JvmName("pbhnbiktrmqhajej")
    public suspend fun associatePublicIpAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatePublicIpAddress = mapped
    }

    /**
     * @param value AZ to start the instance in.
     */
    @JvmName("oimoucsoighdnfqb")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The required duration for the Spot instances, in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).
     * The duration period starts as soon as your Spot instance receives its instance ID. At the end of the duration period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
     * Note that you can't specify an Availability Zone group or a launch group if you specify a duration.
     */
    @JvmName("kgxlwvfvrcxhlmse")
    public suspend fun blockDurationMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockDurationMinutes = mapped
    }

    /**
     * @param value Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * > **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     */
    @JvmName("thytlwramowkdeiw")
    public suspend
    fun capacityReservationSpecification(`value`: SpotInstanceRequestCapacityReservationSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationSpecification = mapped
    }

    /**
     * @param argument Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * > **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     */
    @JvmName("evlomcsgyeakajpt")
    public suspend
    fun capacityReservationSpecification(argument: suspend SpotInstanceRequestCapacityReservationSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = SpotInstanceRequestCapacityReservationSpecificationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.capacityReservationSpecification = mapped
    }

    /**
     * @param value Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     */
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    @JvmName("yadyupciplwrmbrf")
    public suspend fun cpuCoreCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuCoreCount = mapped
    }

    /**
     * @param value The CPU options for the instance. See CPU Options below for more details.
     */
    @JvmName("qvpbanodsmbgoler")
    public suspend fun cpuOptions(`value`: SpotInstanceRequestCpuOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuOptions = mapped
    }

    /**
     * @param argument The CPU options for the instance. See CPU Options below for more details.
     */
    @JvmName("opjhbjcsyfgfxcvh")
    public suspend
    fun cpuOptions(argument: suspend SpotInstanceRequestCpuOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = SpotInstanceRequestCpuOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cpuOptions = mapped
    }

    /**
     * @param value If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     */
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    @JvmName("aelbniwnhdbafqqd")
    public suspend fun cpuThreadsPerCore(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuThreadsPerCore = mapped
    }

    /**
     * @param value Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     */
    @JvmName("rppffsdltdygaxuc")
    public suspend fun creditSpecification(`value`: SpotInstanceRequestCreditSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creditSpecification = mapped
    }

    /**
     * @param argument Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     */
    @JvmName("sxsmmlkxojbshoim")
    public suspend
    fun creditSpecification(argument: suspend SpotInstanceRequestCreditSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = SpotInstanceRequestCreditSpecificationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.creditSpecification = mapped
    }

    /**
     * @param value If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     */
    @JvmName("duvtbexcricwushl")
    public suspend fun disableApiStop(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableApiStop = mapped
    }

    /**
     * @param value If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
     */
    @JvmName("byafvkuboolwpmfx")
    public suspend fun disableApiTermination(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableApiTermination = mapped
    }

    /**
     * @param value One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("vskjpgphvicncrmd")
    public suspend fun ebsBlockDevices(`value`: List<SpotInstanceRequestEbsBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("luetydisuouwpeke")
    public suspend
    fun ebsBlockDevices(argument: List<suspend SpotInstanceRequestEbsBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpotInstanceRequestEbsBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("xerfpegbpwmdxucl")
    public suspend fun ebsBlockDevices(
        vararg
        argument: suspend SpotInstanceRequestEbsBlockDeviceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SpotInstanceRequestEbsBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("lisaqaaxxqjjmueo")
    public suspend
    fun ebsBlockDevices(argument: suspend SpotInstanceRequestEbsBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SpotInstanceRequestEbsBlockDeviceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param values One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("dxjnjhrdxshliwii")
    public suspend fun ebsBlockDevices(vararg values: SpotInstanceRequestEbsBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param value If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
     */
    @JvmName("kdoodrokcvquuxgb")
    public suspend fun ebsOptimized(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsOptimized = mapped
    }

    /**
     * @param value Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     */
    @JvmName("xnymkepelisawpox")
    public suspend fun enclaveOptions(`value`: SpotInstanceRequestEnclaveOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enclaveOptions = mapped
    }

    /**
     * @param argument Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     */
    @JvmName("fcrxdoeacrarefjw")
    public suspend
    fun enclaveOptions(argument: suspend SpotInstanceRequestEnclaveOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = SpotInstanceRequestEnclaveOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.enclaveOptions = mapped
    }

    /**
     * @param value One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("afbgmbqppctqctll")
    public suspend
    fun ephemeralBlockDevices(`value`: List<SpotInstanceRequestEphemeralBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("vytrofdrygkhkvmc")
    public suspend
    fun ephemeralBlockDevices(argument: List<suspend SpotInstanceRequestEphemeralBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpotInstanceRequestEphemeralBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("kcabeyuywnogiaww")
    public suspend fun ephemeralBlockDevices(
        vararg
        argument: suspend SpotInstanceRequestEphemeralBlockDeviceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SpotInstanceRequestEphemeralBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("mrobgjosbdwwctbn")
    public suspend
    fun ephemeralBlockDevices(argument: suspend SpotInstanceRequestEphemeralBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SpotInstanceRequestEphemeralBlockDeviceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param values One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("lpvquxbcmlrbmphm")
    public suspend fun ephemeralBlockDevices(
        vararg
        values: SpotInstanceRequestEphemeralBlockDeviceArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param value If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     */
    @JvmName("fhwphvlajlbbwehs")
    public suspend fun getPasswordData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.getPasswordData = mapped
    }

    /**
     * @param value If true, the launched EC2 instance will support hibernation.
     */
    @JvmName("yjgetlqtxvlxlmqr")
    public suspend fun hibernation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hibernation = mapped
    }

    /**
     * @param value ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
     */
    @JvmName("oaopoyksikkpmuic")
    public suspend fun hostId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostId = mapped
    }

    /**
     * @param value ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
     */
    @JvmName("psqthckatkgxfckv")
    public suspend fun hostResourceGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostResourceGroupArn = mapped
    }

    /**
     * @param value IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
     */
    @JvmName("qfdqyffkqjtgiquv")
    public suspend fun iamInstanceProfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamInstanceProfile = mapped
    }

    /**
     * @param value Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
     */
    @JvmName("lexhdmwekrwkblwg")
    public suspend fun instanceInitiatedShutdownBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceInitiatedShutdownBehavior = mapped
    }

    /**
     * @param value Indicates Spot instance behavior when it is interrupted. Valid values are `terminate`, `stop`, or `hibernate`. Default value is `terminate`.
     */
    @JvmName("orotwaehhhhasfau")
    public suspend fun instanceInterruptionBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceInterruptionBehavior = mapped
    }

    /**
     * @param value Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     */
    @JvmName("ynyabwwcwehuxllr")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
     */
    @JvmName("gxexdinabudcyhht")
    public suspend fun ipv6AddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressCount = mapped
    }

    /**
     * @param value Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     */
    @JvmName("ueajiyxxpgheivoi")
    public suspend fun ipv6Addresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param values Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     */
    @JvmName("wfxqvcbxksiivljm")
    public suspend fun ipv6Addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param value Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
     */
    @JvmName("lptgtkwursttebpd")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value A launch group is a group of spot instances that launch together and terminate together.
     * If left empty instances are launched and terminated individually.
     */
    @JvmName("nddisfgwppcdafds")
    public suspend fun launchGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchGroup = mapped
    }

    /**
     * @param value Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     */
    @JvmName("yxymothwwcnteybr")
    public suspend fun launchTemplate(`value`: SpotInstanceRequestLaunchTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplate = mapped
    }

    /**
     * @param argument Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     */
    @JvmName("semkfkxqdsqqowpf")
    public suspend
    fun launchTemplate(argument: suspend SpotInstanceRequestLaunchTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = SpotInstanceRequestLaunchTemplateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.launchTemplate = mapped
    }

    /**
     * @param value Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     */
    @JvmName("piiaqdctcefxqips")
    public suspend fun maintenanceOptions(`value`: SpotInstanceRequestMaintenanceOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceOptions = mapped
    }

    /**
     * @param argument Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     */
    @JvmName("cdksacejlqvwlgjl")
    public suspend
    fun maintenanceOptions(argument: suspend SpotInstanceRequestMaintenanceOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = SpotInstanceRequestMaintenanceOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.maintenanceOptions = mapped
    }

    /**
     * @param value Customize the metadata options of the instance. See Metadata Options below for more details.
     */
    @JvmName("xkmlnkiedbojgfdt")
    public suspend fun metadataOptions(`value`: SpotInstanceRequestMetadataOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataOptions = mapped
    }

    /**
     * @param argument Customize the metadata options of the instance. See Metadata Options below for more details.
     */
    @JvmName("owqtcqoawyjchcja")
    public suspend
    fun metadataOptions(argument: suspend SpotInstanceRequestMetadataOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = SpotInstanceRequestMetadataOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.metadataOptions = mapped
    }

    /**
     * @param value If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
     */
    @JvmName("bjgchoxcewdwfool")
    public suspend fun monitoring(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoring = mapped
    }

    /**
     * @param value Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("tjrsqaeusaedfydj")
    public suspend fun networkInterfaces(`value`: List<SpotInstanceRequestNetworkInterfaceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("hqoaulpnlouqlmrv")
    public suspend
    fun networkInterfaces(argument: List<suspend SpotInstanceRequestNetworkInterfaceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpotInstanceRequestNetworkInterfaceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("vvcnbntpfgilnhfa")
    public suspend fun networkInterfaces(
        vararg
        argument: suspend SpotInstanceRequestNetworkInterfaceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SpotInstanceRequestNetworkInterfaceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("llebxrkyjumurxot")
    public suspend
    fun networkInterfaces(argument: suspend SpotInstanceRequestNetworkInterfaceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SpotInstanceRequestNetworkInterfaceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param values Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("fppyjifbwrujbwhy")
    public suspend fun networkInterfaces(vararg values: SpotInstanceRequestNetworkInterfaceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param value Placement Group to start the instance in.
     */
    @JvmName("httlbkdbsyedrkmk")
    public suspend fun placementGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementGroup = mapped
    }

    /**
     * @param value Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
     */
    @JvmName("dsefuxxaviiktmso")
    public suspend fun placementPartitionNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementPartitionNumber = mapped
    }

    /**
     * @param value Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     */
    @JvmName("gtcqjoplqvtoqmfj")
    public suspend fun privateDnsNameOptions(`value`: SpotInstanceRequestPrivateDnsNameOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDnsNameOptions = mapped
    }

    /**
     * @param argument Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     */
    @JvmName("kibvdeishxvtdttw")
    public suspend
    fun privateDnsNameOptions(argument: suspend SpotInstanceRequestPrivateDnsNameOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = SpotInstanceRequestPrivateDnsNameOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateDnsNameOptions = mapped
    }

    /**
     * @param value Private IP address to associate with the instance in a VPC.
     */
    @JvmName("qhbdjhrppjxgchhk")
    public suspend fun privateIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIp = mapped
    }

    /**
     * @param value Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     */
    @JvmName("abhqahujwhsnpcnh")
    public suspend fun rootBlockDevice(`value`: SpotInstanceRequestRootBlockDeviceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootBlockDevice = mapped
    }

    /**
     * @param argument Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     */
    @JvmName("quxnugintxfyowts")
    public suspend
    fun rootBlockDevice(argument: suspend SpotInstanceRequestRootBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = SpotInstanceRequestRootBlockDeviceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rootBlockDevice = mapped
    }

    /**
     * @param value List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     */
    @JvmName("okstdukiifjnjavr")
    public suspend fun secondaryPrivateIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryPrivateIps = mapped
    }

    /**
     * @param values List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     */
    @JvmName("badhnqhrpdqygrev")
    public suspend fun secondaryPrivateIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryPrivateIps = mapped
    }

    /**
     * @param value List of security group names to associate with.
     * > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     */
    @JvmName("ennjlxsjqlmywwwx")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values List of security group names to associate with.
     * > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     */
    @JvmName("ggayubugwcvpywdw")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
     */
    @JvmName("gwptgpwumrppwuur")
    public suspend fun sourceDestCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDestCheck = mapped
    }

    /**
     * @param value The maximum price to request on the spot market.
     */
    @JvmName("cybuhdmfkikjbjhk")
    public suspend fun spotPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPrice = mapped
    }

    /**
     * @param value If set to `one-time`, after
     * the instance is terminated, the spot request will be closed.
     */
    @JvmName("rkhdedvhjhbtjgqt")
    public suspend fun spotType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotType = mapped
    }

    /**
     * @param value VPC Subnet ID to launch in.
     */
    @JvmName("pruhslfwpwjeqfyf")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("shaquqykeothhdvt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qxufxvpljmtrgslf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     */
    @JvmName("otogdmueaquwyviu")
    public suspend fun tenancy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenancy = mapped
    }

    /**
     * @param value User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     */
    @JvmName("yshnkivdaqfncbfg")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     */
    @JvmName("twrpbhdiglhmkdem")
    public suspend fun userDataBase64(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDataBase64 = mapped
    }

    /**
     * @param value When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
     */
    @JvmName("tctjwgwcpepakpkk")
    public suspend fun userDataReplaceOnChange(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDataReplaceOnChange = mapped
    }

    /**
     * @param value The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     */
    @JvmName("hmktbmvsknjllhud")
    public suspend fun validFrom(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validFrom = mapped
    }

    /**
     * @param value The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request. The default end date is 7 days from the current date.
     */
    @JvmName("mfqtanxireladmmi")
    public suspend fun validUntil(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validUntil = mapped
    }

    /**
     * @param value Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     */
    @JvmName("grgwpwdqfppnkavr")
    public suspend fun volumeTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeTags = mapped
    }

    /**
     * @param values Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     */
    @JvmName("tsmiogofvuschkwa")
    public fun volumeTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeTags = mapped
    }

    /**
     * @param value List of security group IDs to associate with.
     */
    @JvmName("ggqtkipcvhuhsjts")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values List of security group IDs to associate with.
     */
    @JvmName("xaochllafubjhgan")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param value If set, this provider will
     * wait for the Spot Request to be fulfilled, and will throw an error if the
     * timeout of 10m is reached.
     */
    @JvmName("isibtxbanvxvyecd")
    public suspend fun waitForFulfillment(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForFulfillment = mapped
    }

    internal fun build(): SpotInstanceRequestArgs = SpotInstanceRequestArgs(
        ami = ami,
        associatePublicIpAddress = associatePublicIpAddress,
        availabilityZone = availabilityZone,
        blockDurationMinutes = blockDurationMinutes,
        capacityReservationSpecification = capacityReservationSpecification,
        cpuCoreCount = cpuCoreCount,
        cpuOptions = cpuOptions,
        cpuThreadsPerCore = cpuThreadsPerCore,
        creditSpecification = creditSpecification,
        disableApiStop = disableApiStop,
        disableApiTermination = disableApiTermination,
        ebsBlockDevices = ebsBlockDevices,
        ebsOptimized = ebsOptimized,
        enclaveOptions = enclaveOptions,
        ephemeralBlockDevices = ephemeralBlockDevices,
        getPasswordData = getPasswordData,
        hibernation = hibernation,
        hostId = hostId,
        hostResourceGroupArn = hostResourceGroupArn,
        iamInstanceProfile = iamInstanceProfile,
        instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior,
        instanceInterruptionBehavior = instanceInterruptionBehavior,
        instanceType = instanceType,
        ipv6AddressCount = ipv6AddressCount,
        ipv6Addresses = ipv6Addresses,
        keyName = keyName,
        launchGroup = launchGroup,
        launchTemplate = launchTemplate,
        maintenanceOptions = maintenanceOptions,
        metadataOptions = metadataOptions,
        monitoring = monitoring,
        networkInterfaces = networkInterfaces,
        placementGroup = placementGroup,
        placementPartitionNumber = placementPartitionNumber,
        privateDnsNameOptions = privateDnsNameOptions,
        privateIp = privateIp,
        rootBlockDevice = rootBlockDevice,
        secondaryPrivateIps = secondaryPrivateIps,
        securityGroups = securityGroups,
        sourceDestCheck = sourceDestCheck,
        spotPrice = spotPrice,
        spotType = spotType,
        subnetId = subnetId,
        tags = tags,
        tenancy = tenancy,
        userData = userData,
        userDataBase64 = userDataBase64,
        userDataReplaceOnChange = userDataReplaceOnChange,
        validFrom = validFrom,
        validUntil = validUntil,
        volumeTags = volumeTags,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
        waitForFulfillment = waitForFulfillment,
    )
}
