@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Subnet].
 */
@PulumiTagMarker
public class SubnetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubnetArgs = SubnetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubnetArgsBuilder.() -> Unit) {
        val builder = SubnetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Subnet {
        val builtJavaResource = com.pulumi.aws.ec2.Subnet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Subnet(builtJavaResource)
    }
}

/**
 * Provides an VPC subnet resource.
 * > **NOTE:** Due to [AWS Lambda improved VPC networking changes that began deploying in September 2019](https://aws.amazon.com/blogs/compute/announcing-improved-vpc-networking-for-aws-lambda-functions/), subnets associated with Lambda Functions can take up to 45 minutes to successfully delete.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Subnet("main", SubnetArgs.builder()
 *             .vpcId(aws_vpc.main().id())
 *             .cidrBlock("10.0.1.0/24")
 *             .tags(Map.of("Name", "Main"))
 *             .build());
 *     }
 * }
 * ```
 * ### Subnets In Secondary VPC CIDR Blocks
 * When managing subnets in one of a VPC's secondary CIDR blocks created using a `aws.ec2.VpcIpv4CidrBlockAssociation`
 * resource, it is recommended to reference that resource's `vpc_id` attribute to ensure correct dependency ordering.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociation;
 * import com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociationArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var secondaryCidr = new VpcIpv4CidrBlockAssociation("secondaryCidr", VpcIpv4CidrBlockAssociationArgs.builder()
 *             .vpcId(aws_vpc.main().id())
 *             .cidrBlock("172.20.0.0/16")
 *             .build());
 *         var inSecondaryCidr = new Subnet("inSecondaryCidr", SubnetArgs.builder()
 *             .vpcId(secondaryCidr.vpcId())
 *             .cidrBlock("172.20.0.0/24")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import subnets using the subnet `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/subnet:Subnet public_subnet subnet-9d4a7b6c
 * ```
 *
 */
public class Subnet internal constructor(
    override val javaResource: com.pulumi.aws.ec2.Subnet,
) : KotlinCustomResource(javaResource, SubnetMapper) {
    /**
     * The ARN of the subnet.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specify true to indicate
     * that network interfaces created in the specified subnet should be
     * assigned an IPv6 address. Default is `false`
     */
    public val assignIpv6AddressOnCreation: Output<Boolean>?
        get() = javaResource.assignIpv6AddressOnCreation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * AZ for the subnet.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * AZ ID of the subnet. This argument is not supported in all regions or partitions. If necessary, use `availability_zone` instead.
     */
    public val availabilityZoneId: Output<String>
        get() = javaResource.availabilityZoneId().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR block for the subnet.
     */
    public val cidrBlock: Output<String>?
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The customer owned IPv4 address pool. Typically used with the `map_customer_owned_ip_on_launch` argument. The `outpost_arn` argument must be specified when configured.
     */
    public val customerOwnedIpv4Pool: Output<String>?
        get() = javaResource.customerOwnedIpv4Pool().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations. Default: `false`.
     */
    public val enableDns64: Output<Boolean>?
        get() = javaResource.enableDns64().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates the device position for local network interfaces in this subnet. For example, 1 indicates local network interfaces in this subnet are the secondary network interface (eth1). A local network interface cannot be the primary network interface (eth0).
     */
    public val enableLniAtDeviceIndex: Output<Int>?
        get() = javaResource.enableLniAtDeviceIndex().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether to respond to DNS queries for instance hostnames with DNS A records. Default: `false`.
     */
    public val enableResourceNameDnsARecordOnLaunch: Output<Boolean>?
        get() = javaResource.enableResourceNameDnsARecordOnLaunch().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records. Default: `false`.
     */
    public val enableResourceNameDnsAaaaRecordOnLaunch: Output<Boolean>?
        get() = javaResource.enableResourceNameDnsAaaaRecordOnLaunch().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The IPv6 network range for the subnet,
     * in CIDR notation. The subnet size must use a /64 prefix length.
     */
    public val ipv6CidrBlock: Output<String>?
        get() = javaResource.ipv6CidrBlock().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The association ID for the IPv6 CIDR block.
     */
    public val ipv6CidrBlockAssociationId: Output<String>
        get() = javaResource.ipv6CidrBlockAssociationId().applyValue({ args0 -> args0 })

    /**
     * Indicates whether to create an IPv6-only subnet. Default: `false`.
     */
    public val ipv6Native: Output<Boolean>?
        get() = javaResource.ipv6Native().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specify `true` to indicate that network interfaces created in the subnet should be assigned a customer owned IP address. The `customer_owned_ipv4_pool` and `outpost_arn` arguments must be specified when set to `true`. Default is `false`.
     */
    public val mapCustomerOwnedIpOnLaunch: Output<Boolean>?
        get() = javaResource.mapCustomerOwnedIpOnLaunch().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specify true to indicate
     * that instances launched into the subnet should be assigned
     * a public IP address. Default is `false`.
     */
    public val mapPublicIpOnLaunch: Output<Boolean>?
        get() = javaResource.mapPublicIpOnLaunch().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    public val outpostArn: Output<String>?
        get() = javaResource.outpostArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the AWS account that owns the subnet.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * The type of hostnames to assign to instances in the subnet at launch. For IPv6-only subnets, an instance DNS name must be based on the instance ID. For dual-stack and IPv4-only subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. Valid values: `ip-name`, `resource-name`.
     */
    public val privateDnsHostnameTypeOnLaunch: Output<String>
        get() = javaResource.privateDnsHostnameTypeOnLaunch().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The VPC ID.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object SubnetMapper : ResourceMapper<Subnet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.Subnet::class == javaResource::class

    override fun map(javaResource: Resource): Subnet = Subnet(
        javaResource as
            com.pulumi.aws.ec2.Subnet,
    )
}

/**
 * @see [Subnet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Subnet].
 */
public suspend fun subnet(name: String, block: suspend SubnetResourceBuilder.() -> Unit): Subnet {
    val builder = SubnetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Subnet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subnet(name: String): Subnet {
    val builder = SubnetResourceBuilder()
    builder.name(name)
    return builder.build()
}
