@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.SubnetCidrReservationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a subnet CIDR reservation resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SubnetCidrReservation;
 * import com.pulumi.aws.ec2.SubnetCidrReservationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SubnetCidrReservation("example", SubnetCidrReservationArgs.builder()
 *             .cidrBlock("10.0.0.16/28")
 *             .reservationType("prefix")
 *             .subnetId(aws_subnet.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Existing CIDR reservations using `SUBNET_ID:RESERVATION_ID`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/subnetCidrReservation:SubnetCidrReservation example subnet-01llsxvsxabqiymcz:scr-4mnvz6wb7otksjcs9
 * ```
 * @property cidrBlock The CIDR block for the reservation.
 * @property description A brief description of the reservation.
 * @property reservationType The type of reservation to create. Valid values: `explicit`, `prefix`
 * @property subnetId The ID of the subnet to create the reservation for.
 */
public data class SubnetCidrReservationArgs(
    public val cidrBlock: Output<String>? = null,
    public val description: Output<String>? = null,
    public val reservationType: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.SubnetCidrReservationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.SubnetCidrReservationArgs =
        com.pulumi.aws.ec2.SubnetCidrReservationArgs.builder()
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .reservationType(reservationType?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetCidrReservationArgs].
 */
@PulumiTagMarker
public class SubnetCidrReservationArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var description: Output<String>? = null

    private var reservationType: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The CIDR block for the reservation.
     */
    @JvmName("bsuqdhnkborynhfk")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value A brief description of the reservation.
     */
    @JvmName("smutamshfnxipwuk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The type of reservation to create. Valid values: `explicit`, `prefix`
     */
    @JvmName("upvnmkvproialulx")
    public suspend fun reservationType(`value`: Output<String>) {
        this.reservationType = value
    }

    /**
     * @param value The ID of the subnet to create the reservation for.
     */
    @JvmName("wsuwlabpncnncgkt")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The CIDR block for the reservation.
     */
    @JvmName("blthwepajxuexfju")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value A brief description of the reservation.
     */
    @JvmName("djfjfbnqhlsudrmc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The type of reservation to create. Valid values: `explicit`, `prefix`
     */
    @JvmName("iypneepobevfytme")
    public suspend fun reservationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservationType = mapped
    }

    /**
     * @param value The ID of the subnet to create the reservation for.
     */
    @JvmName("atoktlomvebhykpu")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): SubnetCidrReservationArgs = SubnetCidrReservationArgs(
        cidrBlock = cidrBlock,
        description = description,
        reservationType = reservationType,
        subnetId = subnetId,
    )
}
