@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.TagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an individual EC2 resource tag. This resource should only be used in cases where EC2 resources are created outside the provider (e.g. AMIs), being shared via Resource Access Manager (RAM), or implicitly created by other means (e.g. Transit Gateway VPN Attachments).
 * > **NOTE:** This tagging resource should not be combined with the providers resource for managing the parent resource. For example, using `aws.ec2.Vpc` and `aws.ec2.Tag` to manage tags of the same VPC will cause a perpetual difference where the `aws.ec2.Vpc` resource will try to remove the tag being added by the `aws.ec2.Tag` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import com.pulumi.aws.ec2.VpnConnection;
 * import com.pulumi.aws.ec2.VpnConnectionArgs;
 * import com.pulumi.aws.ec2.Tag;
 * import com.pulumi.aws.ec2.TagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleTransitGateway = new TransitGateway("exampleTransitGateway");
 *         var exampleCustomerGateway = new CustomerGateway("exampleCustomerGateway", CustomerGatewayArgs.builder()
 *             .bgpAsn(65000)
 *             .ipAddress("172.0.0.1")
 *             .type("ipsec.1")
 *             .build());
 *         var exampleVpnConnection = new VpnConnection("exampleVpnConnection", VpnConnectionArgs.builder()
 *             .customerGatewayId(exampleCustomerGateway.id())
 *             .transitGatewayId(exampleTransitGateway.id())
 *             .type(exampleCustomerGateway.type())
 *             .build());
 *         var exampleTag = new Tag("exampleTag", TagArgs.builder()
 *             .resourceId(exampleVpnConnection.transitGatewayAttachmentId())
 *             .key("Name")
 *             .value("Hello World")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_tag` using the EC2 resource identifier and key, separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ec2/tag:Tag example tgw-attach-1234567890abcdef,Name
 * ```
 * @property key The tag name.
 * @property resourceId The ID of the EC2 resource to manage the tag for.
 * @property value The value of the tag.
 */
public data class TagArgs(
    public val key: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.TagArgs> {
    override fun toJava(): com.pulumi.aws.ec2.TagArgs = com.pulumi.aws.ec2.TagArgs.builder()
        .key(key?.applyValue({ args0 -> args0 }))
        .resourceId(resourceId?.applyValue({ args0 -> args0 }))
        .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagArgs].
 */
@PulumiTagMarker
public class TagArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The tag name.
     */
    @JvmName("qlrpifjlsnoetifv")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The ID of the EC2 resource to manage the tag for.
     */
    @JvmName("bvfolfvpoyjarahv")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The value of the tag.
     */
    @JvmName("axrhgwhqbqivhclb")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The tag name.
     */
    @JvmName("pxjsojbcikfbfolh")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The ID of the EC2 resource to manage the tag for.
     */
    @JvmName("vnxvyaqrvpumrdfh")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The value of the tag.
     */
    @JvmName("ndfrgeqrveujcilr")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TagArgs = TagArgs(
        key = key,
        resourceId = resourceId,
        `value` = `value`,
    )
}
