@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [TrafficMirrorFilter].
 */
@PulumiTagMarker
public class TrafficMirrorFilterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrafficMirrorFilterArgs = TrafficMirrorFilterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrafficMirrorFilterArgsBuilder.() -> Unit) {
        val builder = TrafficMirrorFilterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TrafficMirrorFilter {
        val builtJavaResource = com.pulumi.aws.ec2.TrafficMirrorFilter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrafficMirrorFilter(builtJavaResource)
    }
}

/**
 * Provides an Traffic mirror filter.
 * Read [limits and considerations](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html) for traffic mirroring
 * ## Example Usage
 * To create a basic traffic mirror filter
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.TrafficMirrorFilter;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new TrafficMirrorFilter("foo", TrafficMirrorFilterArgs.builder()
 *             .description("traffic mirror filter - example")
 *             .networkServices("amazon-dns")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import traffic mirror filter using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/trafficMirrorFilter:TrafficMirrorFilter foo tmf-0fbb93ddf38198f64
 * ```
 *
 */
public class TrafficMirrorFilter internal constructor(
    override val javaResource: com.pulumi.aws.ec2.TrafficMirrorFilter,
) : KotlinCustomResource(javaResource, TrafficMirrorFilterMapper) {
    /**
     * The ARN of the traffic mirror filter.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description of the filter.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of amazon network services that should be mirrored. Valid values: `amazon-dns`.
     */
    public val networkServices: Output<List<String>>?
        get() = javaResource.networkServices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object TrafficMirrorFilterMapper : ResourceMapper<TrafficMirrorFilter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.TrafficMirrorFilter::class == javaResource::class

    override fun map(javaResource: Resource): TrafficMirrorFilter = TrafficMirrorFilter(
        javaResource
            as com.pulumi.aws.ec2.TrafficMirrorFilter,
    )
}

/**
 * @see [TrafficMirrorFilter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrafficMirrorFilter].
 */
public suspend fun trafficMirrorFilter(
    name: String,
    block: suspend TrafficMirrorFilterResourceBuilder.() -> Unit,
): TrafficMirrorFilter {
    val builder = TrafficMirrorFilterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrafficMirrorFilter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trafficMirrorFilter(name: String): TrafficMirrorFilter {
    val builder = TrafficMirrorFilterResourceBuilder()
    builder.name(name)
    return builder.build()
}
