@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.TrafficMirrorFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Traffic mirror filter.
 * Read [limits and considerations](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html) for traffic mirroring
 * ## Example Usage
 * To create a basic traffic mirror filter
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.TrafficMirrorFilter;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new TrafficMirrorFilter("foo", TrafficMirrorFilterArgs.builder()
 *             .description("traffic mirror filter - example")
 *             .networkServices("amazon-dns")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import traffic mirror filter using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/trafficMirrorFilter:TrafficMirrorFilter foo tmf-0fbb93ddf38198f64
 * ```
 * @property description A description of the filter.
 * @property networkServices List of amazon network services that should be mirrored. Valid values: `amazon-dns`.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class TrafficMirrorFilterArgs(
    public val description: Output<String>? = null,
    public val networkServices: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.TrafficMirrorFilterArgs> {
    override fun toJava(): com.pulumi.aws.ec2.TrafficMirrorFilterArgs =
        com.pulumi.aws.ec2.TrafficMirrorFilterArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .networkServices(networkServices?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TrafficMirrorFilterArgs].
 */
@PulumiTagMarker
public class TrafficMirrorFilterArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var networkServices: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description of the filter.
     */
    @JvmName("ofbgmlouaglhshqj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of amazon network services that should be mirrored. Valid values: `amazon-dns`.
     */
    @JvmName("dmbuenrcvmfieyrw")
    public suspend fun networkServices(`value`: Output<List<String>>) {
        this.networkServices = value
    }

    @JvmName("aofxcbcmypychkhd")
    public suspend fun networkServices(vararg values: Output<String>) {
        this.networkServices = Output.all(values.asList())
    }

    /**
     * @param values List of amazon network services that should be mirrored. Valid values: `amazon-dns`.
     */
    @JvmName("vkynrygstckuvusb")
    public suspend fun networkServices(values: List<Output<String>>) {
        this.networkServices = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("etmcodifuhfudreu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description of the filter.
     */
    @JvmName("fdkekyfhhmqiubsn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of amazon network services that should be mirrored. Valid values: `amazon-dns`.
     */
    @JvmName("omnducduksxtttev")
    public suspend fun networkServices(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkServices = mapped
    }

    /**
     * @param values List of amazon network services that should be mirrored. Valid values: `amazon-dns`.
     */
    @JvmName("qtnyxaiwpmrvbjya")
    public suspend fun networkServices(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkServices = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qepmbdrpxosgeyef")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dswfeggkvmqxeiii")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TrafficMirrorFilterArgs = TrafficMirrorFilterArgs(
        description = description,
        networkServices = networkServices,
        tags = tags,
    )
}
