@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.TrafficMirrorFilterRuleDestinationPortRange
import com.pulumi.aws.ec2.kotlin.outputs.TrafficMirrorFilterRuleSourcePortRange
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.ec2.kotlin.outputs.TrafficMirrorFilterRuleDestinationPortRange.Companion.toKotlin as trafficMirrorFilterRuleDestinationPortRangeToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.TrafficMirrorFilterRuleSourcePortRange.Companion.toKotlin as trafficMirrorFilterRuleSourcePortRangeToKotlin

/**
 * Builder for [TrafficMirrorFilterRule].
 */
@PulumiTagMarker
public class TrafficMirrorFilterRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrafficMirrorFilterRuleArgs = TrafficMirrorFilterRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrafficMirrorFilterRuleArgsBuilder.() -> Unit) {
        val builder = TrafficMirrorFilterRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TrafficMirrorFilterRule {
        val builtJavaResource = com.pulumi.aws.ec2.TrafficMirrorFilterRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrafficMirrorFilterRule(builtJavaResource)
    }
}

/**
 * Provides an Traffic mirror filter rule.
 * Read [limits and considerations](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html) for traffic mirroring
 * ## Example Usage
 * To create a basic traffic mirror session
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.TrafficMirrorFilter;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterArgs;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterRule;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterRuleArgs;
 * import com.pulumi.aws.ec2.inputs.TrafficMirrorFilterRuleDestinationPortRangeArgs;
 * import com.pulumi.aws.ec2.inputs.TrafficMirrorFilterRuleSourcePortRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var filter = new TrafficMirrorFilter("filter", TrafficMirrorFilterArgs.builder()
 *             .description("traffic mirror filter - example")
 *             .networkServices("amazon-dns")
 *             .build());
 *         var ruleout = new TrafficMirrorFilterRule("ruleout", TrafficMirrorFilterRuleArgs.builder()
 *             .description("test rule")
 *             .trafficMirrorFilterId(filter.id())
 *             .destinationCidrBlock("10.0.0.0/8")
 *             .sourceCidrBlock("10.0.0.0/8")
 *             .ruleNumber(1)
 *             .ruleAction("accept")
 *             .trafficDirection("egress")
 *             .build());
 *         var rulein = new TrafficMirrorFilterRule("rulein", TrafficMirrorFilterRuleArgs.builder()
 *             .description("test rule")
 *             .trafficMirrorFilterId(filter.id())
 *             .destinationCidrBlock("10.0.0.0/8")
 *             .sourceCidrBlock("10.0.0.0/8")
 *             .ruleNumber(1)
 *             .ruleAction("accept")
 *             .trafficDirection("ingress")
 *             .protocol(6)
 *             .destinationPortRange(TrafficMirrorFilterRuleDestinationPortRangeArgs.builder()
 *                 .fromPort(22)
 *                 .toPort(53)
 *                 .build())
 *             .sourcePortRange(TrafficMirrorFilterRuleSourcePortRangeArgs.builder()
 *                 .fromPort(0)
 *                 .toPort(10)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import traffic mirror rules using the `traffic_mirror_filter_id` and `id` separated by `:`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/trafficMirrorFilterRule:TrafficMirrorFilterRule rule tmf-0fbb93ddf38198f64:tmfr-05a458f06445d0aee
 * ```
 *
 */
public class TrafficMirrorFilterRule internal constructor(
    override val javaResource: com.pulumi.aws.ec2.TrafficMirrorFilterRule,
) : KotlinCustomResource(javaResource, TrafficMirrorFilterRuleMapper) {
    /**
     * ARN of the traffic mirror filter rule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the traffic mirror filter rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Destination CIDR block to assign to the Traffic Mirror rule.
     */
    public val destinationCidrBlock: Output<String>
        get() = javaResource.destinationCidrBlock().applyValue({ args0 -> args0 })

    /**
     * Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     */
    public val destinationPortRange: Output<TrafficMirrorFilterRuleDestinationPortRange>?
        get() = javaResource.destinationPortRange().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    trafficMirrorFilterRuleDestinationPortRangeToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
     */
    public val protocol: Output<Int>?
        get() = javaResource.protocol().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
     */
    public val ruleAction: Output<String>
        get() = javaResource.ruleAction().applyValue({ args0 -> args0 })

    /**
     * Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
     */
    public val ruleNumber: Output<Int>
        get() = javaResource.ruleNumber().applyValue({ args0 -> args0 })

    /**
     * Source CIDR block to assign to the Traffic Mirror rule.
     */
    public val sourceCidrBlock: Output<String>
        get() = javaResource.sourceCidrBlock().applyValue({ args0 -> args0 })

    /**
     * Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     */
    public val sourcePortRange: Output<TrafficMirrorFilterRuleSourcePortRange>?
        get() = javaResource.sourcePortRange().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> trafficMirrorFilterRuleSourcePortRangeToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Direction of traffic to be captured. Valid values are `ingress` and `egress`
     * Traffic mirror port range support following attributes:
     */
    public val trafficDirection: Output<String>
        get() = javaResource.trafficDirection().applyValue({ args0 -> args0 })

    /**
     * ID of the traffic mirror filter to which this rule should be added
     */
    public val trafficMirrorFilterId: Output<String>
        get() = javaResource.trafficMirrorFilterId().applyValue({ args0 -> args0 })
}

public object TrafficMirrorFilterRuleMapper : ResourceMapper<TrafficMirrorFilterRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.TrafficMirrorFilterRule::class == javaResource::class

    override fun map(javaResource: Resource): TrafficMirrorFilterRule =
        TrafficMirrorFilterRule(javaResource as com.pulumi.aws.ec2.TrafficMirrorFilterRule)
}

/**
 * @see [TrafficMirrorFilterRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrafficMirrorFilterRule].
 */
public suspend fun trafficMirrorFilterRule(
    name: String,
    block: suspend TrafficMirrorFilterRuleResourceBuilder.() -> Unit,
): TrafficMirrorFilterRule {
    val builder = TrafficMirrorFilterRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrafficMirrorFilterRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trafficMirrorFilterRule(name: String): TrafficMirrorFilterRule {
    val builder = TrafficMirrorFilterRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
